;	SCCSID = @(#)msgfequ.inc	6.3 91/04/01
;	SCCSID = @(#)msgfequ.inc	6.3 91/04/01

;***********************************************************************
; MSGFEQU.INC:	EQUATE LIBRARY FOR DOSGET/PUTMESSAGE
;***********************************************************************
;   Modification history
;
;  4-23 	changed openmode from a0a0h to 20a0h.
;		(from "direct open" to "file open")
;  6-6		change fail bit to give control to critical error handler
;  8-19 	add component ID field to SAVE structure in order to return
;		component ID when retrieve error/warning message
;
;  11-7 	add System Trace Major/Minor Envent Codes
;
;  4-21-87	add ? (unknown message class)
;
;B001 PB717389 Add TRACE support for DosQueryMessage
;***********************************************************************

; ***********************************************************************
;	EQUATES
; ***********************************************************************
INCLUDE ..\..\DOS\DOSINC\CURDIR.INC

SCREEN_WIDTH	EQU	80		;SCREEN_WIDTH = 80
DBCS_ENV_SIZE	EQU	10		;DBCS ENVIRONMENT VECTOR SIZE = 10
ASCIIZ_LEN	EQU	MAXPATHLEN	;MAX ASCIIZ LENGTH
component_length    EQU     3		;component ID length
;
;			DWFRRRRRISSSRAAA
OPENMODE	EQU	0000000010100000B	;D = FILE OPEN
						;W = WRITE-THROUGH THRU CACHE (DON'T CARE)
						;F = HARD ERROR -> GIVE TO CRITICAL ERROR HANDLER
						;I = PRIVATE HANDLE
						;SSS = DENY WRITE
						;AAA = READ ONLY
MSG_TEXT_HEADER_SIZE	EQU	9		;'XXXyyyyZ:' HEADER IN MSG TEXT
						;where XXX = COMPONENT ID
						;     yyyy = MSG NUMBER
						;	 Z = ERROR CLASS
;
LF		EQU	10
CR		EQU	13
;
BOUNDHDRSIZE	EQU	16			;DCR900
;;;;;  DCR361
CP_LENGTH	EQU	6			;Define length 6 for cplist
CP_ALL		EQU	16			;Total 16 pages

;
;  Error classes used to display Message ID
;  ----------------------------------------
error_class	equ	'E'                     ;'E' for error msg class (ascii 69)
warning_class	equ	'W'                     ;'W' for warning msg class (ascii 87)
unknown_class	equ	'?'                     ;'?' for unknown msg class (ascii 63)

;  System Trace Major/Minor Envent Codes
;  -------------------------------------
TraceCode_Message	   equ	83h		; Message Retriever major code
TraceCode_PreGetMessage    equ	01h
TraceCode_PostGetMessage   equ	81h
TraceCode_PreInsMessage    equ	02h
TraceCode_PostInsMessage   equ	82h
TraceCode_PrePutMessage    equ	03h
TraceCode_PostPutMessage   equ	83h
TraceCode_PreQryMessage    equ	04h		  ;BN001;
TraceCode_PostQryMessage   equ	84h		  ;BN001;

; **********************************************************************
; STRUCTURES
; **********************************************************************
;  Message file header
;  -------------------
HEADER	STRUC					;MSG FILE HEADER
	SIGNATURE_H	DB	8 DUP (?)	;SIGNATURE MARK
	COMPONENT_ID	DB	3 DUP (?)	;COMPONENT ID
	MSG_COUNT	DW	?		;NUMBER OF MESSAGES
	BASE_MID	DW	?		;BASE MESSAGE NUMBER
	INDICATOR	DB	?		;TYPE, 1=WORD OFFSET
						;      0=DWORD OFFSET
	VERSION 	DW	?		;VERSION NUMBER
	HEADER_LENGTH	DW	?		;LENGTH OF HEADER IN BYTES
	CP_DATA 	DW	?		;OFFSET TO CODE PAGEs OF FILE
	EXT_HEADER	DD	?		;OFFSET TO EXT.HEADER IF<>0
	RESERVED	DB	5 DUP(?)	;RESERVED
HEADER	ENDS

; **********************************************************************
;  Message file extended message file definition record
;  ----------------------------------------------------
EXTREC	STRUC					;MSG FILE EXTENDED HEADER
	REC_CP_TYPE	DB	?		;1 = SBCS, 2 = DBCS
	REC_CNTY_ID	DW	?		;COUNTRY ID
	REC_LANG_ID	DW	?		;LANGUAGE FAMILY ID
	REC_LANG_VERID	DW	?		;LANGUAGE VERSION ID
	REC_CNT_CP	DW	?		;CODE PAGE COUNT
	REC_CP_ID	DW	16 dup (0)	;CODE PAGE IDs
	REC_FILENAME	DB	ASCIIZ_LEN dup(?),0   ;FILE NAME
EXTREC	ENDS

; **********************************************************************
;  Message file extended header
;  ----------------------------
EXT_HDR STRUC					;MSG FILE EXTENDED HEADER
	EXT_HDR_LNG	DW	?		;EXT HEADER LENGTH
	EXT_NUM_DEF_REC DW	?		;EXT NUMBER OF DEFINITION RECs
EXT_HDR ENDS

;
;  Structure in which to save message file related information
;  -----------------------------------------------------------
SAVE	STRUC					;WHERE SAVE FILENAME & HANDLE
	FILENAME_S	DB	ASCIIZ_LEN DUP (?),0   ;SAVED FILENAME
	HANDLE_S	DW	?		;SAVED HANDLE
	COMPONENT_S	db	3 dup (?)	;SAVED component id
	MSG_COUNT_S	DW	?		;SAVED MSG_COUNT
	BASE_MID_S	DW	?		;SAVED BASE_MID
	INDICATOR_S	DB	?		;SAVED INDICATOR BYTE (LONG/SHORT MSG OFFSET)
	VERSION_S	DW	?		;VERSION NUMBER
	HDR_LNG_S	DW	?		;LENGTH OF HEADER IN BYTES
	CP_DATA_S	DW	?		;OFFSET TO CODE PAGEs OF FILE
	EXT_HDR_S	DD	?		;OFFSET TO EXT.HEADER IF<>0
	CNTY_ID_S	DW	?		;SAVED COUNTRY ID
	LANG_FID_S	DW	?		;SAVED LANGUAGE FAMILY ID
	LANG_VID_S	DW	?		;SAVED LANGUAGE VERSION ID
	CPCOUNT_S	DW	?		;SAVED CODE PAGE COUNT
	CP_S		DW	16 dup (0)	;SAVED CODE PAGEs
	NEXT_SAVE	DW	?	; Pointer to next SAVE struc DCR 704
SAVE	ENDS

