/*
   Created by Snow Storm Software
    (c) Copyright SLY Industries Inc., 1992.  All Rights Reserved.

   Command:  INSTALL
*/

/* Register REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCls

Say
Say '<<<  Snow Storm Software Installation Utility  >>>'
Say

/* Initialize Variables */
Source = "A:\"
Target = "C:\BZ"
finished = "Y"

do until finished = 'Y'
   /* Get target directory. */
   Say
   Call Prompt 'Please enter the target drive and directory (default 'Target'):'
   Pull NewTarget

   /* Default Check */
   If NewTarget <> " " then
      Target = NewTarget

   /* Get source directory. */
   Say
   Call Prompt 'Please enter the source drive and directory (default 'Source'):'
   Pull NewSource

   /* Default Check */
   If NewSource <> " " then
      Source = NewSource

   /* Request confirmation of selections */
   Call SysCls
   Say
   Say '<<<  Snow Storm Software Installation  >>>'
   Say
   Say '         Installation information'
   Say
   Say '         Target : 'Target
   Say '         Source : 'Source

   finished = Question( 'Is the above information correct?' )
end
Call Question 'About to install using information given.  Continue?', 'Abort'


rc = 0

do until rc = 0
   /* Create target directory if it does not exist */
   Call SysFileTree Target, FileStem, 'D'

   If FileStem.0 = '0' Then Do
      /* Directory was not found */
      Say 'Creating target directory : ' Target
      rc = SysMkDir( Target )
      if rc <> 0 Then
      Do
         Say Target' could not be created, please try again.'
         Say
         Call Prompt 'Please enter the target drive and directory (default 'Target'):'
         Pull NewTarget
 
         /* Default Check */
         If NewTarget <> " " then
            Target = NewTarget

      End
   End
end

rc = 0
do until rc = 0
   /* Locate source directory */
   Call SysFileTree Target, FileStem, 'D'

   If FileStem.0 = '0' Then Do
      /* Directory was not found */
      rc = 1
      Say Source' could not be found, please try again.'
      Say
      Call Prompt 'Please enter the source drive and directory (default 'Source'):'
      Pull NewSource

      /* Default Check */
      If NewSource <> " " then
         Source = NewSource

   End
end

/* Copy files. */
Say
Say 'Unpacking files from 'Source' to 'Target'.'
Command = '@unpack 'Source' 'Target
Command
if rc \= 0 Then Do
    Call Question 'Error occured during file transfer.  Abort ', 'Abort'
End

/* Prompt to create Workplace Shell Program Objects. */
Say
Say 'Creating Workplace Shell Object.'
r = SysCreateObject( "WPProgram",,
                     "Below Zero",,
                     "<WP_DESKTOP>",,
                     "EXENAME=VIEW.EXE;PARAMETERS=BelowZro introduction;STARTUPDIR="||Target, 'U' )

/* Success */
Say
Say '<<<  Snow Storm Software Installation Successfull  >>>'
Say
Call Prompt 'Press Enter to exit installation....'
Pull ExitInstallation

Exit

/* Prompt for user input */
Prompt: Parse Arg szPromptText

    /* Current cursor position. */
    Parse Value SysCurPos() With Row .

    /* Screen size. */
    Parse Value SysTextScreenSize() With NumRows .

    /* End of screen check. */
    if Row = NumRows - 1 Then Row = Row - 1

    /* Prompt length. */
    Col = Length( szPromptText ) + 1

    /* Show prompt and position cursor at end. */
    Say szPromptText
    Call SysCurPos Row, Col

    Return

/* Ask simple yes or no question, aborting if critical */
Question: Parse Arg szText, AbortFlag

    /* Use prompt to get user response. */
    Say szText' (Y or N)?'

    /* Wait for user input */
    Do Forever
        KeyPress = SysGetKey( 'NOECHO' )
        If KeyPress = 'Y' | KeyPress = 'y' Then Do
            Say
            Return 'Y'
        End
        Else If KeyPress = 'N' | KeyPress = 'n' Then Do
            Say
            If AbortFlag = 'Abort' Then Exit
            Return 'N'
        End
    End
    Return 'Error'


