/***************************************************************************
 *                                                                         *
 *  Test utility for archive installation and expanding using WIArchive.   *
 *                                                                         *
 *  NOTE: This is only for compiling a test suite for the back-end. This   *
 *        is NOT used by WARPIN.EXE. (*UM5)                                *
 *                                                                         *
 *  This file Copyright (C) 1998-99 Jens Bckman.                          *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, in version 2 as it comes in the COPYING  *
 *  file of this distribution.                                             *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <stdio.h>

#include "../wiarchive/wiarchive.h"

int percentage (short mode, short s, WIFileHeader* file)
{
    char c;

    switch (mode)
    {
        case CBM_NEXTFILE:
            // We are *supposed* to check if the file exists, ask the user
            // if we are allowed to overwrite it and then return the answed.
            // This code just says 'go ahead, make my day'.
            return CBRC_PROCEED;
            break;
        case CBM_UPDATING:
            printf ("\b\b\b\b%3d%%\n", s);
            break;
        case CBM_PERCENTAGE:
            printf ("\r                                                                  \r");
            printf ("%s - %3d%%", file->name, s);
            break;
        case CBM_ERR_MEMORY:
            break;
        case CBM_ERR_WRITE:
            break;
        case CBM_ERR_READ:
            break;
        case CBM_ERR_ZLIB:
            break;
    }
}

/***************************************************************************
 * A standard main procedure, you know what this one does
 */
int main (int argc, char **argv)
{
    WIArchive arc;              // Archive
    char name[64];
    const WIArcHeader *header;

    cout << " * Test utility for archive expansion using WIArchive\n\n";

    // Try to open myself first, then the archive
    // NOTE: self-extracting archives support not done yet!
    if (arc.open (argv[0]) == 0)
    {
        cout << "Archive name: ";
        cin  >> name;
        if (arc.open (name) == 0)
        {
            cout << "Apparently, that file didn't want to open.  Sorry.\n";
            return 1;
        }
    }

    header = arc.get_arc_header ();
    cout << "Name of application: " << header->name_app;
    cout << "\nName of developer: " << header->name_dev;
    cout << "\nApplication revision: " << header->rev_app;
    cout << "\nStandard install path: " << header->path;
    cout << "\nNumber of packages: " << header->packs;
    cout << "\n";
    if (arc.get_script () == NULL)
        cout << "No script available\n";
    arc.set_callback_func (percentage);
    arc.unpack (1);

    return 0;
}

