/***************************************************************************
 *                                                                         *
 *  Test utility for archive creation using WIArchive.  This program is    *
 *  not optimized in any way, so don't complain about sizes and speed.     *
 *                                                                         *
 *  NOTE: This is only for compiling a test suite for the back-end. This   *
 *        is NOT used by WARPIN.EXE. (*UM5)                                *
 *                                                                         *
 *  This file Copyright (C) 1998-99 Jens Bckman.                          *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, in version 2 as it comes in the COPYING  *
 *  file of this distribution.                                             *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <stdio.h>

#include "../wiarchive/wiarchive.h"

int percentage (short mode, short s, WIFileHeader* file)
{
    char c;

    switch (mode)
    {
        case CBM_NEXTFILE:
            // We are *supposed* to check if the file exists, ask the user
            // if we are allowed to overwrite it and then return the answed.
            // This code just says 'go ahead, make my day'.
            return CBRC_PROCEED;
            break;
        case CBM_UPDATING:
            printf ("\b\b\b\b%3d%%\n", s);
            break;
        case CBM_PERCENTAGE:
            printf ("\r                                                                  \r");
            printf ("%s - %3d%%", file->name, s);
            break;
        case CBM_ERR_MEMORY:
            break;
        case CBM_ERR_WRITE:
            break;
        case CBM_ERR_READ:
            break;
        case CBM_ERR_ZLIB:
            break;
    }
}

/***************************************************************************
 * A standard main procedure, you know what this one does
 */
int main (void)
{
    WIArchive arc;              // Archive
    WIArcHeader archead;        // A header for our archive
    char name[128];             // Name of archive file
    char packname[32];          // Name of a package
    int i, packs, files;
    char tmp1[128], tmp2[128];

    // Open the archive for writing
    cout << " * Test utility for archive creation using WIArchive\n\n";
    cout << "Archive name: ";
    cin  >> name;
    if (arc.open (name, 1) == 0)
    {
        cout << "Apparently, that file didn't want to open.  Sorry.\n";
        return 1;
    }

    // Ask the basic questions
    cout << "Standard install path: ";
    cin  >> archead.path;
    cout << "Name of application: ";
    cin  >> archead.name_app;
    cout << "Name of developer: ";
    cin  >> archead.name_dev;
    cout << "Internet address (NOT IMPLEMENTED): \n";
    strcpy (archead.inet_address, "N/A");
    cout << "Application revision : ";
    cin  >> archead.rev_app;
    arc.set_arc_header (archead);

    // Start getting the packages and stuff
    cout << "Number of packages: ";
    cin  >> packs;
    for (i = 1; i <= packs; i++)
    {
        cout << "\nName of package " << i << ": ";
        cin  >> packname;
        arc.set_package (i, packname);
        cout << "Number of files in package: ";
        cin  >> files;

        while (files--)
        {
            cout << "File name: ";
            cin  >> tmp1;
            cout << "Name in archive:";
            cin  >> tmp2;
            arc.add (tmp1, tmp2, i);
        }
    }

    arc.set_callback_func (percentage);
    arc.close ();

    return 0;
}

