
/*
 * winh.h:
 *      header file for winh.h, which contains Presentation Manager
 *      helper functions that are  independent of a single application,
 *      i.e. these can be  used w/out the rest of the XWorkplace source in
 *      any PM program.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *@@include #define INCL_WINWINDOWMGR
 *@@include #define INCL_WINMESSAGEMGR
 *@@include #define INCL_WINDIALOGS
 *@@include #define INCL_WINSTDCNR
 *@@include #define INCL_WININPUT
 *@@include #define INCL_WINSYS
 *@@include #define INCL_WINSHELLDATA
 *@@include #include <os2.h>
 *@@include #include "winh.h"
 */

#if __cplusplus
extern "C" {
#endif

#ifndef WINH_HEADER_INCLUDED
    #define WINH_HEADER_INCLUDED

    /* ******************************************************************
     *                                                                  *
     *   Declarations                                                   *
     *                                                                  *
     ********************************************************************/

    #define MPNULL                 (MPFROMP(NULL))
    #define MPZERO                 (MPFROMSHORT(0))
    #define MRTRUE                 (MRFROMSHORT((SHORT) TRUE))
    #define MRFALSE                (MRFROMSHORT((SHORT) FALSE))
    #define BM_UNCHECKED           0   // for checkboxes: disabled
    #define BM_CHECKED             1   // for checkboses: enabled
    #define BM_INDETERMINATE       2   // for tri-state checkboxes: indeterminate

    // container sort function as used in
    // CM_SORTRECORD and CNRINFO.pSortRecord
    typedef SHORT EXPENTRY FNCNRSORT(PVOID,     // record core 1
                                     PVOID,     // record core 2
                                     PVOID);    // pStorage (== NULL)
    typedef FNCNRSORT *PFNCNRSORT;

    typedef VOID EXPENTRY FNCBRECC(PRECORDCORE, ULONG, ULONG);
    typedef FNCBRECC *PFNCBRECC;

    /* ******************************************************************
     *                                                                  *
     *   Macros                                                         *
     *                                                                  *
     ********************************************************************/

    /*
     *  Here come some monster macros for
     *  frequently needed functions.
     */

    #define DebugBox(title, text) \
             WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,   \
                ((PSZ)text), ((PSZ)title),    \
                0, MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE)

    #define YesNoBox(title, text) \
             WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,   \
                ((PSZ)text), ((PSZ)title),    \
                0, MB_YESNO | MB_ICONQUESTION | MB_MOVEABLE)

    #define winhSetDlgItemChecked(hwnd, id, bCheck) \
            WinSendDlgItemMsg((hwnd), (id), BM_SETCHECK, MPFROMSHORT(bCheck), MPNULL)

    #define winhIsDlgItemChecked(hwnd, id) \
            (SHORT1FROMMR(WinSendDlgItemMsg((hwnd), (id), BM_QUERYCHECK, MPNULL, MPNULL)))

    #define winhSetMenuItemChecked(hwndMenu, usId, bCheck) \
            WinSendMsg(hwndMenu, MM_SETITEMATTR, MPFROM2SHORT(usId, TRUE), \
                    MPFROM2SHORT(MIA_CHECKED, (((bCheck)) ? MIA_CHECKED : FALSE)))

    #define winhShowDlgItem(hwnd, id, show) \
            WinShowWindow(WinWindowFromID(hwnd, id), show)

    #define winhSetWindowFont(hwnd, szFont) \
            (WinSetPresParam(hwnd),\
            PP_FONTNAMESIZE, (ULONG)(strlen(szFont)+1), szFont))

    #define winhSetDlgItemFont(hwnd, usId, szFont) \
            (WinSetPresParam(WinWindowFromID(hwnd, usId),\
            PP_FONTNAMESIZE, (ULONG)(strlen(szFont)+1), szFont))

    #define winhEnableDlgItem(hwndDlg, ulId, Enable) \
            WinEnableWindow(WinWindowFromID(hwndDlg, ulId), Enable)

    #define winhIsDlgItemEnabled(hwndDlg, ulId) \
            WinIsWindowEnabled(WinWindowFromID(hwndDlg, ulId))

    #define winhSetDlgItemFocus(hwndDlg, ulId) \
            WinSetFocus(HWND_DESKTOP, WinWindowFromID(hwndDlg, ulId))

    /*
     *@@ winhSetWaitPointer:
     *      this sets the mouse pointer to "Wait".
     *      Returns the previous pointer (HPOINTER),
     *      which should be stored somewhere to be
     *      restored later.
     */

    #define winhSetWaitPointer()                            \
            WinQueryPointer(HWND_DESKTOP);                  \
            WinSetPointer(HWND_DESKTOP,                     \
                          WinQuerySysPointer(HWND_DESKTOP, SPTR_WAIT, FALSE))

    /* ******************************************************************
     *                                                                  *
     *   Menu helpers                                                   *
     *                                                                  *
     ********************************************************************/

    /*
     * winhCreateEmptyMenu:
     *      this macro creates an empty menu, which can
     *      be used with winhInsertMenuItem etc. later.
     *      Useful for creating popup menus on the fly.
     *      Note that even though HWND_DESKTOP is specified
     *      here as both the parent and the owner, the
     *      actual owner and parent are specified later
     *      with WinPopupMenu.
     */

    #define winhCreateEmptyMenu()                                   \
    WinCreateWindow(HWND_DESKTOP, WC_MENU, "", 0, 0, 0, 0, 0,       \
                    HWND_DESKTOP, HWND_TOP, 0, 0, 0)

    SHORT winhInsertMenuItem(HWND hwndMenu,
                             SHORT iPosition,
                             SHORT sItemId,
                             PSZ pszItemTitle,
                             SHORT afStyle,
                             SHORT afAttr);

    HWND winhInsertSubmenu(HWND hwndMenu,
                           ULONG iPosition,
                           SHORT sMenuId,
                           PSZ pszSubmenuTitle,
                           USHORT afMenuStyle,
                           SHORT sItemId,
                           PSZ pszItemTitle,
                           USHORT afItemStyle,
                           USHORT afAttribute);

    SHORT winhInsertMenuSeparator(HWND hMenu,
                                  SHORT iPosition,
                                  SHORT sId);

    VOID winhMenuRemoveEllipse(HWND hwndMenu,
                               USHORT usItemId);

    SHORT winhQueryItemUnderMouse(HWND hwndMenu, POINTL *pptlMouse, RECTL *prtlItem);

    /* ******************************************************************
     *                                                                  *
     *   "Menu button" helpers                                          *
     *                                                                  *
     ********************************************************************/

    BOOL winhMenuButtonFromButton(HWND hwndButton,
                                  HMODULE hmodMenu,
                                  ULONG idMenu);

    /* ******************************************************************
     *                                                                  *
     *   Slider helpers                                                 *
     *                                                                  *
     ********************************************************************/

    HWND winhReplaceWithLinearSlider(HWND hwndParent,
                               HWND hwndOwner,
                               HWND hwndInsertAfter,
                               ULONG ulID,
                               ULONG ulSliderStyle,
                               ULONG ulTickCount);

    /*
     * winhSetSliderTicks:
     *      this macro adds ticks to the given linear
     *      slider which are ulTicks pixels high.
     *      Per default, sliders have no ticks, so
     *      you need to add them manually when
     *      initializing a dialog.
     */

    #define winhSetSliderTicks(hwndSlider, ulTicks)                 \
        WinSendMsg(hwndSlider, SLM_SETTICKSIZE,                     \
                   MPFROM2SHORT(SMA_SETALLTICKS,                    \
                                    6),                             \
                       NULL)

    /*
     * winhSetSliderArmPosition:
     *      this moves the slider arm in a given
     *      linear slider.
     *
     *      usMode can be one of the following:
     *      --  SMA_RANGEVALUE: usOffset is in pixels
     *          from the slider's home position.
     *      --  SMA_INCREMENTVALUE: usOffset is in
     *          units of the slider's primary scale.
     */

    #define winhSetSliderArmPosition(hwndSlider, usMode, usOffset)  \
            WinSendMsg(hwndSlider, SLM_SETSLIDERINFO,               \
                   MPFROM2SHORT(SMA_SLIDERARMPOSITION,              \
                     usMode),                                       \
                   MPFROMSHORT(usOffset))

    /*
     * winhQuerySliderArmPosition:
     *      reverse to the previous, this returns a
     *      slider arm position (as a LONG value).
     */

    #define winhQuerySliderArmPosition(hwndSlider, usMode)          \
            (LONG)(WinSendMsg(hwndSlider,                           \
                              SLM_QUERYSLIDERINFO,                  \
                              MPFROM2SHORT(SMA_SLIDERARMPOSITION,   \
                                           usMode),                 \
                              0));

    HWND winhReplaceWithCircularSlider(HWND hwndParent,
                           HWND hwndOwner,
                           HWND hwndInsertAfter,
                           ULONG ulID,
                           ULONG ulSliderStyle,
                           SHORT sMin,
                           SHORT sMax,
                           USHORT usIncrement,
                           USHORT usTicksEvery);

    /* ******************************************************************
     *                                                                  *
     *   Spin button helpers                                            *
     *                                                                  *
     ********************************************************************/

    VOID winhSetDlgItemSpinData(HWND hwndDlg,
                               ULONG idSpinButton,
                               ULONG min,
                               ULONG max,
                               ULONG current);

    LONG winhAdjustDlgItemSpinData(HWND hwndDlg,
                                   USHORT usItemID,
                                   LONG lGrid,
                                   USHORT usNotifyCode);

    /* ******************************************************************
     *                                                                  *
     *   Entry field helpers                                            *
     *                                                                  *
     ********************************************************************/

    /*
     * winhSetEntryFieldLimit:
     *      sets the maximum length for the entry field
     *      (EM_SETTEXTLIMIT).
     */

    #define winhSetEntryFieldLimit(hwndEntryField, usLength)        \
            WinSendMsg(hwndEntryField, EM_SETTEXTLIMIT, (MPARAM)(usLength), (MPARAM)0)

    /* ******************************************************************
     *                                                                  *
     *   List box helpers                                               *
     *                                                                  *
     ********************************************************************/

    /*
     *@@ winhQueryLboxSelectedItem:
     *      this queries the next selected list box item.
     *      For the first call, set sItemStart to LIT_FIRST;
     *      then repeat the call with sItemStart set to
     *      the previous return value until this returns
     *      LIT_NONE.
     *
     *      Example:
     +          SHORT sItemStart = LIT_FIRST;
     +          while (TRUE)
     +          {
     +              sItemStart = winhQueryLboxSelectedItem(hwndListBox,
     +                                                     sItemStart)
     +              if (sItemStart == LIT_NONE)
     +                  break;
     +              ...
     +          }
     *
     *      To have the cursored item returned, use LIT_CURSOR.
     */

    #define winhQueryLboxSelectedItem(hwndListBox, sItemStart) \
            (SHORT)(WinSendMsg(hwndListBox,                    \
                            LM_QUERYSELECTION,                 \
                            (MPARAM)(sItemStart),              \
                            MPNULL))

    /*
     *@@ winhSetLboxSelectedItem:
     *      selects a list box item.
     *      This works for both single-selection and
     *      multiple-selection listboxes.
     *      In single-selection listboxes, if an item
     *      is selected (fSelect == TRUE), the previous
     *      item is automatically deselected.
     *      Note that (BOOL)fSelect is ignored if
     *      sItemIndex == LIT_NONE.
     */

    #define winhSetLboxSelectedItem(hwndListBox, sItemIndex, fSelect)   \
            (BOOL)(WinSendMsg(hwndListBox,                              \
                            LM_SELECTITEM,                              \
                            (MPARAM)(sItemIndex),                       \
                            (MPARAM)(fSelect)))

    ULONG winhLboxSelectAll(HWND hwndListBox,
                            BOOL fSelect);

    /*
     * winhSetLboxItemHandle:
     *      sets the "item handle" for the specified sItemIndex.
     *      See LM_SETITEMHANDLE in PMREF for details.
     */

    #define winhSetLboxItemHandle(hwndListBox, sItemIndex, ulHandle)    \
            (BOOL)(WinSendMsg(hwndListBox, LM_SETITEMHANDLE,            \
                              (MPARAM)(sItemIndex),                     \
                              (MPARAM)ulHandle))

    /*
     * winhQueryLboxItemHandle:
     *      the reverse to the previous. Returns a ULONG.
     */

    #define winhQueryLboxItemHandle(hwndListBox, sItemIndex)            \
            (ULONG)WinSendMsg(hwndListBox, LM_QUERYITEMHANDLE,          \
                              (MPARAM)(sItemIndex), (MPARAM)NULL)

    /* ******************************************************************
     *                                                                  *
     *   Container helpers                                              *
     *                                                                  *
     ********************************************************************/

    /*
     *@@ winhQueryCnrInfo:
     *      this stores the CNRINFO for hwndCnr
     *      in the specified variable, which must
     *      be a PCNRINFO.
     *      Example:
     +          CNRINFO CnrInfo;
     +          winhQueryCnrInfo(&CnrInfo);
     *
     *@@changed V1.00
     */

    #define winhQueryCnrInfo(hwndCnr, pCnrInfo)                     \
            WinSendMsg(hwndCnr, CM_QUERYCNRINFO,                    \
                    (MPARAM)(pCnrInfo),                             \
                    (MPARAM)(sizeof(*pCnrInfo)))

    /*
     *@@ BEGIN_CNRINFO:
     *      this func starts a "container info" block for the
     *      following functions.
     *      This must always be followed by END_CNRINFO(),
     *      or you'll get funny compilation errors.
     *
     *@@added V1.00
     */

    #define BEGIN_CNRINFO()                                         \
        {                                                           \
            CNRINFO     CnrInfo_;                                   \
            ULONG       ulSendFlags_ = 0;                           \
            CnrInfo_.cb = sizeof(CnrInfo_);

    /*
     *@@ END_CNRINFO:
     *      this ends a "container info" block started by
     *      BEGIN_CNRINFO.
     *
     *@@added V1.00
     */

    #define END_CNRINFO(hwndCnr)                                    \
            WinSendMsg((hwndCnr), CM_SETCNRINFO, (MPARAM)&CnrInfo_, \
                (MPARAM)ulSendFlags_);                              \
        }

    /*
     *@@ winhCnrSetSplitBarAfter:
     *      this macro sets the field info after which
     *      the split bar should be shown.
     *      If (pFieldInfo == NULL), the split bar is hidden.
     *
     *      This can only be used after BEGIN_CNRINFO().
     *
     *@@added V1.00
     */

    #define winhCnrSetSplitBarAfter(pFieldInfo)                     \
        CnrInfo_.pFieldInfoLast = (pFieldInfo);                     \
        ulSendFlags_ |= CMA_PFIELDINFOLAST;

    /*
     *@@ winhCnrSetSplitBarPos:
     *      this macro sets the vertical split bar
     *      position (in window coordinates).
     *
     *      This can only be used after BEGIN_CNRINFO().
     *
     *@@added V1.00
     */

    #define winhCnrSetSplitBarPos(xPos)                             \
        CnrInfo_.xVertSplitbar = (xPos);                            \
        ulSendFlags_ |= CMA_XVERTSPLITBAR;

    /*
     *@@ winhCnrSetBmpOrIconSize:
     *      this macro sets the size used for bitmaps
     *      or icons (depending on whether CA_DRAWBITMAP
     *      or the default CA_DRAWICON is set in flWindowAttr).
     *      The default is the system icon size (32 or 40).
     *
     *      This can only be used after BEGIN_CNRINFO().
     *
     */

    #define winhCnrSetBmpOrIconSize(cxNew, cyNew)                   \
        CnrInfo_.slBitmapOrIcon.cx = cxNew;                         \
        CnrInfo_.slBitmapOrIcon.cy = cyNew;                         \
        ulSendFlags_ |= CMA_SLBITMAPORICON;

    /*
     *@@ winhCnrSetView:
     *      this sets the container view attributes (CNRINFO.flWindowAttr).
     *
     *      This can only be used after BEGIN_CNRINFO().
     *
     *      The following combinations are useful for flWindowAttr.
     *
     *      <B>Icon view:</B>
     *      --  CV_ICON: icon view
     *                   RECORDCORE.pszIcon is used for record titles;
     *                   add CV_MINI for mini-icons view
     *
     *      <B>Tree view:</B>
     *      --  CV_TREE | CV_ICON: tree icon view (icon plus name;
     *                   RECORDCORE.pszIcon is used for record titles)
     *      --  CV_TREE | CV_NAME: tree name view (icon plus name;
     *                   RECORDCORE.pszName is used for record titles,
     *                   and this does _not_ use a separate icon/bitmap for
     *                   "collapsed" and "expanded"
     *      --  CV_TREE | CV_TEXT: tree text view (icon plus name;
     *                   RECORDCORE.pszText is used for record titles)
     *      Add CA_TREELINE to have lines drawn between tree items.
     *
     *      <B>Name view:</B>
     *      --  CV_NAME: non-flowed name view (icon plus name;
     *                   RECORDCORE.pszName is used for record titles;
     *                   display a single column
     *      --  CV_NAME | CV_FLOW: flowed name view (icon plus name;
     *                   RECORDCORE.pszName is used for record titles;
     *                   display multiple columns
     *
     *      <B>Text view:</B>
     *      --  CV_TEXT: non-flowed name view (icon plus name;
     *                   RECORDCORE.pszText is used for record titles;
     *                   display a single column
     *      --  CV_TEXT | CV_FLOW: flowed name view (icon plus name;
     *                   RECORDCORE.pszText is used for record titles;
     *                   display multiple columns
     *
     *      <B>Details view:</B>
     *      --  CV_DETAIL: details view without column headers
     *      --  CV_DETAIL | CA_DETAILSVIEWTITLES: details view _with_ column headers
     *
     *      <B>Target emphasis:</B>
     *      For Name, Text, and Details view, per default target emphasis
     *      during d'n'd is only displayed _around_ the record core.
     *      If you add CA_ORDEREDTARGETEMPH, target emphasis is only
     *      displayed _below_ the record core. If you add CA_MIXEDTARGETEMPH,
     *      both emphasis types are possible.
     *
     *      Additional flags for _all_ views:
     *      --  CA_DRAWICON: RECORDCORE.hptrIcon and hptrMiniIcon
     *                       are to be used to draw icons
     *      --  CA_DRAWBITMAP: RECORDCORE.hbmBitmap and hbmMiniBitmap
     *                         are to be used to draw bitmaps
     *                         (CA_DRAWICON takes precedence)
     *      --  CA_OWNERDRAW: all record cores are to be owner-drawn.
     *      --  CA_OWNERPAINTBACKGROUND: container sends CM_PAINTBACKGROUND
     *                          to itself. By subclassing the container,
     *                          this can be intercepted.
     *      --  CA_CONTAINERTITLE: add container title. If this is
     *                          specified, you may also specify
     *                          CA_TITLEREADONLY, CA_TITLESEPARATOR,
     *                          and one out of (CA_TITLECENTER, CA_TITLELEFT,
     *                          CA_TITLERIGHT).
     *
     *      Note that CV_MINI is only supported for "pure" icon view.
     *
     *@@added V1.00
     */

    #define winhCnrSetView(flNewAttr)                               \
        CnrInfo_.flWindowAttr = (flNewAttr);                        \
        ulSendFlags_ |= CMA_FLWINDOWATTR;

    /*
     *@@ winhCnrSelectRecord:
     *      this selects/deselects a container RECORDCORE
     *      (precc), depending on fSelect.
     *
     *@@changed V1.00
     */

    #define winhCnrSelectRecord(hwndCnr, precc, fSelect)        \
            WinSendMsg(hwndCnr, CM_SETRECORDEMPHASIS,           \
                    (MPARAM)(precc),                            \
                    MPFROM2SHORT(fSelect, CRA_SELECTED))

    /*
     *@@ winhCnrSetSourceEmphasis:
     *      this gives a container RECORDCORE (precc)
     *      source emphasis or removes it, depending
     *      on fSelect.
     *      precc may be NULL to give the whole container
     *      source emphasis.
     */

    #define winhCnrSetSourceEmphasis(hwndCnr, precc, fSelect)   \
            WinSendMsg(hwndCnr, CM_SETRECORDEMPHASIS,           \
                    (MPARAM)(precc),                            \
                    MPFROM2SHORT(fSelect, CRA_SOURCE))

    ULONG winhCnrScrollToRecord(HWND hwndCnr,
                                PRECORDCORE pRec,
                                ULONG fsExtent,
                                BOOL KeepParent);

    PRECORDCORE winhCnrAllocRecords(HWND hwndCnr,
                                    ULONG cbrecc,
                                    ULONG ulCount);

    ULONG winhCnrInsertRecords(HWND hwndCnr,
                               PRECORDCORE preccParent,
                               PRECORDCORE precc,
                               PSZ pszText,
                               ULONG flRecordAttr,
                               ULONG ulCount);

    // redefine the FIELDOFFSET macro; the one
    // in the OS/2 header files doesn't work with C++
    #undef FIELDOFFSET
    #define FIELDOFFSET(type, field)    ((ULONG)&(((type *)0)->field))

    /*
     *@@ winhCnrAllocFieldInfos:
     *      this allocates sColumnCount field infos
     *      for Details view in hwndCnr.
     *      Returns the first PFIELDINFO, which is
     *      the root of a linked list. Follow
     *      FIELDINFO.pNextFieldInfo to get to the
     *      next field info, the last of which is
     *      NULL.
     *
     *@@added V1.00
     */

    #define winhCnrAllocFieldInfos(hwndCnr, sColumnCount)               \
        (PFIELDINFO)WinSendMsg(hwndCnr,                                 \
                               CM_ALLOCDETAILFIELDINFO,                 \
                               MPFROMSHORT(sColumnCount),               \
                               NULL)

    VOID winhCnrSetFieldInfo(PFIELDINFO *ppFieldInfo2,
                             ULONG ulFieldOffset,
                             PSZ pszColumnTitle,
                             ULONG ulDataType,
                             ULONG ulOrientation,
                             BOOL fDrawLines);

    ULONG winhCnrInsertFieldInfos(HWND hwndCnr,
                                  PFIELDINFO pFieldInfoFirst,
                                  ULONG ulFieldCount);

    /*
     *@@ XFIELDINFO:
     *      input structure for winhCnrSetFieldInfos.
     *      See winhCnrSetFieldInfo for a description
     *      of the fields.
     *
     *@@added V1.00
     */

    typedef struct _XFIELDINFO
    {
        ULONG   ulFieldOffset;
        PSZ     pszColumnTitle;
        ULONG   ulDataType;
        ULONG   ulOrientation;
    } XFIELDINFO, *PXFIELDINFO;

    PFIELDINFO winhCnrSetFieldInfos(HWND hwndCnr,
                                    PXFIELDINFO paxfi,
                                    ULONG ulFieldCount,
                                    BOOL fDrawLines,
                                    ULONG ulFieldReturn);

    /*
     *@@ winhCnrQueryParentRecord:
     *      this returns the parent record of precc.
     *
     *      This returns a PRECORDCORE or NULL if no
     *      parent record could be found or -1 if
     *      the container found an error.
     *
     *@@added V1.00
     */

    #define winhCnrQueryParentRecord(hwndCnr, precc)                \
            (PRECORDCORE)WinSendMsg(hwndCnr, CM_QUERYRECORD,        \
                    (MPARAM)precc,                                  \
                    MPFROM2SHORT(CMA_PARENT, CMA_ITEMORDER))

    /*
     *@@ winhCnrQueryFirstChildRecord:
     *      this returns the first child record of precc.
     *
     *      This returns a PRECORDCORE or NULL if no
     *      parent record could be found or -1 if
     *      the container found an error.
     *
     *@@added V1.00
     */

    #define winhCnrQueryFirstChildRecord(hwndCnr, precc)            \
            (PRECORDCORE)WinSendMsg(hwndCnr, CM_QUERYRECORD,        \
                    (MPARAM)precc,                                  \
                    MPFROM2SHORT(CMA_FIRSTCHILD, CMA_ITEMORDER))

    ULONG winhCnrForAllRecords(HWND hwndCnr,
                               PRECORDCORE preccParent,
                               PFNWP pfnwpCallback,
                               MPARAM mpUser);

    VOID winhCnrForAllChildRecords(HWND hwndCnr,
                                   PRECORDCORE precc,
                                   PFNCBRECC pfncbRecc,
                                   ULONG ulp1,
                                   ULONG ulp2);

    VOID winhCnrForAllRecords2(HWND hwndCnr,
                               PFNCBRECC pfncbRecc,
                               ULONG ulp1,
                               ULONG ulp2);

    VOID winhCnrForAllParentRecords(HWND hwndCnr,
                                    PRECORDCORE precc,
                                    PFNCBRECC pfncbRecc,
                                    ULONG ulp1,
                                    ULONG ulp2);

    BOOL winhCnrMoveTree(HWND hwndCnr,
                         PRECORDCORE preccMove,
                         PRECORDCORE preccNewParent,
                         PFNCNRSORT  pfnCnrSort);

    BOOL winhCnrShowContextMenu(HWND hwndCnr,
                                PRECORDCORE preccSource,
                                HWND hMenu,
                                HWND hwndMenuOwner);

    /* ******************************************************************
     *                                                                  *
     *   Generic window helpers                                         *
     *                                                                  *
     ********************************************************************/

    PSZ winhQueryWindowText(HWND hwnd);

    BOOL winhSaveWindowPos(HWND hwnd,
                           HINI hIni,
                           PSZ pszApp,
                           PSZ pszKey);

    BOOL winhRestoreWindowPos(HWND hwnd,
                           HINI hIni,
                           PSZ pszApp,
                           PSZ pszKey,
                           ULONG fl);

    void winhCenterWindow(HWND hwnd);

    ULONG winhCenteredDlgBox(HWND hwndParent, HWND hwndOwner,
                  PFNWP pfnDlgProc, HMODULE hmod, ULONG idDlg, PVOID pCreateParams);

    LONG winhQueryPresColor(HWND    hwnd,
                            ULONG   ulPP,
                            LONG    lSysColor);

    HWND winhCreateStdWindow(HWND hwndFrameParent,
                             PSWP pswpFrame,
                             ULONG flFrameCreateFlags,
                             PSZ pszClassClient,
                             PSZ pszFrameTitle,
                             ULONG flStyleClient,
                             ULONG ulID,
                             PHWND phwndClient);

    VOID winhRepaintWindows(HWND hwndParent);

    HWND winhCreateFakeDesktop(HWND hwndSibling);

    HWND winhQueryCnrFromFrame(HWND hwndFrame);

    BOOL winhAssertWarp4Notebook(HWND hwndDlg,
                        USHORT usIdThreshold,    // in: ID threshold
                        ULONG ulDownUnits);      // in: dialog units or 0

    ULONG winhDrawFormattedText(HPS hps, PRECTL prcl, PSZ pszText, ULONG flCmd);

    VOID winhKillTasklist(VOID);

    ULONG winhQueryPendingSpoolJobs(VOID);

    /* ******************************************************************
     *                                                                  *
     *   WPS Class List helpers                                         *
     *                                                                  *
     ********************************************************************/

    PBYTE winhQueryWPSClassList(VOID);

    PBYTE winhQueryWPSClass(PBYTE pObjClass,
                            PSZ pszClass);

    APIRET winhRegisterClass(const char* pcszClassName,
                             const char* pcszModule,
                             PSZ pszBuf,
                             ULONG cbBuf);

    /* ******************************************************************
     *                                                                  *
     *   Progress bars                                                  *
     *                                                                  *
     ********************************************************************/

    /*
     * PROGRESSBARDATA:
     *      structure for progress bar data,
     *      saved at QWL_USER window ulong
     */

    typedef struct _PROGRESSBARDATA
    {
        ULONG      ulNow, ulMax, ulPaintX, ulOldPaintX;
        ULONG      ulAttr;
        PFNWP      OldStaticProc;
        RECTL      rclBar;
    } PROGRESSBARDATA, *PPROGRESSBARDATA;

    #define WM_UPDATEPROGRESSBAR    WM_USER+1000

    /* status bar style attributes */
    #define PBA_NOPERCENTAGE        0x0000
    #define PBA_ALIGNLEFT           0x0001
    #define PBA_ALIGNRIGHT          0x0002
    #define PBA_ALIGNCENTER         0x0003
    #define PBA_PERCENTFLAGS        0x0003
    #define PBA_BUTTONSTYLE         0x0010

    BOOL winhProgressBarFromStatic(HWND hwndStatic, ULONG ulAttr);

    /* ******************************************************************
     *                                                                  *
     *   Split bars                                                     *
     *                                                                  *
     ********************************************************************/

    #define WC_SPLITWINDOW          "SplitWindowClass"

    #define SBCF_VERTICAL            0x0000
    #define SBCF_HORIZONTAL          0x0001

    #define SBCF_PERCENTAGE          0x0002
                // if this is set, SPLITBARDATA.lPos specifies a percentage

    #define SBCF_3DSUNK              0x0100
                // this will draw everything in a 3D "sunk" style
    #define SBCF_MOVEABLE            0x1000
                // this allows moving the split bar;
                // otherwise, the split bar will be static

    /*
     * SPLITBARCDATA:
     *      split bar creation data
     */

    typedef struct _SPLITBARCDATA
    {
        ULONG   ulSplitWindowID;
                    // window ID of the split window
        ULONG   ulCreateFlags;
                    // SBCF_* flags
        LONG    lPos;
                    // if SBCF_PERCENTAGE, this has the percentage;
                    // otherwise:
                    //      if this value is positive, it's considered
                    //      an offset from the left/bottom of the frame;
                    //      if it's negative, it's from the right
        ULONG   ulLeftOrBottomLimit,
                ulRightOrTopLimit;
                    // when moving the split bar (SBCF_MOVEABLE), these
                    // are the minimum and maximum values.
                    // ulLeftOrBottomLimit is the left (or bottom) limit,
                    // ulRightOrTopLimit is the right (or top) limit.
                    // Both are offsets in window coordinates from the
                    // left (or bottom) and right (or top) boundaries of
                    // the split window. If both are 0, the whole split
                    // window is allowed (not recommended).
        HWND    hwndClient;
                    // the owner and parent of the split bar
                    // and other windows; this must be the FID_CLIENT
                    // of a frame
        HWND    hwndLink1,
                    // the left/bottom window to link
                hwndLink2;
                    // the right/top window to link
    } SPLITBARCDATA, *PSPLITBARCDATA;

    /*
     * SPLITBARDATA:
     *      internal split bar data,
     *      stored in QWL_USER window ulong
     */

    typedef struct _SPLITBARDATA
    {
        SPLITBARCDATA   sbcd;
        PFNWP           OldStaticProc;
        RECTL           rclBar;
        HPOINTER        hptrOld,        // old pointer stored upon WM_MOUSEMOVE
                        hptrMove;       // PM move pointer, either vertical or horizontal
        BOOL            fCaptured;
        POINTS          ptsMousePos;
        POINTL          ptlDrawLineFrom,
                        ptlDrawLineTo;
        HPS             hpsTrackBar;
    } SPLITBARDATA, *PSPLITBARDATA;

    #define ID_SPLITBAR  5000           // fixed ID of the split bar
                                        // (child of split window)

    HWND winhCreateSplitWindow(HAB hab,
                              PSPLITBARCDATA psbcd);

    BOOL winhUpdateSplitWindow(HWND hwndSplit);

    BOOL winhSetSplitFrameWindowPos(HWND hwndFrame,
                                   HWND hwndInsertBehind,
                                   LONG x,
                                   LONG y,
                                   LONG cx,
                                   LONG cy,
                                   ULONG fl,
                                   HWND *pahwnd,
                                   ULONG cbhwnd);

    LONG winhQuerySplitPos(HWND hwndSplit);

#endif

#if __cplusplus
}
#endif

