
/*
 * stringh.h:
 *      header file for stringh.c. See notes there.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef STRINGH_HEADER_INCLUDED
    #define STRINGH_HEADER_INCLUDED

    PSZ strhReplace(PSZ str, PSZ oldStr, PSZ newStr);

    ULONG strhReplace2(PSZ* ppszBuf,
                       PSZ pszSearch,
                       PSZ pszReplace);

    PSZ strhInsert(PSZ pszBuffer,
                   PSZ pszInsert,
                   PSZ pInsertPos);

    PSZ strhistr(PSZ string1, PSZ string2);

    ULONG strhncpy0(PSZ pszTarget, PSZ pszSource, ULONG cbSource);

    ULONG strhCount(PSZ pszSearch, CHAR c);

    BOOL strhIsDecimal(PSZ psz);

    PSZ strhSubstr(PSZ pBegin, PSZ pEnd);

    PSZ strhThousandsULong(PSZ pszTarget, ULONG ul, CHAR cThousands);

    PSZ strhThousandsDouble(PSZ pszTarget, double dbl, CHAR cThousands);

    VOID strhFileDate(PSZ pszBuf, FDATE* pfDate, ULONG ulDateFormat, CHAR cDateSep);

    VOID strhFileTime(PSZ pszBuf, FTIME* pfTime, ULONG ulTimeFormat, CHAR cTimeSep);

    PSZ strhFindEOL(PSZ pszSearchIn, ULONG *pulOffset);

    PSZ strhFindNextLine(PSZ pszSearchIn, PULONG pulOffset);

    PSZ strhFindKey(PSZ pszSearchIn,
                    PSZ pszKey,
                    BOOL *pfIsAllUpperCase);

    PSZ strhGetParameter(PSZ pszSearchIn, PSZ pszKey, PSZ pszCopyTo, ULONG cbCopyTo);

    PSZ strhSetParameter(PSZ pszSearchIn,
                         PSZ pszKey,
                         PSZ pszNewParam,
                         BOOL fRespectCase);

    BOOL strhDeleteLine(PSZ pszSearchIn, PSZ pszKey);

    BOOL strhBeautifyTitle(PSZ psz);

    PSZ strhFindAttribValue(PSZ pszSearchIn, PSZ pszAttrib);

    PSZ strhGetNumAttribValue(PSZ pszSearchIn,
                              PSZ pszTag,
                              PLONG pl);

    PSZ strhGetTextAttr(PSZ pszSearchIn, PSZ pszTag, PULONG pulOffset);

    PSZ strhFindEndOfTag(PSZ pszBeginOfTag);

    ULONG strhGetBlock(PSZ *ppszSearchIn,
                       PSZ pszTag,
                       PSZ *ppszBlock,
                       PSZ *ppszAttribs,
                       PULONG pulOfsBeginTag,
                       PULONG pulOfsBeginBlock);

#endif

#if __cplusplus
}
#endif

