
/*
 * winh.h:
 *      header file for prfh.h, which
 *      contains those Presentation Manager helper functions
 *      which deal with Profile (Prf*) functions. These can be
 *      used w/out the rest of the XWorkplace source in any PM
 *      program.
 *      This file is new with V0.82.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef PRFH_HEADER_INCLUDED
    #define PRFH_HEADER_INCLUDED

    /* common error codes used by the prfh* functions */

    #define PRFERR_DATASIZE 1   // couldn't query data size for key
    #define PRFERR_MEMORY   2   // couldn't allocate memory
    #define PRFERR_READ     3   // couldn't read data from source (PrfQueryProfileData error)
    #define PRFERR_WRITE    4   // couldn't write data to target (PrfWriteProfileData error)
    #define PRFERR_KEYSLIST 5   // couldn't query keys list

    PSZ prfhQueryKeysForApp(HINI hIni,
                            PSZ pszApp);

    PSZ prfhQueryProfileData(HINI hIni,
                            PSZ pszApp,
                            PSZ pszKey,
                            PULONG pcbBuf);

    ULONG prfhCopyKey(HINI hiniSource,
                     PSZ pszSourceApp,
                     PSZ pszKey,
                     HINI hiniTarget,
                     PSZ pszTargetApp);

    ULONG prfhCopyApp(HINI hiniSource,
                      PSZ pszSourceApp,
                      HINI hiniTarget,
                      PSZ pszTargetApp,
                      PSZ pszErrorKey);

    BOOL prfhCopyProfile(HAB hab,
                         HFILE hfLog,
                         HINI hOld,
                         PSZ pszOld,
                         PSZ pszNew,
                         PFNWP fncbUpdate,
                         HWND hwnd, ULONG msg, ULONG ulCount, ULONG ulMax,
                         PFNWP fncbError,
                         PULONG pulFunc2);

    APIRET prfhSaveINIs(HAB hab,
                         HFILE hfLog,
                         PFNWP fncbUpdate,
                         HWND hwnd, ULONG msg,
                         PFNWP fncbError,
                         PULONG pulFunc2);

    LONG prfhQueryColor(PSZ pszKeyName, PSZ pszDefault);

#endif

#if __cplusplus
}
#endif

