
/*
 * gpih.h:
 *      header file for gpih.h, which contains GPI helper functions
 *      that are  independent of a single application,
 *      i.e. these can be  used w/out the rest of the XWorkplace source in
 *      any PM program.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef GPIH_HEADER_INCLUDED
    #define GPIH_HEADER_INCLUDED

    ULONG gpihQueryDisplayCaps(ULONG ulIndex);

    LONG gpihQueryLineSpacing(HPS hps,
                              PSZ pszText);

    VOID gpihDrawRect(HPS hps, PRECTL prcl);

    VOID gpihDraw3DFrame(HPS hps,
                         PRECTL prcl,
                         USHORT usWidth,
                         BOOL fRaised);

    BOOL gpihCreateMemPS(HAB hab,
                        HDC *hdcMem,
                        HPS *hpsMem);

    HBITMAP gpihCreateBitmap(HPS hpsMem,
                             ULONG  cx,
                             ULONG  cy);

    HBITMAP gpihCreateBmpFromPS(HAB hab,
                                HPS hpsScreen,
                                PRECTL prcl);

    HBITMAP gpihCreateHalftonedBitmap(HAB       hab,
                                      HBITMAP   hbmSource,
                                      LONG      lColorGray);

    HBITMAP gpihLoadBitmapFile(HPS hps,
                               PSZ pszBmpFile,
                               PULONG pulError);

    LONG gpihStretchBitmap(HPS hpsTarget,
                           HBITMAP hbmSource,
                           PRECTL prclSource,
                           PRECTL prclTarget,
                           BOOL fProportional);
    /*
     *@@ gpihSwitchToRGB:
     *      this switches the given HPS into RGB mode.
     *      Requires INCL_GPILOGCOLORTABLE.
     */

    #define gpihSwitchToRGB(hps)                \
        GpiCreateLogColorTable(hps, 0, LCOLF_RGB, 0, 0, NULL);

#endif

#if __cplusplus
}
#endif

