
/*
 * except.h:
 *      header file for except.c.
 *
 *@@include #define INCL_DOSEXCEPTIONS
 *@@include #define INCL_DOSPROCESS
 *@@include #include <os2.h>
 *@@include #include <stdio.h>
 *@@include #include <setjmp.h>
 *@@include #include <assert.h>
 *@@include #include "except.h"
 */

/*
 *      Copyright (C) 1999 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef EXCEPT_HEADER_INCLUDED
    #define EXCEPT_HEADER_INCLUDED

    /********************************************************************
     *                                                                  *
     *   Declarations                                                   *
     *                                                                  *
     ********************************************************************/

    // replacement EXCEPTIONREGISTRATIONRECORD struct
    // for thread exception handling
    typedef struct REGREC2_STRUCT {
        PVOID     pNext;
        PFN       pfnHandler;
        jmp_buf   jmpThread;
    } REGREC2, *PREGREC2;

    typedef struct _EXCEPTSTRUCT {
        REGREC2               RegRec2;
        ULONG                 ulExcpt;
        APIRET                arc;
    } EXCEPTSTRUCT, *PEXCEPTSTRUCT;

    // function prototypes for exception hooks (V1.00)

    // "open traplog file" hook
    typedef FILE* FNEXCOPENFILE(VOID);
    typedef FNEXCOPENFILE *PFNEXCOPENFILE;

    // "exception" hook
    typedef VOID FNEXCHOOK(FILE*, PTIB);
    typedef FNEXCHOOK *PFNEXCHOOK;

    /********************************************************************
     *                                                                  *
     *   Prototypes                                                     *
     *                                                                  *
     ********************************************************************/

    VOID excRegisterHooks(PFNEXCOPENFILE pfnExcOpenFileNew,
                          PFNEXCHOOK     pfnExcHookNew);

    ULONG _System excHandlerLoud(PEXCEPTIONREPORTRECORD pReportRec,
                                         PREGREC2 pRegRec2,
                                         PCONTEXTRECORD pContextRec,
                                         PVOID pv);

    ULONG _System excHandlerQuiet(PEXCEPTIONREPORTRECORD pReportRec,
                                         PREGREC2 pRegRec2,
                                         PCONTEXTRECORD pContextRec,
                                         PVOID pv);

    /********************************************************************
     *                                                                  *
     *   Macros                                                         *
     *                                                                  *
     ********************************************************************/

    /* See except.c for explanations how to use these. */

    #define TRY_LOUD(excptstruct)                                          \
            {   /* register the "loud" exception handler */                \
                EXCEPTSTRUCT          excptstruct;                         \
                excptstruct.RegRec2.pfnHandler = (PFN)excHandlerLoud;      \
                excptstruct.arc = DosSetExceptionHandler(                  \
                            (PEXCEPTIONREGISTRATIONRECORD)&(excptstruct.RegRec2)); \
                if (excptstruct.arc)                                       \
                    DosBeep(100, 1000);                                    \
                excptstruct.ulExcpt = setjmp(excptstruct.RegRec2.jmpThread);               \
                if (excptstruct.ulExcpt == 0)                              \
                {   /* no exception occured: */

    #define TRY_QUIET(excptstruct)                                         \
            {   /* register the "quiet" exception handler */               \
                EXCEPTSTRUCT          excptstruct;                         \
                excptstruct.RegRec2.pfnHandler = (PFN)excHandlerQuiet;     \
                excptstruct.arc = DosSetExceptionHandler(                  \
                            (PEXCEPTIONREGISTRATIONRECORD)&(excptstruct.RegRec2)); \
                if (excptstruct.arc)                                       \
                    DosBeep(100, 1000);                                    \
                excptstruct.ulExcpt = setjmp(excptstruct.RegRec2.jmpThread);               \
                if (excptstruct.ulExcpt == 0)                              \
                {   /* no exception occured: */

    #define CATCH(excptstruct)                                             \
                    DosUnsetExceptionHandler(                              \
                            (PEXCEPTIONREGISTRATIONRECORD)&(excptstruct.RegRec2));   \
                } /* end if (try_ulExcpt == 0) */                          \
                else { /* exception occured: */                            \
                    DosUnsetExceptionHandler(                              \
                            (PEXCEPTIONREGISTRATIONRECORD)&(excptstruct.RegRec2));
    #define END_CATCH                                                      \
                } /* end else (excptstruct.ulExcpt == 0) */                \
            } /* end variable scope block */


    /*
     * CRASH:
     *      this macro is helpful for testing
     *      the exception handlers.
     *      This is not for general use. ;-)
     */

    #define CRASH {PSZ p = NULL; *p = 'a'; }

#endif // EXCEPT_HEADER_INCLUDED

#if __cplusplus
}
#endif

