
/*
 * dosh.h:
 *      header file for dosh.c. See remarks there.
 *
 *@@include #define INCL_DOSPROCESS
 *@@include #include <os2.h>
 *@@include #include "dosh.h"
 */

/*      Copyright (C) 1997-99 Ulrich Mller,
 *                            Christian Langanke.
 *      This file is part of the XWorkplace source package.
 *      XWorkplace is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XWorkplace main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef DOSH_HEADER_INCLUDED
    #define DOSH_HEADER_INCLUDED

    ULONG doshGetULongTime(VOID);

    BOOL doshQueryShiftState(VOID);

    BOOL doshIsWarp4(VOID);

    VOID doshEnumDrives(PSZ pszBuffer, PSZ pszFileSystem);

    CHAR doshQueryBootDrive(VOID);

    APIRET doshIsFixedDisk(ULONG  ulLogicalDrive,
                             PBOOL  pfFixed);

    APIRET doshAssertDrive(ULONG ulLogicalDrive, BOOL fSuppress);

    double doshQueryDiskFree(ULONG ulLogicalDrive); // 1 for A:, 2 for B:, 3 for C:, ...

    APIRET doshQueryDiskFSType(ULONG ulLogicalDrive, // in:  1 for A:, 2 for B:, 3 for C:, ...
                               PSZ   pszBuf);        // out: buffer for FS type

    APIRET doshQueryDiskType(ULONG  ulLogicalDrive,      // in: 1 = A:, 2 = B:, ...
                             PULONG pulDeviceType);      // out: device type

    BOOL doshIsFileOnFAT(const char* pcszFileName);

    APIRET doshIsValidFileName(const char* pcszFile);

    BOOL doshMakeRealName(PSZ pszTarget, PSZ pszSource, CHAR cReplace, BOOL fIsFAT);

    ULONG doshQueryFileSize(HFILE hFile);

    ULONG doshQueryPathSize(PSZ pszFile);

    BOOL doshQueryDirExist(PSZ pszDir);

    APIRET doshCreatePath(PSZ pszPath);

    APIRET doshSetCurrentDir(PSZ pszDir);

    PSZ doshQuerySysErrorMsg(APIRET arc);

    APIRET doshReadTextFile(PSZ pszFile,
                            PSZ* ppszContent);

    PSZ doshCreateBackupFileName(const char* pszExisting);

    ULONG doshWriteTextFile(const char* pszFile, const char* pszContent, BOOL fBackup);

    HFILE doshOpenLogFile(const char* pcszFilename);

    APIRET doshWriteToLogFile(HFILE hfLog, const char* pcsz);

    APIRET doshQuickStartSession(PSZ pszPath,     // in: program to start
                                 PSZ pszParams,   // in: parameters for program
                                 BOOL Visible,    // in: show program?
                                 BOOL Wait,       // in: wait for termination?
                                 PULONG pulSID,   // out: session ID
                                 PPID ppid);      // out: process ID

    APIRET doshSetPathAttr(const char* pcszFile, ULONG fAttr);

    /********************************************************************
     *                                                                  *
     *   Partition functions                                            *
     *                                                                  *
     ********************************************************************/

    /*
     *  The following code has been kindly supplied by Christian Langanke.
     *
     */

    /* file system types           */
    /* more to be defined here ... */
    #define PART_FSTYPE_HPFS         0x07
    #define PART_FSTYPE_NTFS         0x07
    #define PART_FSTYPE_BOOTMANAGER  0x0a
    #define PART_FSTYPE_DOS16        0x16
    #define PART_FSTYPE_EXT2         0x83

    /* partition status */
    #define PART_STATUS_BOOTABLE        1
    #define PART_STATUS_STARTABLE       2
    #define PART_STATUS_ALL            -1

    /* types used by APIs below */
    typedef struct _PARTITION
    {
          ULONG          ulDisk;
          CHAR           szName[ 9];
          CHAR           szDrive[ 3];
          ULONG          ulVType;
          ULONG          ulFStype;
          ULONG          ulStatus;
          ULONG          ulStart;
          ULONG          ulSize;
    } PARTITION, *PPARTITION;

    typedef LHANDLE HPARTITION, *PHPARTITION;

    APIRET doshFindFirstPartition( PHPARTITION  php, ULONG ulStatus, PVOID ppartitionlist, ULONG ulBuflen, PULONG ulEntries);

    APIRET doshFindNextPartition( HPARTITION php, PVOID ppartitionlist, ULONG ulBuflen, PULONG ulEntries);

    APIRET doshFindClosePartition( HPARTITION hpl);

#endif

#if __cplusplus
}
#endif

