#
# Makefile for the WarpIn project.
#
# This thing compiles the whole WarpIN thing, that is, WARPIN.EXE and
# WIC.EXE, including the back-end. Personally, I'm using VAC++ 3.0,
# but Jens Bckman says this works with GCC also.
#
# For use with IBM NMAKE, which is part of IBM C-Set/2 and VisualAge C++.
# This file will probably not work with other MAKE utilities, such as
# GNU make or DMAKE.
#
#       Copyright (C) 1998 Ulrich Mller.
#       This file is part of the WarpIn package.
#       WarpIn is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published
#       by the Free Software Foundation, in version 2 as it comes in the
#       "COPYING" file of the WarpIn distribution.
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#

# First define the suffixes for files which NMAKE will work on.
# .SUFFIXES is a reserved NMAKE keyword ("pseudotarget") for
# defining file extensions that NMAKE will recognize in inference
# rules.

.SUFFIXES: .cpp .obj .dll .idl .h .ih .rc .res

# Call some script which sets the environment for the compiler.
# The !if is just there for your confusion. We simply want to
# execute the commands. If you have everything set already,
# you can delete this statement.

!if [call envicc.cmd > NUL]
!endif

# Set up a few environment variables. This is done with
# "macros" (in NMAKE terminology), which are assumed when
# a "=" is encountered.

# The following is the directory for precompiled header files.
# This is a feature of VAC++ 3.0 to speed up compilation. If
# the PRECH variable is not defined, precompiled header files
# will not be used. I strongly recommend using a RAM disk for
# this (as for TEMP files in general).
# We create a _separate_ precompiled header file for each
# source file (in the $(PRECH) directory). This eats up a lot
# of disk space, but makes sure that the precompiled header
# does not get recreated for each source file. If you don't
# like this, get rid of it. That's slower though.
PRECH = $(TEMP)

# HELPERS must be the path to the XFolder /HELPERS directory.
# WarpIn does not require XFolder to run, but needs a bit of
# source code from XFolder so that I don't have to rewrite
# everything. The .OBJ files from these sources are created
# in our own directory, because we are using different compiler
# options than XFolder does (we're using the C files as C++
# code).
HELPERS = ..\helpers
# G:\develop\C\XFolder\source\helpers
#

# INCLUDE must include the "wiarchive" directory (for the back-end
# which does the archive handling) as well as the directory where
# you have the Standard Template Libary (STL).
# For VAC++, the STL can be downloaded from
# "http://corp.metabyte.com/~fbp/stl/".
# With EMX/GCC, this is already included. You can delete the
# STL path then.
INCLUDE = $(INCLUDE);$(HELPERS);../wiarchive;../zlib;K:/develop/STL

# ICC environment variable for compiler options.
ICC     =
# /Wcnd- /Wgen- /Wcpy /Wobs- /Word- /Wcns+ /Wcnv-

# Compiler macro. This is used for each .OBJ file to be created.
CC      = icc /c /Ge /Gm+ /Gd- /Re /O- /Oi- /ol- /q+ /Se /ss /Ti+ /Tn+ \
              /w1 /Wcls+ /Wcpy+ /Wcmp+ /Wobs+ /Word+ /Wpro+ /Wrea+ /Wret+ /Wuni+ /Wuse+

# Some VisualAge C++ compiler options explained:
# /c:   compile only, no link (we'll call the linker explicitly)
# /fi+: precompile header files
# /gd-: link runtime statically
# /ge-: create DLL code
# /gi+: fast integer execution
# /Gl+: remove unreferenced functions (when comp.+link in 1 step)
# /gm+: multithread libraries
# /kc+: produce preprocessor warnings
# /o+:  optimization (inlining etc.)
# /oi-: no inlining (?)
# /ol+: use intermediate linker
# /q+:  suppress icc logo
# /Re : don't use subsystem libraries (!= Rn)
# /se:  all language extensions
# /si+: allow use of precompiled header files
# /ss:  allow double slashes comments in C too
# /ti+: debug code
# /tdp: compile everything as C++, even if it has a .C suffix
# /Tn:  add source line numbers to object files (for mapfile)
# /Wcls: class problems
# /Wcnd: conditional exprs problems (= / == etc.)
# /Wcmp: possible unsigned comparison redundancies
# /Wcns: operations involving constants
# /Wcnv: conversions
# /Wcpy: copy constructor problems
# /Wgen: generic debugging msgs
# /Wobs: obsolete features
# /Word: unspecified evaluation order
# /Wpar: list not-referenced parameters (annoying)
# /Wppc: list possible preprocessor problems (.h dependencies)
# /Wpro: warn if funcs have not been prototyped
# /Wrea: mark code that cannot be reached
# /Wret: check consistency of return levels
# /Wuni: uninitialized variables
# /Wuse: unused variables
# /w2:   produce error and warning messages, but no infos

LINK = ilink /map /nologo /linenumbers

# /optfunc /debug

# The LIBS macro contains all the .LIB files, either from the compiler or
# others, which are needed for this project:
#   pmprintf    is for debugging (in /HELPERS)
# The other OS/2 libraries are used by default.
LIBS = $(HELPERS)\pmprintf.lib

# The HLPOBJS macro contains all the .OBJ files which need to be
# created from XFolder's HELPERS directory.
HLPOBJS = dosh.obj winh.obj stringh.obj threads.obj gpih.obj prfh.obj except.obj debug.obj
# The WIOBJS macro contains all the .OBJ files which we need from
# the back-end (the WIArchive class).
WIOBJS  = wiarchive.obj wicomp.obj widecomp.obj
# The ZLIBOBJS macro contains all the .OBJ files which we need from
# the ZLIB compression library.
ZLIBOBJS = adler32.obj compress.obj crc32.obj gzio.obj uncompr.obj deflate.obj trees.obj \
       zutil.obj inflate.obj infblock.obj inftrees.obj infcodes.obj infutil.obj inffast.obj
# The FEOBJS macro has all the .OBJ files which are needed for the
# front-end (WARPIN.EXE).
FEOBJS = $*.obj gui.obj config.obj database.obj pckinfo.obj $(HLPOBJS) $(WIOBJS) z.lib

# The HEADERS macro contains common header files. If one of these has
# been changed, everything will be recompiled.
HEADERS = $(HELPERS)\winh.h $(HELPERS)\dosh.h $(HELPERS)\stringh.h $(HELPERS)\threads.h

# The WARPINH macro contains the warpin.h and the headers that warpin.h includes itself.
WARPINH = common.h warpin.h config.h pckinfo.h calbacks.h

# Main targets
all: ..\warpin.exe ..\wic.exe ..\warpin.msg

# 1) files in this directory
.cpp.obj:
        @ echo Compiling $*.cpp:
!ifndef PRECH
        $(CC) $*.cpp
!else
        $(CC) /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch"  $*.cpp
!endif

# 2) same thing for the source files in /HELPERS; the .OBJ files
#    will be created in our directory too.
{$(HELPERS)}.c.obj:
        @ echo Compiling $*.c:
!ifndef PRECH
        $(CC) /tdp $(HELPERS)/$*.c
!else
        $(CC) /tdp /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch" $(HELPERS)/$*.c
!endif

# 3) same thing for the files in ../WIARCHIVE
{..\wiarchive}.cpp.obj:
        @ echo Compiling $*.cpp:
!ifndef PRECH
        $(CC) ..\wiarchive\$*.cpp
!else
        $(CC) /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch" ..\wiarchive\$*.cpp
!endif

# 4) same thing for the files in ../ZLIB; this is C code, no C++
{..\zlib}.c.obj:
        @ echo Compiling $*.c:
!ifndef PRECH
        $(CC) ..\zlib\$*.c
!else
        $(CC) /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch" ..\zlib\$*.c
!endif

#
# Now define dependencies for all our .obj files by telling NMAKE
# which .OBJ file depends on what. For each .obj we define what files
# will enforce a recompilation when they've been changed.
#

# HELPERS
dosh.obj: $(HELPERS)\$*.c $(HEADERS)

except.obj: $(HELPERS)\$*.c $(HELPERS)\$*.h $(HEADERS)

debug.obj: $(HELPERS)\$*.c $(HELPERS)\$*.h $(HEADERS)

winh.obj: $(HELPERS)\$*.c $(HEADERS)

stringh.obj: $(HELPERS)\$*.c $(HEADERS)

threads.obj: $(HELPERS)\$*.c $(HEADERS)

prfh.obj: $(HELPERS)\$*.c $(HEADERS)

gpih.obj: $(HELPERS)\$*.c $(HEADERS)

# ..\WIARCHIVE
wiarchive.obj: ..\wiarchive\$*.cpp ..\wiarchive\wiarchive.h

wicomp.obj: ..\wiarchive\$*.cpp ..\wiarchive\wiarchive.h

widecomp.obj: ..\wiarchive\$*.cpp ..\wiarchive\wiarchive.h

# ..\zlib:
z.lib: $(ZLIBOBJS)
    ilib z.lib $(ZLIBOBJS),,

# .OBJs for executables in this directory
warpin.obj: $*.cpp $(WARPINH) \
        $(HELPERS)\dosh.h $(HELPERS)\stringh.h $(HELPERS)\threads.h $(HELPERS)\except.h \
        config.h \
        ..\wiarchive\wiarchive.h

gui.obj: $*.cpp $*.h    \
        $(HELPERS)\dosh.h $(HELPERS)\winh.h $(HELPERS)\gpih.h $(HELPERS)\stringh.h $(HELPERS)\threads.h $(HELPERS)\except.h \
        ..\wiarchive\wiarchive.h \
        $(WARPINH)

config.obj: $*.cpp $*.h $(HELPERS)\stringh.h $(HELPERS)\dosh.h $(HELPERS)\winh.h $(HELPERS)\prfh.h

database.obj: $*.cpp $*.h $(WARPINH) $(HEADERS) $(HELPERS)\except.h ..\wiarchive\wiarchive.h

pckinfo.obj: $*.cpp $*.h calbacks.h config.h errors.h $(HELPERS)\prfh.h ..\wiarchive\wiarchive.h

wic.obj: $*.cpp $(HEADERS) ..\wiarchive\wiarchive.h

# resources
warpin.res: $*.rc $*.h gui.h $*.dlg *.ico
    rc -r -x2 $*.rc

# msg file
warpin.msg: $$(@B).txt
         mkmsgf $*.txt $*.msg

# "WarpIn" executable
warpin.exe: gui.h $*.h $(FEOBJS) $*.res warpin.mak
          $(LINK) /PMTYPE:PM $(FEOBJS) $(LIBS)
          mapsym /n warpin.map
          rc -p -x2 $*.res $*.exe

# "Creator" executable
wic.exe: $*.obj $(HLPOBJS) $(WIOBJS) z.lib warpin.mak
          $(LINK) /PMTYPE:VIO $*.obj $(LIBS) $(HLPOBJS) $(WIOBJS) z.lib

# main target files in parent directory
..\wic.exe: wic.exe
          copy wic.exe ..

..\warpin.exe: warpin.exe
          copy warpin.exe ..
          copy warpin.sym ..
          del warpin.map

..\warpin.msg: warpin.msg
          copy warpin.msg ..
