
/*
 * warpin.h:
 *      header file for both warpin.cpp and gui.cpp.
 *
 *      This contains only declarations which are independent of the
 *      implemented GUI, i.e. for the platform-independent frontend
 *      stuff (warpin.cpp).
 *
 *      See warpin.cpp for more about this concept.
 *
 *      Note that this automatically #include's cfgsys.h and pckinfo.h.
 *
 *      Copyright (C) 1998-99 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#include "common.h"

#include "wiarchive.h"
#include "errors.h"
#include "config.h"
#include "pckinfo.h"
#include "calbacks.h"

/*******************************************************************
 *                                                                 *
 *  Declarations                                                   *
 *                                                                 *
 ******************************************************************/

#define MODE_TEXT           1       // this page is plain text
#define MODE_README         2       // this page is a readme (MLE)
#define MODE_CONTAINER      3       // this is the "Container" page
#define MODE_CONFIGURE      4       // this is the "Configure" page
// #define MODE_INSTALL        5       // this is the "Install" page

/*
 *@@ WPIPAGEINFO:
 *      one of these structures is created for each PAGE block
 *      found in the install script by ParsePages (warpin.cpp).
 *
 *      A list of all the pages is stored in WPIGLOBALS.PageInfoList.
 */

typedef struct _WPIPAGEINFO
{
    LONG    lPageIndex,     // index of this page
            lPageMode;      // MODE_* flags above

    PSZ     pszInfoText;    // has text found in <TEXT> ... </TEXT> block

    PSZ     pszReadmeText;  // for the README page, this has the MLE text

    LONG    lNextButton;
                // the "Next" button:
                // -- if > 0, the button is visible and enabled
                //    and has the index of the next page;
                // -- if == 0, the button is hidden;
                // -- if < 0, the button is disabled.
    PSZ     pszNextButtonTitle;
                // the button text

    // constructor
    _WPIPAGEINFO()
    {
        lPageIndex = 0;
        lPageMode = 0;
        pszInfoText = "error, text not defined";
        pszReadmeText = "error, text not defined";
        ULONG ul;

        lNextButton = 0;
        pszNextButtonTitle = "~Next";
    }

} WPIPAGEINFO, *PWPIPAGEINFO;

// flags for WPIGLOBALS.ulInstallAction:
#define ACTION_ADDREMOVE          0       // default
#define ACTION_PROMPT             1       // default if packages are found
#define ACTION_REPAIR             2
#define ACTION_DEINSTALL          3

// flags for WPIGLOBALS.ulConfigureFlags;
// these flags are set if _any_ package has
// corresponding attributes in the script;
// otherwise WPIGLOBALS.ulConfigureFlags == 0
#define CONFIG_CONFIGSYS    0x01    // CONFIG.SYS can be updated
#define CONFIG_WPSCLASSES   0x02    // WPS classes can be installed
#define CONFIG_WPSOBJECTS   0x04    // WPS objects can be created

// flags for the "File exists" fields in WPIGLOBALS:
#define FE_PROMPT      0        // 0: prompt
#define FE_SKIP        1        // 1: skip
#define FE_OVERWRITE   2        // 2: overwrite


/*
 * WPIGLOBALS:
 *      global structure in warpin.cpp which gets
 *      passed to guiBeginAddRemove. This has
 *      all the info you'll ever need.
 */

typedef struct _WPIGLOBALS
{
    /*
     * Global data (always set by main()):
     *
     */

    // anchor block of this (opened by main())
    HAB                 habThread1;

    // fully qualified file name of WARPIN.EXE
    CHAR                szWarpINFile[2*CCHMAXPATH];

    // profile handle of WARPIN.INI (opened by main())
    HINI                hiniWarpIN;

    // profile handle of DATABASE.INI (opened by datInitialize())
    HINI                hiniDatabase;

    ULONG               ulInstallAction;     // ACTION_* flags

    // list of all packages in the Global Database
    list<PackageInfo*>  DBPckList;

    /*
     * Data for "Install" mode:
     *
     */

    // the archive to work on (C++ class in wiarchive.h)
    CHAR                szArcFilename[2*CCHMAXPATH];
    WIArchive           Arc;
    const WIArcHeader*  pArcHeader;

    // the installation profile found in the archive
    PSZ                 pszProfile;

    // list of packages in the archive (returned by WIArchive)
    list<WIPackHeader*>* pPackageList;
    // list of package infos (created by ParsePackages)
    list<PackageInfo*>  PackageInfoList;
    // list of packages which are already installed;
    // this has those elements in PackageInfoList whose
    // ulInstallStatus is != INSTALLED_NO.
    // Note: The items in this list point to the same
    // items as in PackageInfoList. This is _not_ database
    // information!
    list<PackageInfo*>  AlreadyInstalledList;

    // list of pages in the install script;
    // this is passed to the GUI
    list<WPIPAGEINFO*>  PageInfoList;

    list<LONG>          lPagesList;
                                // list of indices to the pages that
                                // were visited; initially empty

    // settings for the GUI
    BOOL                fInstallationComplete;

    ULONG               ulConfigureFlags;
                                // ORed CONFIG_* flags;
                                // this set by main() as _input_ to the GUI
                                // so that it knows what configuration was
                                // found in the archives;
                                // 0 if no configuration is necessary at all
    ULONG               ulDoConfiguration;
                                // ORed CONFIG_* flags;
                                // the GUI is responsible for setting these
                                // when leaving the CONFIGURE page so that
                                // warpin.cpp knows whether to do config
    ULONG               ulConfigurationDone;
                                // ORed CONFIG_* flags;
                                // what warpin.cpp has actually changed on the
                                // system

    // the following flags are for when a file exists:
                                // 0: prompt
                                // 1: skip
                                // 2: overwrite
    ULONG               ulIfSameDate,       // default: 2
                        ulIfExistingOlder,  // default: 2
                        ulIfExistingNewer;  // default: 0

    // install thread
    PTHREADINFO         ptiInstallThread;

    /*
     *@@ _WPIGLOBALS:
     *      constructor.
     */

    _WPIGLOBALS()
    {
        habThread1 = NULLHANDLE;
        szWarpINFile[0] = 0;
        hiniWarpIN = NULLHANDLE;
        hiniDatabase = NULLHANDLE;

        ulInstallAction = ACTION_ADDREMOVE;

        szArcFilename[0] = 0;
        pArcHeader = NULL;
        pszProfile = NULL;
        fInstallationComplete = FALSE;

        pPackageList = 0;
            // the other lists have their own constructors

        fInstallationComplete = FALSE;
        ulConfigureFlags = 0;
        ulDoConfiguration = 0;
        ulConfigurationDone = 0;

        // file exists
        ulIfSameDate = 2;           // overwrite
        ulIfExistingOlder = 2;      // overwrite
        ulIfExistingNewer = 0;      // prompt

        ptiInstallThread = NULL;
    }

} WPIGLOBALS, *PWPIGLOBALS;

/*******************************************************************
 *                                                                 *
 *  Prototypes for funcs in warpin.cpp                             *
 *                                                                 *
 ******************************************************************/

APIRET wpiGetMessage(PCHAR *pTable,
                     ULONG ulTable,
                     PSZ pszBuf,
                     ULONG cbBuf,
                     ULONG ulMsgNumber);

VOID wpiParseError(ULONG ulOfs, PSZ pszInfo, PSZ pszExtra);

void wpiCTime2FTime(time_t *pCTime,
                    FDATE *pfDate,
                    FTIME *pfTime);

int wpiCompareFileDates(WIFileHeader* pHeader,
                        FILESTATUS3 *pfs3,
                        FDATE *pfdateLastWrite,
                        FTIME *pftimeLastWrite);

BOOL wpiCreateCIDFile(PSZ pszFilename);

BOOL wpiConfigSys();

BOOL wpiWPSClasses();

BOOL wpiCreateObjects(VOID);

/*******************************************************************
 *                                                                 *
 *  Install thread                                                 *
 *                                                                 *
 ******************************************************************/

VOID wpiStartInstallThread(VOID);

/*******************************************************************
 *                                                                 *
 *  Database helper functions (database.cpp)                       *
 *                                                                 *
 ******************************************************************/

/*
 *@@ PACKAGEID:
 *      structure returned by datSplitPackageID.
 */

typedef struct _PACKAGEID
{
    PSZ     pszAuthor,
            pszApplication,
            pszPackage;
    ULONG   ulVersionMajor,
            ulVersionMinor;

    /*
     *@@ _PACKAGEID:
     *      constructor
     */

    _PACKAGEID()
    {
        memset(this, 0, sizeof(*this));
    }

    /*
     *@@ ~_PACKAGEID:
     *      destructor
     */

    ~_PACKAGEID()
    {
        if (pszAuthor)
            free(pszAuthor);
        if (pszApplication)
            free(pszApplication);
        if (pszPackage)
            free(pszPackage);
    }
} PACKAGEID, *PPACKAGEID;

BOOL datInitialize(PWPIGLOBALS pWpiGlobalsPassed);

VOID datAddFileHeader(PackageInfo* pPckInfo, WIFileHeader* pwifh);

list<WIFileHeader*>* datGetFileHeaders(PackageInfo* pPckInfo, PULONG pulHeaderCount);

PPACKAGEID datSplitPackageID(PSZ pszPackageID);

PSZ datEnumPackages(PSZ pszPackageSearch);

PSZ datFindPackage(PSZ pszAuthor,
                   PSZ pszApplication,
                   PSZ pszPackageName);

/* PackageInfo* datLoadPackage(PSZ pszPackage);

BOOL datStorePackage(PackageInfo* pPckInfo); */

BOOL datRemovePackage(PackageInfo* ppiRemove);

BOOL datVerifyPackages(list<PackageInfo*>* pPckInfoList,
                       ULONG ulUser);

#define DBDEINST_CONFIGSYS           0x0010
#define DBDEINST_WPSCLASSES          0x0020
#define DBDEINST_WPSOBJECTS          0x0040

BOOL datDeinstallPackages(list<PackageInfo*>* pPckInfoList,
                          ULONG ulFlags,
                          ULONG ulUser);


