
/*
 * pckinfo.h:
 *      header file for the PackageInfo class.
 *
 *      Required #include's before #include'ing this:
 *          #define INCL_WINSHELLDATA
 +          #define INCL_WINWORKPLACE
 +          #include <os2.h>
 +          #include <string.h>
 +          #include "wiarchive.h"
 +          #include "config.h"
 *
 *      or warpin.h, which will include all this.
 *
 *      Copyright (C) 1998-99 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WPI_PACKAGEINFO_INCLUDE
#define WPI_PACKAGEINFO_INCLUDE

// flags for PackageInfo.ulType
#define PCK_PCK     1               // recc is package
#define PCK_GROUP   2               // recc is group

// flags for PackageInfo.ulPathType
#define PATH_DISABLED   0x00        // path cannot be changed
#define PATH_VARIABLE   0x01        // path can be freely changed
#define PATH_BASE       0x02        // path is base for all packages

// flags for PackageInfo.ulInstallStatus
#define INSTALLED_NO            0   // package not installed
#define INSTALLED_OLDER         1   // package is installed and older than in archive;
                                    // it should be updated then
#define INSTALLED_NEWER         2   // package is installed and newer than in archive
                                    // it should _not_ be updated then
#define INSTALLED_SAME          3   // package is installed and same as in archive

/*
 *@@ PackageInfo:
 *      one of these structures is created for each PCK block
 *      found in the install script by ParsePackages (warpin.cpp).
 *
 *      A list of all the pages is stored in WPIGLOBALS.PackageInfoList.
 */

class PackageInfo
{
    public:
        // the following fields are set when this structure
        // is created
        ULONG          ulType;          // PCK_* flags
        PackageInfo*   ppiGroup;       // the group this package belongs to or NULL

        PSZ            pszTitle;        // "TITLE=" attribute (displayed in container)
        PSZ            pszInfo;         // body of PCK block (informational text)

        PSZ            pszID;           // "ID=" attribute
        PSZ            pszRequiresID;   // "REQUIRES=" attribute (ID string, optional)

        CHAR           szTargetPath[CCHMAXPATH]; // "TARGET=" attribute

        ULONG          ulSize;          // uncompressed total size of package
        ULONG          ulSelection;     // 0 = no,
                                        // 1 = yes,
                                        // for groups: 2 = some
        BOOL           fNoDeselect;     // "NODESELECT" attribute in <PCK> tag

        // CONFIG.SYS changes
        // 1)   manipulators according to script attributes
        AttrLogger              logCfgSysAttrs;
        list<CfgSysManip*>      listCfgSysAttrsAttrs;
        CfgSysDoneLogger        logCfgSysDone;
        // 2)   manipulators according to database (actual changes made)
        list<CfgSysManip*>      listUndoCfgSys;

        // registered WPS classes
        // 1)   classes according to script attributes
        AttrLogger              logRegisterClassAttrsAttrs;
        list<RegisterClass*>    listRegisterClassAttrs;
        RegisterDoneLogger      logRegisterClassAttrsDone;
        // 2)   list according to database (actual changes made,
        //      created from previous DoneLogger in Database mode)
        list<DeregisterClass*>  listUndoRegisterClass;

        // replaced WPS classes
        // 1)   classes according to script attributes
        AttrLogger              logReplaceClassAttrs;
        list<ReplaceClass*>     listReplaceClass;
        ReplaceDoneLogger       plogReplaceClassDone;
        // 2)   list according to database (actual changes made,
        //      created from previous DoneLogger in Database mode)
        list<UnreplaceClass*>   listUndoReplaceClass;

        // created WPS objects
        // 1)   classes according to script attributes
        AttrLogger              logWPSObjectAttrsAttrs;
        list<CreateWPSObject*>  listWPSObjectAttrs;
        WPSObjectsDoneLogger    logWPSObjectAttrsDone;
        // 2)   list according to database (actual changes made,
        //      created from previous DoneLogger in Database mode)
        list<DeleteWPSObject*>  listUndoWPSObject;

        PSZ            pszExecute;      // "EXECUTE=" attribute (optional)
        ULONG          ulPathType;      // ORed PATH_* flags

        PVOID          pvGuiData;       // reverse linkage to PCKRECORDCORE in cnr

        WIPackHeader   PackHeader;      // copy of package header in archive

        // the following fields are updated while this
        // package is being installed
        PSZ            pszFilesList;    // list of files that were installed,
                                        // each of which is null-terminated
        ULONG          cbFilesList;     // sizeof(*pszFilesList)

        // the following has the install status (Archive mode only)
        ULONG          ulInstallStatus; // INSTALLED_* flags
        // if (ulInstallStatus != INSTALLED_NO),
        // the following has the installed package version
        ULONG          ulInstalledVersionMajor,
                       ulInstalledVersionMinor;

        // the following is for the Database thread (Database mode only)
        ULONG          ulStatus;        // 0: status unknown
                                        // 1: errors found
                                        // 2: no errors found

        // methods
    private:
        void Init();
    public:
        PackageInfo();
        PackageInfo(HINI hiniDatabase, PSZ pszPackageID);
        ~PackageInfo();

        BOOL IsGroup(VOID);

        BOOL Select(BOOL fSelect, list<PackageInfo*>& PckInfoList);
        BOOL ToggleSelection(list<PackageInfo*>& PckInfoList);
        ULONG Selection(VOID);

        bool Store(HINI hiniDatabase);
};

#endif
