
/*
 * gui.h:
 *      header file for gui.c.
 *
 *      This contains only declarations which are platform-specific,
 *      in this case specific to OS/2 Presentation Manager (PM).
 *
 *      Copyright (C) 1999 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *@@ NLSSTRINGS:
 *      this has all the PSZs which are loaded from
 *      the string resources.
 */

struct NLSSTRINGS
{
    // Database thread report strings
    PSZ     pszFileNotFound,
            pszExistingFileNewer,
            pszExistingFileOlder,
            pszDeleteError,
            pszDeleteDirError,
            pszPackageRemoved,
            pszClassDeregistered,
            pszErrorDeregisteringClass,
            pszClassUnreplaced,
            pszErrorUnreplacingClass,
            pszObjectDeleted,
            pszErrorDeletingObject,
            pszCfgSysUndone,
            pszErrorUndoingCfgSys,

            pszWarningExistingNewer,

            pszUpdatingConfigSys,
            pszRegisteringClasses,
            pszCreatingObjects,

            pszDriveXFree,
            pszElapsed,
            pszToGo,
            pszPackageX,
            pszFileX,

            pszDrive,
            pszFreeKB,
            pszRequiredKB,

            pszDeinstallingArchive,
            pszDeinstallingPackage,
            pszDeinstallingApplication,
            pszVerifyingPackage,
            pszVerifyingApplication,

            pszFileName,
            pszSize,
            pszCreationDate,
            pszLastWriteDate,

            pszPackageName,
            pszVersion,
            pszAuthor,
            pszTargetPath,
            pszFiles,
            pszInstallDate,

            pszVerifying,
            pszDeleting,
            pszDone;
    // constructor: loads all the stuff
    NLSSTRINGS()
    {
        memset(this, 0, sizeof(*this));
    }
};

/*
 * PCKRECORDCORE:
 *      extended record core. This is used on the "Container"
 *      page in "Archive" mode. pPackageInfo points to the
 *      corresponding package.
 */

typedef struct _PCKRECORDCORE
{
    RECORDCORE     recc;                // standard record core
    PackageInfo*   pPckInfo;            // linkage to PACKAGEINFO
} PCKRECORDCORE, *PPCKRECORDCORE;

/*
 * DRIVERECORDCORE:
 *      extended record core for "Drive Info" window.
 *      This is only used in "Archive" mode with the
 *      "Container" page.
 */

typedef struct _DRIVERECORDCORE
{
    RECORDCORE     recc;                // standard record core
    ULONG          ulDrive;             // drive no. this recc represents
    ULONG          ulFree;              // free space on drive
    ULONG          ulRequired;          // required space on drive
} DRIVERECORDCORE, *PDRIVERECORDCORE;

/*
 *@@ DATABASERECORD:
 *      this is used for the "Database" container,
 *      both for applications (then pPackageInfo is NULL)
 *      and packages (then pPackageinfo points to the
 *      package info).
 */

typedef struct _DATABASERECORD
{
    RECORDCORE      recc;                // standard record core

    PackageInfo*    pPckInfo;            // pointer to package info (warpin.h);
                                         // for applications, this is NULL
    // the following are used for both applications and packages
    PSZ             pszAuthor;
    PSZ             pszApplication;

    // the following are used for packages only
    PSZ             pszPackageName;
    ULONG           ulVersionMajor;
    ULONG           ulVersionMinor;
    CHAR            szVersion[20];      // string composed of version number
    PSZ             pszVersion;         // points to szVersion
    ULONG           ulFiles;            // copy of pPackageInfo->PackHeader.files
    ULONG           ulTotalSize;        // copy of pPackageInfo->PackHeader.origsize
    PSZ             pszTargetPath;      // points to pPackageInfo->szTargetPath
    CDATE           cdateInstall;

    HWND            hwndFileList;       // if != NULLHANDLE, this has the open
                                        // file list window for this package
    HWND            hwndStatus;         // if != NULLHANDLE, this has the open
                                        // database status window for this package
                                        // (verification or de-installation)
} DATABASERECORD, *PDATABASERECORD;

/*
 * FILERECORDCORE:
 *      extended record core for "File List" window
 *      in "Data base" mode.
 */

typedef struct _FILERECORDCORE
{
    RECORDCORE     recc;                // standard record core
    ULONG          ulSize;
    CDATE          cdateCreation;
    CDATE          cdateLastWrite;
} FILERECORDCORE, *PFILERECORDCORE;

#define DBACTION_VERIFY         1
#define DBACTION_DEINSTALL      2

/*
 *@@ DATABASESTATUSINFO:
 *      database status window structure.
 *      This has two purposes:
 *      1)   this must be passed to fnwpDatabaseStatus
 *           as pCreate in WinLoadDlg (mp2 in WM_INITDLG)
 *           to tell the dialog what it should do (ulCmd below);
 *
 *      2)   then, a copy of this struct is allocated and
 *           stored in the dialog's QWL_USER.
 *
 *      Note that the handle of the database status
 *      window is also stored in the DATABASERECORD.
 */

typedef struct _DATABASESTATUSINFO
{
    // what the dialog should do
    ULONG           ulCmd;              // DBACTION_* flags (above)
    ULONG           ulFlags;
                    // only for DBACTION_DEINSTALL:
                    // null or any of the following:
                    // DBDEINST_CONFIGSYS
                    // DBDEINST_WPSCLASSES
                    // DBDEINST_WPSOBJECTS

    // list of packages to go for;
    // this does not have to be permanent
    list<PackageInfo*>* pPckInfoList;

    // window title
    PSZ             pszWindowTitle;

    // container with DATABASERECORDs to update;
    // if this is NULLHANDLE, no updating occurs (for "Deinstall package")
    HWND            hwndMainCnr;

    // the following is updated while the Database thread is running
    ULONG           ulCurrentFile,
                    ulTotalFiles;
    BOOL            fErrorsFound;

    // constructor
    _DATABASESTATUSINFO(ULONG ulCmd_,
                        ULONG ulFlags_,
                        list<PackageInfo*>* pPckInfoList_,
                        PSZ pszWindowTitle_,
                        HWND hwndMainCnr_)   // can be NULLHANDLE
    {
        this->ulCmd = ulCmd_;
        this->ulFlags = ulFlags_;
        this->pPckInfoList = pPckInfoList_;
        this->pszWindowTitle = strdup(pszWindowTitle_);
        this->hwndMainCnr = hwndMainCnr_;

        this->ulCurrentFile = 0;
        this->ulTotalFiles = 0;
        this->fErrorsFound = FALSE;
    }

    // copy constructor
    _DATABASESTATUSINFO(_DATABASESTATUSINFO &X)
    {
        this->ulCmd = X.ulCmd;
        this->ulFlags = X.ulFlags;
        this->pPckInfoList = X.pPckInfoList;
        this->pszWindowTitle = strdup(X.pszWindowTitle);
        this->hwndMainCnr = X.hwndMainCnr;

        this->ulCurrentFile = 0;
        this->ulTotalFiles = 0;
        this->fErrorsFound = FALSE;
    }

    // destructor
    ~_DATABASESTATUSINFO()
    {
        free(pszWindowTitle);
    }
} DATABASESTATUSINFO, *PDATABASESTATUSINFO;

/*
 *  Dialog ID's
 */

// standard buttons
#define ID_WIDI_BACKBUTTON               97
#define ID_WIDI_NEXTBUTTON               98
#define ID_WIDI_CANCELBUTTON             99

// icon IDs in resources
#define ID_ICON                         100
#define IDP_SELECTED                    101
#define IDP_DESELECTED                  102
#define IDP_SOMESELECTED                103

#define IDP_DB_QMARK                    151
#define IDP_DB_ERROR                    152
#define IDP_DB_OK                       153
#define IDP_DB_APP                      154

// bitmap IDs in resources
#define IDB_WARPINLOGO                  150

/*  dialogs  */
#define ID_WID_MAIN                     200
#define ID_WIDI_INFOTEXT                201
#define ID_WIDI_CNR                     202
#define ID_WIDI_READMEMLE               203

#define ID_WIDI_PATHTEXT                205
#define ID_WIDI_PATHENTRY               206

#define ID_WIDI_UPDATECONFIGSYS         210
#define ID_WIDI_INSTALLWPSCLASSES       211
#define ID_WIDI_CREATEWPSOBJECTS        212
#define ID_WIDI_CREATECIDCMD            213

#define ID_WIDI_CURPCKTXT               220
#define ID_WIDI_CURPCKTITLE             221
#define ID_WIDI_CURPCKCOUNT             222
#define ID_WIDI_CURFILETXT              223
#define ID_WIDI_CURFILENAME             224
#define ID_WIDI_CURFILECOUNT            225
#define ID_WIDI_TARGETPATHTXT           230
#define ID_WIDI_TARGETPATHDIR           231
#define ID_WIDI_TARGETPATHFREE          232

#define ID_WIDI_TIMETXT                 240
#define ID_WIDI_TIMEELAPSED             241
#define ID_WIDI_TIMELEFT                242

#define ID_WIDI_PROGRESSBAR             250

// subdialogs for pages
#define ID_WID_PAGE_TEXT                290
#define ID_WID_PAGE_README              291
#define ID_WID_PAGE_CONTAINER           292
#define ID_WID_PAGE_CONFIGURE           293
#define ID_WID_PAGE_INSTALL             294

#define ID_WIDI_ICON                    299

// drive info
#define ID_WID_DRIVEINFO                300
#define ID_WIDI_DRIVECNR                301

// file exists
#define ID_WID_FILEEXISTS               400
#define ID_WIDI_EXISTS_TXT1             401
#define ID_WIDI_EXISTS_SKIP             404
#define ID_WIDI_EXISTS_RENAME           406
#define ID_WIDI_EXISTS_RENAMETXT        407
#define ID_WIDI_EXISTS_DATEOLD          408
#define ID_WIDI_EXISTS_TIMEOLD          409
#define ID_WIDI_EXISTS_SIZEOLD          410
#define ID_WIDI_EXISTS_DATENEW          411
#define ID_WIDI_EXISTS_TIMENEW          412
#define ID_WIDI_EXISTS_SIZENEW          413
#define ID_WIDI_EXISTS_INFOTEXT         414

// confirmation settings
#define ID_WID_CONFIRMATIONS            450
#define ID_WID_EXISTOLDER_PROMPT        451
#define ID_WID_EXISTOLDER_OVERWRITE     452
#define ID_WID_EXISTOLDER_SKIP          453
#define ID_WID_EXISTSAME_PROMPT         454
#define ID_WID_EXISTSAME_OVERWRITE      455
#define ID_WID_EXISTSAME_SKIP           456
#define ID_WID_EXISTNEWER_PROMPT        457
#define ID_WID_EXISTNEWER_OVERWRITE     458
#define ID_WID_EXISTNEWER_SKIP          459

// product info
#define ID_WID_PRODUCTINFO              500
#define ID_WIDI_VERSION                 501

#define ID_WID_WARPINSTARTUP            600

// global database
#define ID_WID_DATABASE                 700
#define ID_WIDI_DB_AUTHOR               701
#define ID_WIDI_DB_VERSION              702
#define ID_WIDI_DB_INSTALLDATE          703
#define ID_WIDI_DB_TARGETDIR            704
#define ID_WIDI_DB_FILES                705

// file list window
#define ID_WID_FILELIST                 800

// confirm deinstall window
#define ID_WID_CONFIRMDEINSTALL         850
#define ID_WIDI_CFD_PACKAGESLIST        851
#define ID_WIDI_CFD_DELETEFILES         852
#define ID_WIDI_CFD_FILESLIST           853
#define ID_WIDI_CFD_CONFIGSYS           854
#define ID_WIDI_CFD_CONFIGSYSLIST       855
#define ID_WIDI_CFD_WPSCLASSES          856
#define ID_WIDI_CFD_WPSCLASSESLIST      857
#define ID_WIDI_CFD_WPSOBJECTS          858
#define ID_WIDI_CFD_WPSOBJECTSLIST      859

// database thread status
#define ID_WID_DATABASETHREAD           900
#define ID_WIDI_DBT_APPLICATION         901
#define ID_WIDI_DBT_PACKAGE             902
#define ID_WIDI_DBT_FILE                903
#define ID_WIDI_DBT_FILEDATE_DATABASE   904
#define ID_WIDI_DBT_FILEDATE_EXISTING   905
#define ID_WIDI_DBT_PROGRESSBAR         906
#define ID_WIDI_DBT_REPORTMLE           907
#define ID_WIDI_DBT_SAVEREPORTAS        920

// "package already installed" dlg
#define ID_WID_ARCHIVEINSTALLED         950
#define ID_WIDI_AI_REPAIR               951
#define ID_WIDI_AI_ADDREMOVE            952
#define ID_WIDI_AI_DEINSTALL            953

// "enter variable" dlg
#define ID_WID_ENTERVARIABLE            970
#define ID_WIDI_EV_SETTEXT              971
#define ID_WIDI_EV_ENTRYFIELD           972

/*
 * Menus:
 *
 */

// main window menu bar
#define ID_WIM_MAINMENU                  1000

#define ID_WIM_WARPIN                    1001
#define ID_WIMI_CONFIRMATIONS            1002
#define ID_WIMI_EXIT                     1003

#define ID_WIM_HELP                      1100
#define ID_WIMI_HELPINDEX                1101
#define ID_WIMI_HELPGENERAL              1102
#define ID_WIMI_HELPUSINGHELP            1103
#define ID_WIMI_HELPPRODUCTINFO          1104

// context menus for database
#define ID_WIM_DATABASE_APP              1200
#define ID_WIMI_DATABASE_DEINSTALLAPP    1201
#define ID_WIMI_DATABASE_VERIFYAPP       1202
#define ID_WIMI_DATABASE_REMOVEAPP       1203

#define ID_WIM_DATABASE_PACKAGE          1220
#define ID_WIMI_DATABASE_DEINSTALLPCK    1221
#define ID_WIMI_DATABASE_VERIFYPCK       1222
#define ID_WIMI_DATABASE_SHOWPCK         1223
#define ID_WIMI_DATABASE_REMOVEPCK       1224

#define ID_WIM_DATABASE_WHITESPACE       1240
#define ID_WIM_DATABASE_VIEW             1241
#define ID_WIMI_DATABASE_TREEVIEW        1242
#define ID_WIMI_DATABASE_DETAILSVIEW     1243

// string IDs

// database thread report strings
#define WPSI_FILENOTFOUND                       3000
#define WPSI_EXISTINGFILENEWER                  3001
#define WPSI_EXISTINGFILEOLDER                  3002
#define WPSI_DELETEERROR                        3003
#define WPSI_DELETEDIRERROR                     3004
#define WPSI_PACKAGEREMOVED                     3005
#define WPSI_CLASSDEREGISTERED                  3006
#define WPSI_ERRORDEREGISTERINGCLASS            3007
#define WPSI_CLASSUNREPLACED                    3008
#define WPSI_ERRORUNREPLACINGCLASS              3009
#define WPSI_OBJECTDELETED                      3010
#define WPSI_ERRORDELETINGOBJECT                3011
#define WPSI_CFGSYSUNDONE                       3012
#define WPSI_ERRORUNDOINGCFGSYS                 3013

#define WPSI_WARNINGEXISTINGNEWER               3014

#define WPSI_UPDATINGCONFIGSYS                  3015
#define WPSI_REGISTERINGCLASSES                 3016
#define WPSI_CREATINGOBJECTS                    3017

#define WPSI_DRIVEXFREE                         3018
#define WPSI_ELAPSED                            3019
#define WPSI_TOGO                               3020
#define WPSI_PACKAGEX                           3021
#define WPSI_FILEX                              3022

#define WPSI_DRIVE                              3023
#define WPSI_FREEKB                             3024
#define WPSI_REQUIREDKB                         3025

#define WPSI_DEINSTALLINGARCHIVE                3026
#define WPSI_DEINSTALLINGPACKAGE                3027
#define WPSI_DEINSTALLINGAPPLICATION            3028
#define WPSI_VERIFYINGPACKAGE                   3029
#define WPSI_VERIFYINGAPPLICATION               3030

#define WPSI_FILENAME                           3031
#define WPSI_SIZE                               3032
#define WPSI_CREATIONDATE                       3033
#define WPSI_LASTWRITEDATE                      3034

#define WPSI_PACKAGENAME                        3035
#define WPSI_VERSION                            3036
#define WPSI_AUTHOR                             3037
#define WPSI_TARGETPATH                         3038
#define WPSI_FILES                              3039
#define WPSI_INSTALLDATE                        3040

#define WPSI_VERIFYING                          3041
#define WPSI_DELETING                           3042
#define WPSI_DONE                               3043

// extra window messages used in fnwpMain
#define WPIM_TURNTOPAGE                    WM_USER+1
#define WPIM_QUERYDRIVES                   WM_USER+2
#define WPIM_UPDATE                        WM_USER+3
#define WPIM_FILEEXISTS                    WM_USER+4
#define WPIM_UPDATEPACKAGE                 WM_USER+5
#define WPIM_UPDATEFILE                    WM_USER+6
#define WPIM_UPDATEBYTES                   WM_USER+7
#define WPIM_DONEWITHINSTALL               WM_USER+8
#define WPIM_INSTALLERROR                  WM_USER+9
#define WPIM_PACKAGEREMOVED                WM_USER+10
#define WPIM_ADDSTRING                     WM_USER+11

