
/*
 * errors.h:
 *      this declares a number of C++ exception classes which
 *      are used throughout WarpIN for a more flexible error
 *      handling.
 *
 *      This file Copyright (C) 1999 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WPI_ERRORS_INCLUDE
#define WPI_ERRORS_INCLUDE

/*
 *@@ CancelExcpt:
 *      dummy exception class which can be thrown by anything,
 *      and WarpIN will terminate itself.
 *      This is caught only by main(), so this is a quick way
 *      to exit WarpIN.
 */

class CancelExcpt {};

/*
 *@@ ErrorMessageExcpt:
 *      if this is thrown, WarpIN will display an error message
 *      and exit.
 */

class ErrorMessageExcpt
{
    public:
        PSZ     pszMessage;

        ErrorMessageExcpt(PSZ pszMessage_)
        {
            pszMessage = pszMessage_;
        }
};

/*
 *@@ EnvironmentExcept:
 *      exception thrown by GetEnvironment (warpin.cpp)
 *      if an invalid environment variable value
 *      has been encountered.
 */

class EnvironmentExcept
{
    public:
        PSZ     pszCommand,
                pszValue;

        // constructor (copies the strings)
        EnvironmentExcept(PSZ pszCommand_, PSZ pszValue_)
        {
            pszCommand = strdup(pszCommand_);
            pszValue = strdup(pszValue_);
        }

        // copy constructor (required for catch() blocks)
        EnvironmentExcept(const EnvironmentExcept& X)
        {
            pszCommand = strdup(X.pszCommand);
            pszValue = strdup(X.pszValue);
        }

        // destructor
        ~EnvironmentExcept()
        {
            if (pszCommand)
                free(pszCommand);
            if (pszValue)
                free(pszValue);
        }
};

#endif
