
/*
 * database.h:
 *      header file for database.h.
 *
 *      This contains only the database-specific declarations.
 *
 *      Copyright (C) 1999 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#define DBT_VERIFY          1
#define DBT_DEINSTALL       2

/*
 *@@ DATABASETHREADINFO:
 *      thread info stored in PTHREADINFO->ulData
 *      to be passed to the database thread.
 */

typedef struct _DATABASETHREADINFO
{
    list<PackageInfo*>  PckInfoList;   // package list to work on;
                // for "package mode", this contains one package only,
                // for "application mode", this has all the packages
                // of the application
    ULONG                   ulTask;    // DBT_* flags (what to do)
    ULONG                   ulDeinstall;    // for DBT_DEINSTALL:
                                       // addt'l DBDEINST_* flags (warpin.h)
    ULONG                   ulUser;    // user parameter passed to callback

    /*
     *@@ _DATABASETHREADINFO:
     *      constructor with parameters, all of which
     *      _must_ be specified.
     */

    _DATABASETHREADINFO(ULONG ulTask_, // DBT_* flag (what to do)
                        ULONG ulDeinstall_, // DBDEINST_* flags (warpin.h)
                        ULONG ulUser_) // user parameter passed to callback
    {
        this->ulTask   = ulTask_;
        this->ulDeinstall = ulDeinstall_;
        this->ulUser   = ulUser_;
    }

} DATABASETHREADINFO, *PDATABASETHREADINFO;


