
/*
 * calbacks.h:
 *      this defines all the GUI callbacks.
 *
 *      Required #include's before #include'ing this:
 +          #include <os2.h>
 +          #include "wiarchive.h"
 +          #include "pckinfo.h"
 *
 *      Copyright (C) 1998-99 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*******************************************************************
 *                                                                 *
 *  Required GUI callbacks on main thread (gui.cpp)                *
 *                                                                 *
 ******************************************************************/

BOOL guiInitialize(void);

VOID guiCleanupBeforeExit(void);

ULONG guiMessageBox(PSZ pszTitle,
                    PSZ pszMessage,
                    ULONG ulFlags);

VOID guiDisplayErrorMessage(ULONG ulTitleMsg,
                            ULONG ulMsgMsg,
                            ULONG ulFlags);

ULONG guiMessageBoxMsg(HWND hwndOwner,
                       ULONG ulTitleMsg,
                       PCHAR *pTable,
                       ULONG cTable,
                       ULONG ulMsgMsg,
                       ULONG ulFlags);

ULONG guiAlreadyInstalled(VOID) throw(CancelExcpt);

BOOL guiBeginAddRemove(VOID);

VOID guiPackageSelected(PackageInfo* pPckInfo);

BOOL guiCheckPackages();

PSZ guiEnterVariable(PSZ pszVarName,
                     PSZ pszDescription)
                     throw(CancelExcpt);

LONG guiConfirmDeinstall(HWND hwndOwner,
                         list<PackageInfo*>* pPckInfoList);

BOOL guiDeinstallArchive(list<PackageInfo*>* pPckInfoList,
                         ULONG ulFlags);

VOID guiProductInfo(HWND hwndOwner);

/*******************************************************************
 *                                                                 *
 *  Required GUI callbacks on Install thread (gui.cpp)             *
 *                                                                 *
 ******************************************************************/

BOOL guiStartInstall(void);

void guiUpdatePackage(PackageInfo* pPckInfo, ULONG ulPckThis, ULONG ulPcksTotal);

void guiUpdateFile(WIFileHeader* pwifh, ULONG ulFileThis, ULONG ulFilesTotal);

void guiUpdateBytes(double dBytesDone, double dBytesTotal);

/*
 *@@ FILEEXISTS:
 *      structure passed to guiFileExists
 *      if a file exists and prompts are needed.
 */

typedef struct _FILEEXISTS
{
    CHAR            szFilename[2*CCHMAXPATH];
                                // fully q'd pathname of existing file
    FILESTATUS3     fs3Existing;    // file status of existing file

    WIFileHeader*   pwifh;          // file header in archive
    FDATE           fDateHeader;    // date
    FTIME           fTimeHeader;    // and time of *pwifh

    int             iComp;          // < 0:  existing file is newer
                                    // == 0: existing file is same write date
                                    // > 0:  existing file is older

    // constructor
    _FILEEXISTS()
    {
        memset(this, 0, sizeof(*this));
    }

} FILEEXISTS, *PFILEEXISTS;

int guiFileExists(PFILEEXISTS pfi);

#define ECLS_DOS            1       // OS/2 DOS error
#define ECLS_BACKEND        2       // back-end error
#define ECLS_EXCEPTION      3       // exception occured
#define ECLS_DECOMP         4       // zlib decompression error
#define ECLS_UNKNOWN        5       // unknown error (shouldn't happen)

int guiInstallError(char* pszMessage,
                    int iErrorClass,
                    int iErrorCode,
                    int iErrorRsp);

void guiDoneWithInstall(void);

/*******************************************************************
 *                                                                 *
 *  Required GUI callbacks for database mode (gui.cpp)             *
 *                                                                 *
 ******************************************************************/

BOOL guiBeginDatabaseMode();

// database callback codes (ulReportCode)
#define DBC_NEXTPACKAGE                 1
#define DBC_NEXTFILE                    2

#define DBC_TARGETDIRNOTFOUND           9

#define DBC_FILENOTFOUND                3
#define DBC_EXISTINGFILENEWER           4
#define DBC_EXISTINGFILEOLDER           5
#define DBC_DELETEERROR                 6
#define DBC_DELETEDIRERROR              7
#define DBC_PACKAGEREMOVED              8
#define DBC_CLASSDEREGISTERED           10
#define DBC_DEREGISTERCLASSERROR        11
#define DBC_CLASSUNREPLACED             12
#define DBC_UNREPLACECLASSERROR         13
#define DBC_OBJECTDELETED               14
#define DBC_OBJECTDELETEERROR           15
#define DBC_CFGSYSUNDONE                16
#define DBC_UNDOCFGSYSERROR             17

ULONG guiDatabaseCallback(ULONG ulReportCode,
                          PackageInfo* pPckInfo,
                          WIFileHeader* pHeader,
                          ULONG ulExtra,
                          ULONG ulUser);


