/* $Id: kThreadContainer.cpp,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kThreadContainer - generic thread container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */

/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_BASE


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#else
    #include <malloc.h>
#endif
#include <memory.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kClickDlg.h"
#include "kContainer.h"
#include "kQuerySysState.h"
#include "kThreadRecord.h"
#include "kThreadContainer.h"
#include "kNotebookBase.h"
#include "kTaskMgr.h"
#include "kTaskMgr_defs.h"


/**
 * Updates the content of the container.
 * @returns   success indicator.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
BOOL   kThreadContainer::insertThreads()
{
    PPROCESSDATA    pProcData;
    int             c;

    /*
     * Get process and thread data.
     */
    pProcData = QSGetProcessData(usPid);
    if (pProcData == NULL)
        return FALSE;

    /*
     * Process thread information.
     */
    c = pProcData->pProcRec->cTCB;
    if (c > 0 && pProcData->pProcRec->pThrdRec != NULL)
    {
        kThreadRecord  *    pCurCnrRec, *pCnrRec;
        qsTrec_t *          pThread;
        int                 i;

        /*
         * Allocate records.
         */
        pCurCnrRec = pCnrRec = (kThreadRecord*)allocMiniRec(sizeof(kThreadRecord), c);
        if (pCurCnrRec == NULL)
            return FALSE;

        /*
         * Loop thru the thread data and fill the records.
         */
        pThread = pProcData->pProcRec->pThrdRec;
        for (i = 0; i < c; i++, pCurCnrRec = (kThreadRecord*)pCurCnrRec->getNext(), pThread++)
        {
            //assert(pCurCnrRec != NULL);
            pCurCnrRec->init();
            pCurCnrRec->set(pThread);
        }

        /*
         * Insert the records.
         */
        return insertAtBottom(pCnrRec, c);

    }

    return TRUE;
}


/**
 * Menu is closing. Remove emphasis.
 * @param     usMenuId  Menu id.
 * @param     hwndMnu   Handle to menu window.
 */
VOID kThreadContainer::menuEnd(USHORT usMenuId, HWND hwndMnu)
{
    setRecordEmphasis(pCurRecord, FALSE, CRA_SOURCE);
    hwndMnu = hwndMnu;
    usMenuId = usMenuId;
}


/**
 * Command events.
 * @param     usCmd     Control id which send/posted the message.
 * @param     usSource  Source id.
 * @param     fPointer  Mouse pointer flag.
 */
VOID  kThreadContainer::command(USHORT usCmd, USHORT usSource, BOOL fPointer)
{
    switch (usCmd)
    {
        case IDM_CNR_TRD_DETAILS:
            if (pCurRecord)
            {
                try
                {
                    //new kThreadDetails(pCurRecord->getPid(), hwndCnr)->show();
                }
                catch(kError err)
                {
                    err.logError();
                    err.showError(kTaskMgr::pszErrorTitle);
                }
            }
            break;

        case IDM_CNR_TRD_ALL_REFRESH:
            update();
            break;
    }

    usSource = usSource;
    fPointer = fPointer;
}



/**
 * Constructor.
 * @returns
 * @param     hwndDlg   Handle to dialog window.
 * @param     ulCnrId   ID of the container dialog item in hwndDlg.
 * @param     usPid     Process Indicator for the process we're to get thread information for.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
kThreadContainer::kThreadContainer(HWND hwndDlg, ULONG ulCnrId, USHORT usPid) throw(kError)
    : kDetailCnr(WinWindowFromID(hwndDlg, ulCnrId),
                 0,
                 "Thread Overview",
                 kThreadRecord::cFieldInfo,
                 (PFIELDINFO)&kThreadRecord::aFieldInfo[0]),
    usPid(usPid), pCurRecord(NULL)
{
    /*
     * Create menus.
     */
    pMenuThread = new kMenuBase(IDM_CNR_THREAD, NULLHANDLE, hwndCnr, TRUE);
    pMenuCnrAll = new kMenuBase(IDM_CNR_THREAD_ALL, NULLHANDLE, hwndCnr, TRUE);
}


/**
 * Destructor.
 */
kThreadContainer::~kThreadContainer()
{
    if (pMenuThread != NULL)
        delete pMenuThread;
    if (pMenuCnrAll != NULL)
        delete pMenuCnrAll;
}


/**
 * Displays the popup menu for the container.
 * @param     usId     Container id.
 * @param     pRecord  Pointer to the record which is selected by either the key
 */
VOID kThreadContainer::cnrContextMenu(USHORT usId, PRECORDCORE pRecord)
{
    if (pMenuThread && pMenuCnrAll)
    {
        pCurRecord = (kThreadRecord*)pRecord;
        setRecordEmphasis(pCurRecord, TRUE, CRA_SOURCE);
        if (pRecord != NULL)
            pMenuThread->popup();
        else
            pMenuCnrAll->popup();
    }
    usId = usId;
}


/**
 * Enter or double click on record in the container.
 * This action will bring up the detail dialog for the record - Not Implemented.
 */
VOID kThreadContainer::cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey)
{
    if (pRecord != NULL)
    {
        pCurRecord = (kThreadRecord*)pRecord;
        /*
         todo...
         */
    }
    usId = usId;
    fKey = fKey;
    hwndCnr = hwndCnr;
}



/**
 * Updates the contents of the container.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
VOID  kThreadContainer::update()
{
    /*
     * Delete all records in the container!
     */
    removeAllRecords();

    /*
     * Insert records
     */
    insertThreads();
}

