/* $Id: kSFNPage.cpp,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kSFNPage (kTaskMgr) - System file number overview page.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */


/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_BASE


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#else
    #include <malloc.h>
#endif
#include <memory.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kContainer.h"
#include "kNotebookBase.h"
#include "kNotebookPageBase.h"

#include "kQuerySysState.h"
#include "kDetailBase.h"
#include "kSFNRecord.h"
#include "kSFNContainer.h"
#include "kObjectRecord.h"
#include "kObjectContainer.h"
#include "kSFNPage.h"
#include "kTaskMgr_defs.h"
#include "kTaskMgr.h"


/**
 * Forwards to the container.
 * @param     usId     Container id.
 * @param     pRecord  Pointer to the record which is selected by either the key
 */
VOID kSFNPage::cnrContextMenu(USHORT usId, PRECORDCORE pRecord)
{
    pContainer->cnrContextMenu(usId, pRecord);
}


/**
 * Forwards to the container.
 */
VOID kSFNPage::cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey)
{
    pContainer->cnrEnter(usId, hwndCnr, pRecord, fKey);
}



/**
 * Create an global SFN page.
 * @param     pNtbk     Pointer to notebook object.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark    Throws kError on error.
 */
kSFNPage::kSFNPage(kNotebookBase *pNtbk) throw (kError)
    : kNotebookPageBase(DL_KSFNPAGE, NULLHANDLE, pNtbk),
    pContainer(NULL)
{
    /*
     * Container border size
     */
    ptlBorder.x = 5;
    ptlBorder.y = 4;
    WinMapDlgPoints(hwnd, &ptlBorder, 1, TRUE);

    /*
     * Create detail container
     */
    pContainer = new kSFNContainer(hwnd, KSFNPG_CNR);
    pContainer->update();
}



/**
 * Create an processes SFN/JFN page.
 * @param     pNtbk     Pointer to notebook object.
 * @param     usPid     Process identificator of the process we're to show SFN/JFNs for.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark    Throws kError on error.
 */
kSFNPage::kSFNPage(kNotebookBase *pNtbk, USHORT usPid) throw (kError)
    : kNotebookPageBase(DL_KSFNPAGE, NULLHANDLE, pNtbk),
    pContainer(NULL)
{
    /*
     * Container border size
     */
    ptlBorder.x = 5;
    ptlBorder.y = 4;
    WinMapDlgPoints(hwnd, &ptlBorder, 1, TRUE);

    /*
     * Create detail container
     */
    pContainer = new kSFNContainer(hwnd, KSFNPG_CNR, usPid);
    pContainer->update();
}



/**
 * Desctructor stub.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark
 */
kSFNPage::~kSFNPage()
{
    if (pContainer != NULL)
        delete pContainer;
    pContainer = NULL;
}


/**
 * Move and size the container and dialog.
 * @param     prctlPage  New size of dialog.
 */
VOID  kSFNPage::ntfySized(LONG cx, LONG cy)
{
    /*
     * Resize the dialog
     */
    resizeAndMove(
        0,
        0,
        cx,
        cy);

    /*
     * Resize the container.
     */
    pContainer->resizeAndMove(
        ptlBorder.x,
        ptlBorder.y,
        cx - ptlBorder.x*2,
        cy - ptlBorder.y*2
        );
}

