/* $Id: kSFNContainer.h,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kSFNContainer (kTaskMgr) - generic SystemFileNumber (SFN) container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */
#ifndef _kSFNContainer_h_
#define _kSFNContainer_h_




/**
 * Generic object container.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kSFNContainer : public kDetailCnr
{
private:
    /** @cat private data */
    USHORT          usPid;              /* Process identifier of the process we're displaying SFNs for. */
                                        /* Special value 0xFFFF is used to show SFN for all processes.  */
    kSFNRecord *    pCurRecord;         /* Pointer to the current record actual for menu action. */
    kMenuBase *     pMenuCnrAll;        /* Entire container menu. */
    USHORT          usSortId;           /* MenuId of the currently selecting sorting option. */

    /** @cat private methods */
    BOOL    insertSFNsPid();
    BOOL    insertSFNsAll();

    /** @cat private events */
    VOID    menuEnd(USHORT usMenuId, HWND hwndMnu); //WM_MENUEND
    VOID    command(USHORT usCmd, USHORT usSource, BOOL fPointer); //WM_COMMAND

    SHORT   sortCallBack(kCnrMiniRecord *pRecord1, kCnrMiniRecord *pRecord2);

public:
    /**
     * usPid = 0xFFFF: View all SFNs.
     * usPid != 0:     View only SFNs for the given process.
     */
    kSFNContainer(HWND hwndDlg, ULONG ulCnrId, USHORT usPid = 0xFFFF) throw (kError);
    ~kSFNContainer();

    /** @cat events which sorrily have to be invoked from the outside... */
    VOID    cnrContextMenu(USHORT usId, PRECORDCORE pRecord);
    VOID    cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey);

    VOID    update();
};


#endif


