/* $Id: kProcessDetailsPage.cpp,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * Process Detail Page.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */
/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WIN


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#endif
#include <stdio.h>
#include <string.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kContainer.h"
#include "kNotebookBase.h"
#include "kNotebookPageBase.h"

#include "kQuerySysState.h"
#include "kDetailBase.h"

#include "kObjectRecord.h"
#include "kProcessRecord.h"
#include "kProcessContainer.h"
#include "kThreadRecord.h"
#include "kThreadContainer.h"
#include "kProcessDetailsPage.h"
#include "kProcessDetails.h"
#include "kTaskMgr_Defs.h"
#include "kTaskMgr.h"



VOID  kProcessDetailsPage::sysCommand(USHORT usCmd, USHORT usSource, BOOL fPointer) //WM_SYSCOMMAND
{
    ASSERT(FALSE);
    kDlgBase::sysCommand(usCmd, usSource, fPointer);
}

VOID  kProcessDetailsPage::close() //WM_CLOSE
{
    ASSERT(FALSE);
    WinDefDlgProc(hwnd, WM_CLOSE, 0,0);
}


/**
 * Displays the popup menu for the container.
 * @param     usId     Container id.
 * @param     pRecord  Pointer to the record which is selected by either the key
 */
VOID kProcessDetailsPage::cnrContextMenu(USHORT usId, PRECORDCORE pRecord)
{
    if (usId == KPROCDTLPG_CNR_CHILDREN)
        pCnrChildren->cnrContextMenu(usId, pRecord);
    else
        pCnrThreads->cnrContextMenu(usId, pRecord);

}


/**
 * Enter or double click on record in the container.
 * This action will bring up the detail dialog for the record.
 */
VOID kProcessDetailsPage::cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey)
{
    if (usId == KPROCDTLPG_CNR_CHILDREN)
        pCnrChildren->cnrEnter(usId, hwndCnr, pRecord, fKey);
    else
        pCnrThreads->cnrEnter(usId, hwndCnr, pRecord, fKey);
}


/**
 * WM_DESTROY.
 * We'll simply delete this object.
 */
VOID  kProcessDetailsPage::destroy()
{
    delete this;
}


/**
 * Module detail dialog.
 * @param     pNtbk     Pointer to notebook.
 * @param     usPid     Process ID of the process to show details for.
 */
kProcessDetailsPage::kProcessDetailsPage(kNotebookBase *pNtbk, USHORT usPid)
: kNotebookPageBase(DL_KPROCESSDETAILSPAGE, NULLHANDLE, pNtbk),
    pCnrThreads(NULL), pCnrChildren(NULL), usPid(usPid)
{
    PPROCESSDATA pProcData;

    /*
     *  Get process data.
     */
    pProcData = QSGetProcessData(usPid);
    if (pProcData == NULL)
        throw(kError(ERROR_INVALID_PARAMETER, kError::dos));


    /*
     * Create the two containers
     */
    pCnrThreads     = new kThreadContainer(hwnd, KPROCDTLPG_CNR_THREADS, usPid);
    pCnrChildren    = new kProcessContainer(hwnd, KPROCDTLPG_CNR_CHILDREN, usPid);

    /*
     * Set dialog content
     */
    update();

}


/**
 * Destructor stub.
 */
kProcessDetailsPage::~kProcessDetailsPage()
{
    if (pCnrThreads)
        delete pCnrThreads;
    if (pCnrChildren)
        delete pCnrChildren;
}



/**
 * Updates the content of this notebook page.
 * @returns   Successindicator.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark
 */
BOOL kProcessDetailsPage::update()
{
    CHAR            szBuffer[512];
    PPROCESSDATA    pProcData;
    qsLrec_t *      pMteRec;
    PSZ             psz;

    /*
     *  Get process data.
     */
    pProcData = QSGetProcessData(usPid);
    if (pProcData == NULL)
        throw(kError(ERROR_INVALID_PARAMETER, kError::dos));

    /*
     * Find hMte record
     */
    pMteRec = QSGetMteData(pProcData->pProcRec->hMte);
    if (pMteRec == NULL)
        throw(kError(ERROR_INVALID_PARAMETER, kError::dos));

    /*
     * Set Dialog itmes.
     */
    setDlgItemText(KPROCDTLPG_TXT_NAME        , "%s",       pMteRec->pName);
    setDlgItemText(KPROCDTLPG_TXT_PID         , "0x%04x",   pProcData->pProcRec->pid);
    setDlgItemText(KPROCDTLPG_TXT_PPID        , "0x%04x",   pProcData->pProcRec->ppid);
    setDlgItemText(KPROCDTLPG_TXT_HMTE        , "0x%04x",   pProcData->pProcRec->hMte);
    switch (pProcData->pProcRec->type)
    {
        case 0: psz = "FullScr (%d)"; break;
        case 1: psz = "VDM (%d)"; break;
        case 2: psz = "VIO (%d)"; break;
        case 3: psz = "PM (%d)"; break;
        case 4: psz = "Detach (%d)"; break;
        default:psz = "unknown (%d)"; break;

    }
    setDlgItemText(KPROCDTLPG_TXT_TYPE        , psz,        pProcData->pProcRec->type);
    psz = szBuffer;
    psz[0] = '\0';
    if (pProcData->pProcRec->stat & 0x01)
        strcat(psz, "ExitList ");
    if (pProcData->pProcRec->stat & 0x02)
        strcat(psz, "ExitingThread1 ");
    if (pProcData->pProcRec->stat & 0x04)
        strcat(psz, "ExitingAll ");
    if (pProcData->pProcRec->stat & 0x10)
        strcat(psz, "SyncParent ");
    if (pProcData->pProcRec->stat & 0x20)
        strcat(psz, "WaitParent ");
    if (pProcData->pProcRec->stat & 0x40)
        strcat(psz, "Dying ");
    if (pProcData->pProcRec->stat & 0x80)
        strcat(psz, "Embryonic ");
    if (pProcData->pProcRec->stat == 0)
        strcat(psz, "Normal ");
    setDlgItemText(KPROCDTLPG_TXT_STATUS      , "%s(%#0x)",  psz, pProcData->pProcRec->stat);
    setDlgItemText(KPROCDTLPG_TXT_CTHREADS    , "%d",       pProcData->pProcRec->cTCB);
    setDlgItemText(KPROCDTLPG_TXT_C32SEMAPHORS, "%d",       pProcData->pProcRec->c32PSem);
    setDlgItemText(KPROCDTLPG_TXT_CSHAREDMEM  , "%d",       pProcData->pProcRec->cShrMem);
    setDlgItemText(KPROCDTLPG_TXT_CFILES      , "%d",       pProcData->pProcRec->cFH);
    setDlgItemText(KPROCDTLPG_TXT_CDLLS       , "%d",       pProcData->pProcRec->cLib);
    setDlgItemText(KPROCDTLPG_TXT_SCREENGRPID , "0x%04x",   pProcData->pProcRec->sgid);
    setDlgItemText(KPROCDTLPG_TXT_CCHILDREN   , "%d",       pCnrChildren->getCountOfRecords());

    /*
     * Fill the containers.
     */
    pCnrThreads->update();
    pCnrChildren->update();


    return TRUE;
}
