/* $Id: kProcessContainer.h,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kProcessContainer - General process container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */

#ifndef _kProcessContainer_h_
#define _kProcessContainer_h_




/**
 * Generic module container.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kProcessContainer : public kDetailCnr
{
private:
    /** @cat private data */
    USHORT              usPid;          /* 0xFFFF: all, != 0xFFFF: children of this pid. */
    kMenuBase *         pMenuProcess;   /* Pointer to record menu. */
    kMenuBase *         pMenuCnrAll;    /* Pointer to container menu. */
    kProcessRecord *    pCurRecord;     /* Pointer to the current record actual for menu action. */
    USHORT              usSortId;       /* MenuId of the currently selected sorting menu choice. */

    /** @cat private methods */
    BOOL    kUpdateAllProcesses();
    BOOL    kUpdateChildProcesses();

    /** @cat private events */
    VOID    menuEnd(USHORT usMenuId, HWND hwndMnu); //WM_MENUEND
    VOID    command(USHORT usCmd, USHORT usSource, BOOL fPointer); //WM_COMMAND

    SHORT   sortCallBack(kCnrMiniRecord *pRecord1, kCnrMiniRecord *pRecord2);


public:
    /**
     * usPid = 0xFFFF: View all processes.
     * usPid != 0:     View all children of the given process id.
     */
    kProcessContainer(HWND hwndDlg, ULONG ulCnrId, USHORT usPid = 0xFFFF) throw (kError);
    ~kProcessContainer();

    /** @cat events which sorrily have to be invoked from the outside... */
    VOID  cnrContextMenu(USHORT usId, PRECORDCORE pRecord);
    VOID  cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey);

    VOID  update();
};


#endif

