/* $Id: kObjectContainer.h,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kObjectContainer - generic object container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */
#ifndef _kObjectContainer_h_
#define _kObjectContainer_h_




/**
 * Generic object container.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kObjectContainer : public kDetailCnr
{
private:
    /** @cat private data */
    USHORT          hMTE;               /* Module handle. */
    kObjectRecord * pCurRecord;         /* Pointer to the current record actual for menu action. */

    /** @cat private methods */
    BOOL    insertObjects();

    /** @cat private events */
    VOID    menuEnd(USHORT usMenuId, HWND hwndMnu); //WM_MENUEND
    VOID    command(USHORT usCmd, USHORT usSource, BOOL fPointer); //WM_COMMAND


public:
    kObjectContainer(HWND hwndDlg, ULONG ulCnrId, USHORT hMTE) throw (kError);
    ~kObjectContainer();

    /** @cat events which sorrily have to be invoked from the outside... */
    VOID    cnrContextMenu(USHORT usId, PRECORDCORE pRecord);
    VOID    cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey);

    VOID    update();
};


#endif


