/* $Id: kMenuBase.h,v 1.1 2000/04/29 19:06:34 stknut Exp $
 *
 * kMenu (kClassLib) - Menu encapsulation.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */

#ifndef _kMenuBase_h_
#define _kMenuBase_h_



/**
 * Base class for menus.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kMenuBase
{
protected:
    HWND    hwndMenu;
    HWND    hwndOwner;

public:
    kMenuBase(ULONG ulResId, HMODULE hmodRes, HWND hwnd, BOOL fPopup = TRUE);
    ~kMenuBase();

    /** @cat operations on menus */
    BOOL checkMenuItem(USHORT id, BOOL fcheck);
    BOOL isMenuItemChecked(USHORT id);
    BOOL enableMenuItem(USHORT id, BOOL fEnable);
    BOOL isMenuItemEnabled(USHORT id);
    BOOL setMenuItemText(USHORT id, PSZ psz);
    BOOL isMenuItemValid(USHORT id);

    /** @cat usage */
    BOOL popup(LONG  idItem = 0,
               ULONG fs = (PU_HCONSTRAIN | PU_VCONSTRAIN |
                           PU_KEYBOARD | PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2),
               HWND hwndParent = NULLHANDLE,
               HWND hwndOwner = NULLHANDLE);
};


#endif

