/* $Id: kDetailBase.cpp,v 1.1 2000/04/29 19:06:34 stknut Exp $
 *
 * Implementation of the detail dialog base class, kDetailBase.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 * Project Odin Software License can be found in LICENSE.TXT
 *
 */


/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WIN


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#endif
#include <stdio.h>
#include <string.h>
#include <process.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"

#include "kDetailBase.h"

#pragma pack(1)
typedef struct _SWCNTRL2          /* swctl */
{
 HWND     hwnd;
 HWND     hwndIcon;
 HPROGRAM hprog;
 PID      idProcess;
 ULONG    idSession;
 ULONG    uchVisibility;
 ULONG    fbJump;
 CHAR     szSwtitle[MAXNAMEL+4];
 ULONG    bProgType;
} SWCNTRL2;

typedef SWCNTRL2 *PSWCNTRL2;

typedef struct _SWENTRY2          /* swent */
{
 HSWITCH hswitch;
 SWCNTRL2 swctl;
} SWENTRY2;
typedef SWENTRY2 *PSWENTRY2;

typedef struct _SWBLOCK2          /* swblk */
{
 ULONG    cswentry;
 SWENTRY2 aswentry[1];
} SWBLOCK2;
typedef SWBLOCK2 *PSWBLOCK2;



/**
 * Constructor - adds the dialog to the switch list.
 * @param     hwnd      Handle to the dialog window.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
kDetailBase::kDetailBase(HWND hwnd)
{
    //HSWITCH     hswMain;                /* Handle to main windows switch entry. */

    /*
     *  Add to tasklist
     *      Remove switch entry for this dialog window if it exists.
     *      Get main window sitch handle.
     *      Create switch entry for this dialog window.
     */
    hsw = WinQuerySwitchHandle(hwnd, 0);
    #if 0
    if (hsw != NULLHANDLE)
        WinRemoveSwitchEntry(hsw);
    hsw = NULLHANDLE;

    hswMain = WinQuerySwitchHandle(NULLHANDLE, getpid());
    if (hswMain != NULL)
    {
        SWCNTRL swctl = {0};

        WinQuerySwitchEntry(hswMain, &swctl);
        swctl.hwnd = hwnd;
        swctl.hprog = hswMain;
        strcpy(swctl.szSwtitle, "summy");
        hsw = WinAddSwitchEntry(&swctl);

        SWBLOCK2    aswb[40] = {0};
        WinQuerySwitchList(WinQueryAnchorBlock(hwnd), (PSWBLOCK)(&aswb[0]), sizeof(aswb));
    }
    #endif
}

