/* REXX installation script for Systray/2
 * Copyright (C) 2000 by Ilfat Kutdusov, Russian Team OS/2
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

installdir = directory()"\"
installlog = installdir"install.log"

if GetYesNo( "Install Systray/2 in" installdir ) == 0 then
   exit

/*------------------------------------------------------------------
 * Create folder
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPFolder","Systray/2","<WP_DESKTOP>",,
                      "OBJECTID=<WPSystrayFolder>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log "Systray/2 folder successfully created on desktop..."
else       call log "ERROR: Systray/2 folder creating failed!"

rc = SysCreateObject( "WPFolder","Development","<WPSystrayFolder>",,
                      "OBJECTID=<WPSystrayDev>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log "Systray/2 Dev. folder successfully created on desktop..."
else       call log "ERROR: Systray/2 Dev. folder creating failed!"

/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", "Systray/2", "<WPSystrayFolder>",,
                      "OBJECTID=<WPSystray>;EXENAME="installdir"systray2.exe;STARTUPDIR="installdir";REPLACE" )
if rc then       call log "Systray/2 object successfully created..."
  else           call log "ERROR: Systray/2 object creating failed!"


rc = SysCreateObject( "WPProgram", "Readme", "<WPSystrayFolder>",,
                      "OBJECTID=<SystrayReadmeen>;EXENAME=e.exe;PARAMETERS="installdir"\readme.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Readme object successfully created..."
   else       call log "ERROR: Readme object creating failed!"


rc = SysCreateObject( "WPProgram", "History Changes", "<WPSystrayFolder>",,
                      "OBJECTID=<SystrayHistory>;EXENAME=e.exe;PARAMETERS="installdir"\changes.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "History Changes object successfully created..."
      else    call log "ERROR: History Changes object creating failed!"

rc = SysCreateObject( "WPProgram", "Plugin reference", "<WPSystrayDev>",,
                      "OBJECTID=<SystrayPlugin>;EXENAME=e.exe;PARAMETERS="installdir"\development\plugins.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Plugin reference object successfully created..."
      else    call log "ERROR: Plugin reference object creating failed!"

rc = SysCreateObject( "WPProgram", "Tray API documentation", "<WPSystrayDev>",,
                      "OBJECTID=<SystrayAPIdoc>;EXENAME=e.exe;PARAMETERS="installdir"\development\trayapi.txt;STARTUPDIR="installdir";REPLACE" )
if rc then    call log "Tray API documentation object successfully created..."
      else    call log "ERROR: Tray API documentation object creating failed!"

rc = SysCreateObject( "WPProgram", "Tray API example", "<WPSystrayDev>",,
                      "OBJECTID=<TrayAPIex>;EXENAME="installdir"\development\bin\trayex.exe;REPLACE" )
if rc then    call log "Tray API example object successfully created..."
      else    call log "ERROR: Tray API example object creating failed!"



rc = SysCreateObject( "WPShadow", "Systray/2", "<WP_START>",,
                      "SHADOWID=<WPSystray>",,
                      "REPLACE" )

if rc then
   call log "Systray/2 object shadow added in Startup folder..."
else 
   call log "Systray/2 object shadow adding in Startup folder failed!"

/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/




Exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "INSTALL: "msg

return
