(****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                         System TRAY sample source                        *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************)

  program TrayEx;

  {&PMTYPE PM}
  {&Use32+}

  Uses Os2Def, Os2Base, Os2PmApi, TrayApi;

  {$R trayex.res}

  Const
        ID_RESOURCE = 100;

  Function ClientWndProc( wnd : HWND  ; msg : ULONG ;
                          mp1 : MPARAM; mp2 : MPARAM): MRESULT; cdecl;
  Var
    rcl          : RECTL;
    PS           : HPS;
  Const lColorB  : LONG  = CLR_CYAN;
        lColorF  : LONG  = CLR_DARKBLUE;
        szMsg    : PChar = 'Hello, world!';

  Begin
    Case msg Of
      WM_CREATE:
        Begin
        InitializeTrayApi(wnd);
        End;
      WM_DDE_INITIATEACK:
        Begin
        AnswerTrayApiDdeAck(mp1);
        AddTrayIcon(wnd,0);
        End;
      WM_DESTROY:
        Begin
        DeleteTrayIcon(wnd);
        End;
      WM_PAINT:
        Begin

        WinQueryWindowRect(wnd, rcl);
        PS := WinBeginPaint(Wnd, 0, @Rcl);
        WinFillRect(PS, Rcl, lColorB);
        WinDrawText(PS, -1, szMsg, rcl, lColorF, lColorB,
                    DT_CENTER or DT_VCENTER);
        WinEndPaint(PS);

        ClientWndProc := 0; exit;
        End;
    End;
    ClientWndProc := WinDefWindowProc (wnd, msg, mp1, mp2);
  End;

  Var
    hwndFrame  : HWND;
    hwndClient : HWND;
    _hmq       : HMQ;
    _qmsg      : QMSG;
    _hab       : HAB;

  Const flFrameFlags : ULONG =
                        FCF_TITLEBAR      Or  (*  Title bar              *)
                        FCF_SIZEBORDER    Or  (*  Size Border            *)
                        FCF_MINMAX        Or  (*  Min & Max Buttons      *)
                        FCF_SYSMENU       Or  (*  System Menu            *)
                        FCF_SHELLPOSITION Or  (*  System size & position *)
                        FCF_TASKLIST      Or  (*  Add name to task list  *)
                        FCF_ICON          ;   (*  Iconize                *)

  Begin
    _hab := WinInitialize(0);
    _hmq := WinCreateMsgQueue(_hab, 0);
    WinRegisterClass(
       _hab,                   (* Anchor block handle            *)
       'TrayExClient',         (* Name of class being registered *)
       ClientWndProc,          (* Window procedure for class     *)
       CS_SIZEREDRAW Or        (* Class style                    *)
       CS_HITTEST,             (* Class style                    *)
       0);                     (* Extra bytes to reserve         *)

    hwndFrame := WinCreateStdWindow(
                 HWND_DESKTOP,       (* Parent is desktop window        *)
                 WS_VISIBLE,         (* Make frame window visible       *)
                 flFrameFlags,       (* Frame controls                  *)
                 'TrayExClient',     (* Window class for client         *)
                 'Tray Example',     (* Window title                    *)
                 WS_VISIBLE,         (* Make client window visible      *)
                 0,                  (* Resources in application module *)
                 ID_RESOURCE,        (* Resource identifier             *)
                 nil);               (* Pointer to client window handle *)

    While WinGetMsg(_hab, _qmsg, 0, 0, 0) Do
          WinDispatchMsg(_hab, _qmsg);
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(_hmq);
    WinTerminate(_hab);
    Halt(0);
  End.



