/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                         System TRAY sample source                        *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

#define INCL_WINSTDDRAG
#define INCL_GPI
#include "trayapi.h" /* API library */

MRESULT EXPENTRY windowproc(HWND, ULONG, MPARAM, MPARAM) ;

HAB  hab ;
HWND hwndFrame, hwndClient ;
HPOINTER hIcon[5] ;

int main()
{
ULONG fl = FCF_SIZEBORDER | FCF_TASKLIST | FCF_ICON | FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX | FCF_SHELLPOSITION;
static CHAR  szClass [] = "Tray Example" ;
HMQ          hmq ;
QMSG         qmsg ;
LONG i;

hab = WinInitialize (0) ;
hmq = WinCreateMsgQueue (hab, 0) ;

WinRegisterClass (hab, (PSZ)szClass, (PFNWP)windowproc, CS_SIZEREDRAW, 0) ;

hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                &fl, (PSZ)szClass, (PSZ)szClass,
                                0L, NULL, 100, &hwndClient) ;

for(i=100;i<=104;i++)
hIcon[i-100] = WinLoadPointer(HWND_DESKTOP,NULLHANDLE,i) ;

while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
       WinDispatchMsg (hab, &qmsg) ;

WinDestroyWindow (hwndFrame) ;
WinDestroyMsgQueue (hmq) ;
WinTerminate (hab) ;
return 0 ;

}

MRESULT EXPENTRY windowproc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
HPS          hps ;
RECTL        rcl ;
static SHORT a = 0 ;
static CHAR  szTextMessage[]="Hello, world!" ; /* (c) 1978 K. & R. */

switch(msg)
{
/* control tray icon specific messages */
case WM_TIMER:
a ++ ;
a %= 5 ;
WinSendMsg(hwndFrame,WM_SETICON,(MPARAM)hIcon[a],NULL) ;
ChangeTrayIcon(hwnd,NULLHANDLE) ;
break ;
case WM_BUTTON1CLICK | 0x2000:
case WM_BUTTON2CLICK | 0x2000:
/* activate frame window */
WinSetWindowPos(hwndFrame,HWND_TOP,0,0,0,0,SWP_ACTIVATE | SWP_SHOW | SWP_ZORDER | SWP_RESTORE) ;
break;
case WM_CREATE:
/* initialize tray api */
InitializeTrayApi(hwnd) ;
break;

case WM_DDE_INITIATEACK:
/* aswer dde server */
AnswerTrayApiDdeAck(mp1) ;
AddTrayIcon(hwnd,WinSendMsg(hwndFrame,WM_QUERYICON,NULL,NULL)) ;
WinStartTimer(hab,hwnd,1,500) ;

return (MRESULT)0L ;

case WM_PAINT:
hps = WinBeginPaint(hwnd,NULL,NULL) ;

WinQueryWindowRect(hwnd, &rcl) ;

WinFillRect(hps, &rcl, CLR_CYAN) ;

WinDrawText(hps, -1, szTextMessage, &rcl, CLR_DARKBLUE, CLR_CYAN,
	    DT_CENTER | DT_VCENTER) ;

WinEndPaint(hps) ;
break;

case WM_DESTROY:
/* delete application icon from system tray */
return (MRESULT)DeleteTrayIcon(hwnd) ;
}

return WinDefWindowProc(hwnd, msg, mp1, mp2) ;
}