/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* uptime monitor */

#include "..\systray.h"
#include <dos.h>
#include <ctype.h>
#include "plugin.h"

char    szUptimeClass[] = "SystrayUptimeClass";

typedef struct _UNITUptime {
UNIT    u;
BYTE    bZero;
UPPR    uppr;
} UNITUptime;

typedef UNITUptime *PUNITUptime;

extern HAB     habMain;
extern HMODULE hmod;

void getuptime(char *buf)
{
ULONG ul,h,m,s;
DosQuerySysInfo( QSV_MS_COUNT, QSV_MS_COUNT, &ul, sizeof ( ULONG ) );
ul/=1000L;s=ul%60L;ul/=60L;m=ul%60L;ul/=60L;h=ul%24L;ul/=24L;
sprintf(buf,"%ldD %02ld:%02ld:%02ld",ul,h,m,s);
}

MRESULT EXPENTRY uptimewndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
PUNITUptime punit;
HPS hps;
RECTL rcl;
char buf[80];
punit = (PUNITUptime)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CREATE:
punit = (PUNITUptime)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
if(!punit->bZero)
{
punit->bZero = 1;
punit->uppr.fgColor = 0L;
punit->uppr.bgColor = 0x00CCCCCCL;
strcpy(punit->uppr.szFont,"8.Helv");
}
SetUnitPresParam(hwnd,&punit->uppr);
WinQueryWindowRect(hwnd, &rcl);
sprintf(punit->u.szBubble,"System Uptime");
WinStartTimer(habMain, hwnd, 1, 1000);
/* set bubble help buffer pointer */
WinSendMsg(WinQueryWindow(hwnd,QW_PARENT),WM_USER,(MPARAM)hwnd,
           (MPARAM)punit->u.szBubble);
break;
case WM_TIMER:
GetUnitPresParam(hwnd, &punit->uppr);
getuptime(buf);
hps = WinGetPS(hwnd);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, NULLHANDLE, buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinReleasePS(hps);
break;
case WM_SIZE:
break;
case WM_PAINT:
GetUnitPresParam(hwnd, &punit->uppr);
getuptime(buf);
hps = WinBeginPaint(hwnd,NULL,NULL);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, NULLHANDLE, buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinEndPaint(hps);
return (MRESULT) NULL;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 100:
/* no configuration at this time */
break;
}
return (MRESULT) NULL;
case WM_DESTROY:
DosFreeMem(punit); /* free unit memory */
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

void uptimeregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szUptimeClass);
pwc->ulCfgSize = sizeof(UNITUptime);
pwc->ulSafeAlloc = sizeof(UNITUptime);
pwc->bInitalUnitWidthPercent = 10;
WinRegisterClass(habMain,(PSZ)szUptimeClass,(PFNWP)uptimewndproc,CS_SIZEREDRAW,4L);
}
