/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* Tray Server/Display */

/* See TRAYAPI.TXT for details */

#include "..\systray.h"
#include <dos.h>
#include <ctype.h>
#include "plugin.h"

extern HAB     habMain;
extern HMODULE hmod;

char    szTrayClass[] = "SysTrayClass";
char    szTrayServerClass[] = "SystrayServer";

HWND    hwndTraySrv=NULL,hwndtsc,hwndMe;

#define WM_TMUPDATELIST WM_USER
#define WM_TMADDME      WM_USER+1
#define WM_TMDELETEME   WM_USER+2
#define WM_TMICON       WM_USER+3

struct  _TRAYLIST {
HWND            hwnd;
HPOINTER        hptr;
} TrayList[1024];

USHORT  usTrayItems=0;

MRESULT EXPENTRY systraysrvproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
HPS hps;
USHORT i;
CONVCONTEXT cvc={sizeof(CONVCONTEXT),0L,0L,437L,0L,0L};
switch(msg)
{
case WM_DDE_INITIATE:
WinDdeRespond((HWND)mp1,hwnd,"SystrayServer","TRAY",&cvc);
return (MRESULT)0L;
case WM_TMADDME:
TrayList[usTrayItems].hwnd=(HWND)mp1;
TrayList[usTrayItems].hptr=(HPOINTER)WinSendMsg(WinQueryWindow((HWND)mp1,QW_PARENT),WM_QUERYICON,NULL,NULL);
usTrayItems++;
WinPostMsg(hwndMe,WM_TMUPDATELIST,NULL,NULL);
break;
case WM_TMDELETEME:
for(i=0;i<usTrayItems;i++)
{
if(TrayList[i].hwnd==(HWND)mp1)
{
memcpy(&TrayList[i],&TrayList[i+1],(usTrayItems-i)*8L);
usTrayItems--;
WinPostMsg(hwndMe,WM_TMUPDATELIST,NULL,NULL);
break;
}
}
break;
case WM_TMICON:
for(i=0;i<usTrayItems;i++)
{
if(TrayList[i].hwnd==(HWND)mp1)
{
TrayList[i].hptr=(HPOINTER)WinSendMsg(WinQueryWindow((HWND)mp1,QW_PARENT),WM_QUERYICON,NULL,NULL);
WinPostMsg(hwndMe,WM_TMUPDATELIST,NULL,NULL);
break;
}
}
break;
case WM_PAINT:
hps=WinBeginPaint(hwnd,NULL,NULL);
GpiErase(hps);
WinEndPaint(hps);
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

MRESULT EXPENTRY systraywndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
ULONG ulFrame=NULL;
HPS hps;
POINTL ptl;
RECTL rcl;
USHORT i;
switch(msg)
{
case WM_BUTTON1CLICK:
case WM_BUTTON2CLICK:
case WM_BUTTON1DBLCLK:
case WM_BUTTON2DBLCLK:
case WM_BEGINSELECT:
case WM_BEGINDRAG:
case WM_ENDSELECT:
case WM_ENDDRAG:
case WM_MOUSEMOVE:
case WM_CONTEXTMENU:
WinQueryPointerPos(HWND_DESKTOP, &ptl);
WinMapWindowPoints(HWND_DESKTOP,hwnd,&ptl,1);
WinQueryWindowRect(hwnd, &rcl);
if(ptl.x<2)break;
if((ptl.x-2)/(rcl.yTop-4)>=usTrayItems)break;
return (MRESULT) WinSendMsg(TrayList[(ptl.x-2)/(rcl.yTop-4)].hwnd,msg|0x2000,mp1,mp2);
case WM_CREATE:
if(hwndTraySrv)
{
DosFreeMem((PVOID)mp1);
WinDestroyWindow(hwnd);
return (MRESULT)0L;
}
WinSetWindowULong(hwnd,0L,(ULONG)mp1);
hwndMe=hwnd;
hwndTraySrv=WinCreateStdWindow(HWND_DESKTOP,0,&ulFrame,szTrayServerClass,
                               "SystrayServer",0,NULLHANDLE,1,&hwndtsc);
WinSetWindowPos(hwndTraySrv,HWND_TOP,0,0,16,16,SWP_HIDE);
break;
case WM_TMUPDATELIST:
hps = WinGetPS(hwnd);
WinQueryWindowRect(hwnd, &rcl);
WinFillRect(hps, &rcl, CLR_PALEGRAY);
for(i=0;i<usTrayItems;i++)
DrawPointer(hps,1+i*(rcl.yTop-4),3,rcl.yTop-7,rcl.yTop-7,
            TrayList[i].hptr,CLR_PALEGRAY);
WinDrawBorder(hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x800L);
WinReleasePS(hps);
break;
case WM_PAINT:
hps = WinBeginPaint(hwnd,NULL,NULL);
WinQueryWindowRect(hwnd, &rcl);
WinFillRect(hps, &rcl, SYSCLR_BUTTONMIDDLE);
for(i=0;i<usTrayItems;i++)
DrawPointer(hps,1+i*(rcl.yTop-4),3,rcl.yTop-7,rcl.yTop-7,
	     TrayList[i].hptr,SYSCLR_BUTTONMIDDLE);
WinDrawBorder(hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x800L);
WinEndPaint(hps);
break;
case WM_DESTROY:
DosFreeMem((PVOID)WinQueryWindowULong(hwnd,0L));
WinDestroyWindow(hwndTraySrv);
hwndTraySrv=0;
break;
}

return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

void systrayregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szTrayClass);
pwc->ulCfgSize = sizeof(UNIT);
pwc->ulSafeAlloc = sizeof(UNIT);
pwc->bInitalUnitWidthPercent = 15;
WinRegisterClass(habMain,(PSZ)szTrayClass,(PFNWP)systraywndproc,CS_SIZEREDRAW,8L);
WinRegisterClass(habMain,(PSZ)szTrayServerClass,(PFNWP)systraysrvproc,CS_SIZEREDRAW,0L);
}
