/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* Tool bar */

#include "..\systray.h"
#include "plugin.h"

extern HAB     habMain;
extern HMODULE hmod;

char    szToolbarClass[] = "SystrayToolbarClass";

typedef struct _TBARBUT {
CHAR     szPath[150];
CHAR     szDir[100];
CHAR     szArg[80];
HPOINTER hIcon;
HWND     hwnd;
//CHAR    szText[32];
} TBARBUT;

typedef struct _UNITTOOLBAR {
UNIT    unit;
BYTE    bZero;
USHORT  usButtons;
TBARBUT tb[1];
} UNITTOOLBAR;

typedef UNITTOOLBAR *PUNITTOOLBAR;


MRESULT  buttoncontrolmsg(MPARAM mp1,MPARAM mp2,PUNITTOOLBAR punit)
{
PUSERBUTTON pubWork;
USHORT   usButton;
RECTL    rcl;

switch (SHORT2FROMMP(mp1))
{
case BN_PAINT:
usButton= SHORT1FROMMP(mp1)-200;
pubWork = (PUSERBUTTON)mp2;
WinQueryWindowRect(pubWork->hwnd,&rcl);
if((LOUSHORT(pubWork->fsState)&BDS_HILITED)==BDS_HILITED)
{
   WinDrawBorder(pubWork->hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x800L);
   rcl.xLeft++;
   rcl.xRight--;
   rcl.yTop--;
   rcl.yBottom++;
   WinFillRect(pubWork->hps, &rcl, SYSCLR_BUTTONMIDDLE);
   DrawPointer(pubWork->hps,3,1,rcl.yTop-4,rcl.yTop-4,
		punit->tb[usButton].hIcon, SYSCLR_BUTTONMIDDLE);
}
else
{
   WinDrawBorder(pubWork->hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x400L);
   rcl.xLeft++;
   rcl.xRight--;
   rcl.yTop--;
   rcl.yBottom++;
   WinFillRect(pubWork->hps, &rcl, SYSCLR_BUTTONMIDDLE);
   DrawPointer(pubWork->hps,2,2,rcl.yTop-4,rcl.yTop-4,
		punit->tb[usButton].hIcon, SYSCLR_BUTTONMIDDLE);
}

return (MRESULT)TRUE;

case BN_CLICKED:
return (MRESULT)TRUE;
}
return (MRESULT)FALSE;
}

int openfile(HWND hwnd,char *name,char *title)
{
   FILEDLG fileDialog;
   memset(&fileDialog,0,sizeof(FILEDLG));
   fileDialog.cbSize = sizeof(FILEDLG);

   fileDialog.pszTitle = title;
   fileDialog.fl = FDS_CENTER | FDS_OPEN_DIALOG;
   strcpy(fileDialog.szFullFile,name);
   if (!WinFileDlg(HWND_DESKTOP, hwnd, (PFILEDLG)&fileDialog))
       return 0;

   /*
    *  Upon sucessful return of a file, open it for reading
    */
   strcpy(name, fileDialog.szFullFile);
   if (fileDialog.lReturn == 1) return 1;
      else return 0;
}

void executetool(char * prog,char *arg,char *dir)
{
PROGDETAILS pDetails;
CHAR        szCurrentDir[256];
  INT i;
  pDetails.Length          = sizeof(PROGDETAILS);
  pDetails.progt.progc     = PROG_DEFAULT;
  pDetails.progt.fbVisible = SHE_VISIBLE;
  pDetails.pszTitle        = NULL;
  pDetails.pszExecutable   = prog;
  pDetails.pszParameters   = arg;
  if(!(*dir))
  {
  strcpy(szCurrentDir,prog);
  i=strlen(szCurrentDir)-1;
  while(szCurrentDir[i]!='\\')
  {
  szCurrentDir[i--]=0;
  if(i<0)break;
  }
    szCurrentDir[i]=0;
  pDetails.pszStartupDir   = szCurrentDir;
  }
  else
  pDetails.pszStartupDir   = dir;
  pDetails.pszIcon         = NULL;
  pDetails.pszEnvironment  = NULL;
  pDetails.swpInitial.fl   = SWP_ACTIVATE; /* window positioning */
  pDetails.swpInitial.cy   = 0;    /* width of window */
  pDetails.swpInitial.cx   = 0;    /* height of window */
  pDetails.swpInitial.y    = 0;    /* lower edge of window */
  pDetails.swpInitial.x    = 0;    /* left edge of window */
  pDetails.swpInitial.hwndInsertBehind = HWND_TOP;
  pDetails.swpInitial.hwnd             = HWND_DESKTOP;
  pDetails.swpInitial.ulReserved1      = 0;
  pDetails.swpInitial.ulReserved2      = 0;
  if(!WinStartApp( NULLHANDLE, &pDetails, NULL, NULL, 0 ))
      DosBeep(1000, 100);
}

MRESULT EXPENTRY toolargdlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
CHAR   buf[250];
USHORT i;
static TBARBUT * tb;
switch(msg)
{
case WM_INITDLG:
tb = (TBARBUT*)mp2;
WinSetWindowText(hwnd,tb->szPath);
WinSendDlgItemMsg(hwnd,225,EM_SETTEXTLIMIT,(MPARAM)80,NULL);
WinSendDlgItemMsg(hwnd,227,EM_SETTEXTLIMIT,(MPARAM)100,NULL);
WinSetWindowText(WinWindowFromID(hwnd,225),tb->szArg);
WinSetWindowText(WinWindowFromID(hwnd,227),tb->szDir);
break;
case WM_COMMAND:
if((SHORT)mp1==DID_OK)
{
WinQueryWindowText(WinWindowFromID(hwnd,225),80,tb->szArg);
WinQueryWindowText(WinWindowFromID(hwnd,227),100,tb->szDir);
}
break;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

TBARBUT tbt;
CHAR	buf2[250];

MRESULT EXPENTRY toolbardlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
CHAR   buf[250];
USHORT i;
static PUNITTOOLBAR punit;
switch(msg)
{
case WM_INITDLG:
punit = (PUNITTOOLBAR)mp2;
for(i=0;i<punit->usButtons;i++)
{
WinSendDlgItemMsg(hwnd,202,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(punit->tb[i].szPath));
WinSendDlgItemMsg(hwnd,210,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(punit->tb[i].szArg));
WinSendDlgItemMsg(hwnd,211,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(punit->tb[i].szDir));
}
break;

case WM_COMMAND:
switch((SHORT)mp1)
{
case 209: // set arguments
i=(SHORT)WinSendDlgItemMsg(hwnd,202,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE)break;
WinSendDlgItemMsg(hwnd,210,LM_QUERYITEMTEXT,
                           MPFROM2SHORT(i,80),(MPARAM)tbt.szArg);
WinSendDlgItemMsg(hwnd,211,LM_QUERYITEMTEXT,
                           MPFROM2SHORT(i,100),(MPARAM)tbt.szDir);
WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMTEXT,
                           MPFROM2SHORT(i,150),(MPARAM)tbt.szPath);
WinDlgBox(HWND_DESKTOP,hwnd,(PFNWP)toolargdlgproc,hmod,220,(PVOID)&tbt);
WinSendDlgItemMsg(hwnd,210,LM_SETITEMTEXT,
                           MPFROMSHORT(i),(MPARAM)tbt.szArg);
WinSendDlgItemMsg(hwnd,211,LM_SETITEMTEXT,
                           MPFROMSHORT(i),(MPARAM)tbt.szDir);
break;
case 206: // delete item
i=(SHORT)WinSendDlgItemMsg(hwnd,202,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE)break;
WinSendDlgItemMsg(hwnd,202,LM_DELETEITEM,
                  MPFROMSHORT(i),(MPARAM)0L);
WinSendDlgItemMsg(hwnd,210,LM_DELETEITEM,
                  MPFROMSHORT(i),(MPARAM)0L);
WinSendDlgItemMsg(hwnd,211,LM_DELETEITEM,
                  MPFROMSHORT(i),(MPARAM)0L);

break;
case 205:
strcpy(buf,"*.EXE");
if(openfile(hwnd,buf,"Add program"))
{
WinSendDlgItemMsg(hwnd,202,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(buf));
WinSendDlgItemMsg(hwnd,210,LM_INSERTITEM,
                           MPFROMSHORT(LIT_END),(MPARAM)"\0");
WinSendDlgItemMsg(hwnd,211,LM_INSERTITEM,
                           MPFROMSHORT(LIT_END),(MPARAM)"\0");
}
break;
case 207: // move unit up
i=(SHORT)WinSendDlgItemMsg(hwnd,202,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
if(i==0) break;

WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMTEXT,MPFROM2SHORT(i-1,250),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,202,LM_SETITEMTEXT,MPFROMSHORT(i),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,202,LM_SETITEMTEXT,MPFROMSHORT(i-1),MPFROMP(buf));

WinSendDlgItemMsg(hwnd,210,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,210,LM_QUERYITEMTEXT,MPFROM2SHORT(i-1,250),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,210,LM_SETITEMTEXT,MPFROMSHORT(i),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,210,LM_SETITEMTEXT,MPFROMSHORT(i-1),MPFROMP(buf));

WinSendDlgItemMsg(hwnd,211,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,211,LM_QUERYITEMTEXT,MPFROM2SHORT(i-1,250),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,211,LM_SETITEMTEXT,MPFROMSHORT(i),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,211,LM_SETITEMTEXT,MPFROMSHORT(i-1),MPFROMP(buf));


WinSendDlgItemMsg(hwnd,202,LM_SELECTITEM,
                           MPFROMSHORT(i),(MPARAM)FALSE);
WinSendDlgItemMsg(hwnd,202,LM_SELECTITEM,
                           MPFROMSHORT(i-1),(MPARAM)TRUE);
break;
case 208: // move unit down
i=(SHORT)WinSendDlgItemMsg(hwnd,202,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
if(i==(USHORT)WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMCOUNT,NULL,NULL)-1) break;
WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMTEXT,MPFROM2SHORT(i+1,250),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,202,LM_SETITEMTEXT,MPFROMSHORT(i),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,202,LM_SETITEMTEXT,MPFROMSHORT(i+1),MPFROMP(buf));

WinSendDlgItemMsg(hwnd,210,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,210,LM_QUERYITEMTEXT,MPFROM2SHORT(i+1,250),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,210,LM_SETITEMTEXT,MPFROMSHORT(i),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,210,LM_SETITEMTEXT,MPFROMSHORT(i+1),MPFROMP(buf));

WinSendDlgItemMsg(hwnd,211,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,211,LM_QUERYITEMTEXT,MPFROM2SHORT(i+1,250),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,211,LM_SETITEMTEXT,MPFROMSHORT(i),MPFROMP(buf2));
WinSendDlgItemMsg(hwnd,211,LM_SETITEMTEXT,MPFROMSHORT(i+1),MPFROMP(buf));


WinSendDlgItemMsg(hwnd,202,LM_SELECTITEM,
                           MPFROMSHORT(i),(MPARAM)FALSE);
WinSendDlgItemMsg(hwnd,202,LM_SELECTITEM,
                           MPFROMSHORT(i+1),(MPARAM)TRUE);

break;

case DID_OK:
for(i=0;i<punit->usButtons;i++)
{
WinFreeFileIcon(punit->tb[i].hIcon);
WinDestroyWindow(punit->tb[i].hwnd);
}
punit->usButtons=(USHORT)WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMCOUNT,NULL,NULL);
for(i=0;i<punit->usButtons;i++)
{
WinSendDlgItemMsg(hwnd,202,LM_QUERYITEMTEXT,MPFROM2SHORT(i,250),MPFROMP(punit->tb[i].szPath));
WinSendDlgItemMsg(hwnd,210,LM_QUERYITEMTEXT,MPFROM2SHORT(i,80),MPFROMP(punit->tb[i].szArg));
WinSendDlgItemMsg(hwnd,211,LM_QUERYITEMTEXT,MPFROM2SHORT(i,100),MPFROMP(punit->tb[i].szDir));
}
punit->unit.cbFix=sizeof(UNITTOOLBAR)+sizeof(TBARBUT)*i;
WinDismissDlg(hwnd,DID_OK);
break;
case DID_CANCEL:
WinDismissDlg(hwnd,DID_CANCEL);
break;
}
return (MRESULT)0L;
}

return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

char buf[256],cbuf[256];

MRESULT EXPENTRY toolbarwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
PUNITTOOLBAR punit;
CHAR *t;
HPS hps;
USHORT i;
RECTL rcl;
DRAGITEM dit;
PDRAGINFO pdin;
punit = (PUNITTOOLBAR)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CONTROL:
return buttoncontrolmsg(mp1,mp2,punit);

case WM_SIZE:
WinQueryWindowRect(hwnd,&rcl);
if(!rcl.yTop)break;
for(i=0;i<punit->usButtons;i++)
WinSetWindowPos(punit->tb[i].hwnd,HWND_TOP,i*(rcl.yTop-2)+1,1,rcl.yTop-2,rcl.yTop-2,SWP_SIZE | SWP_MOVE);
break;

case WM_CREATE:
punit = (PUNITTOOLBAR)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
//DosBeep(1000,100);
WinQueryWindowRect(hwnd,&rcl);
for(i=0;i<punit->usButtons;i++)
{
punit->tb[i].hIcon=WinLoadFileIcon(punit->tb[i].szPath,FALSE);
punit->tb[i].hwnd=WinCreateWindow(hwnd,WC_BUTTON,"",BS_PUSHBUTTON | BS_NOPOINTERFOCUS |
                WS_VISIBLE    | BS_USERBUTTON,i*(rcl.yTop-2)+1,1,rcl.yTop-2,rcl.yTop-2,hwnd,HWND_TOP,
                i+200,NULL,NULL);
}
break;

case DM_DROP:
/* file object drop */
pdin = (PDRAGINFO)mp1;
DrgAccessDraginfo(pdin);
DrgQueryDragitem(pdin,sizeof(DRAGITEM),&dit,0);
DrgFreeDraginfo(pdin);
DrgQueryStrName(dit.hstrContainerName,256,cbuf);
DrgQueryStrName(dit.hstrSourceName,256,buf);
strcat(cbuf,buf);
t=&cbuf[strlen(cbuf)-4];
if(!strcmp(t,".EXE"))
{
i=punit->usButtons++;
if(i==99)break;
memset(&punit->tb[i],0,sizeof(TBARBUT));
strcpy(punit->tb[i].szPath,cbuf);
WinQueryWindowRect(hwnd,&rcl);
punit->tb[i].hIcon=WinLoadFileIcon(punit->tb[i].szPath,FALSE);
punit->tb[i].hwnd=WinCreateWindow(hwnd,WC_BUTTON,"",BS_PUSHBUTTON | BS_NOPOINTERFOCUS |
                WS_VISIBLE    | BS_USERBUTTON,i*(rcl.yTop-2)+1,1,rcl.yTop-2,rcl.yTop-2,hwnd,HWND_TOP,
                i+200,NULL,NULL);
punit->unit.cbFix=sizeof(UNITTOOLBAR)+sizeof(TBARBUT)*i;
}
break;
case DM_DRAGOVER:
return MPFROM2SHORT(DOR_DROP,DO_LINK);

case WM_DESTROY:
//free(punit);
DosFreeMem(punit);
break;

case WM_PAINT:
WinQueryWindowRect(hwnd,&rcl);
hps = WinBeginPaint(hwnd,NULL,NULL);
/*GpiErase(hps);*/
//WinQueryWindowRect(hwnd,&rcl);
WinFillRect(hps, &rcl, SYSCLR_BUTTONMIDDLE);
WinDrawBorder(hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x800L);
WinEndPaint(hps);
return NULL;

case WM_COMMAND:
if(((SHORT)mp1>=200) && ((SHORT)mp1<300))
{
executetool(punit->tb[(SHORT)mp1-200].szPath,punit->tb[(SHORT)mp1-200].szArg,punit->tb[(SHORT)mp1-200].szDir);
break;
}
switch((SHORT)mp1)
{
case 100:
WinQueryWindowRect(hwnd,&rcl);
if(WinDlgBox(HWND_DESKTOP,(HWND)mp2,(PFNWP)toolbardlgproc,hmod,200,(PVOID)punit)==DID_OK)
for(i=0;i<punit->usButtons;i++)
{
punit->tb[i].hIcon=WinLoadFileIcon(punit->tb[i].szPath,FALSE);
punit->tb[i].hwnd=WinCreateWindow(hwnd,WC_BUTTON,"",BS_PUSHBUTTON | BS_NOPOINTERFOCUS |
                WS_VISIBLE    | BS_USERBUTTON,i*(rcl.yTop-2)+1,1,rcl.yTop-2,rcl.yTop-2,hwnd,HWND_TOP,
                i+200,NULL,NULL);
}
break;
}
return (MRESULT) NULL;

}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

void toolbarregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szToolbarClass);
pwc->ulCfgSize = sizeof(UNITTOOLBAR);
pwc->ulSafeAlloc = sizeof(UNITTOOLBAR)+sizeof(TBARBUT)*100;
pwc->bInitalUnitWidthPercent = 20;
WinRegisterClass(habMain,(PSZ)szToolbarClass,(PFNWP)toolbarwndproc,CS_SIZEREDRAW,8L);
}
