/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* taskbar */

#include "..\systray.h"
#include "plugin.h"

/* global vars */
extern HAB habMain;
extern HMODULE hmod;

char szTaskbarClass[] = "SystrayTaskbarClass";

struct _WinList {
HWND hwnd,hwndButton;
HPOINTER hIcon;
HSWITCH hsw;
LONG size;
ULONG fs;
CHAR text[232];
} WinList[100];

LONG lWinList=0L;
HWND hwndTaskbar=NULLHANDLE,hwndFocus;

#define MAXTEXT 62

typedef struct _FILTER {
    CHAR    szText[MAXTEXT];
    USHORT  bSearch;
} FILTER;

typedef FILTER * PFILTER;

typedef struct _UNITTASKBAR {
UNIT   u;
USHORT usFilters;
BOOL bHideIcons;
BOOL bOldButtons;
BOOL bProportional;
BOOL bUseTitlebar;
CHAR szFont[80];
FILTER f[1];
} UNITTASKBAR;

typedef UNITTASKBAR *PUNITTASKBAR;

PUNITTASKBAR punitTaskbar=NULL;

// this function deletes "unfunctional" spaces at string end

void  BackSpace(char *t)
{
   char *p;
   if (!strlen(t))return;
   p = t+strlen(t)-1;
   while (*p==' ')
   {
      if (p==t)break;
      *p='\0';
      p--;
   }
   p=t;
   while (*p)
   {
      if ((*p==13) || (*p==10))*p=' ';
      p++;
   }
}

// task scanner engine.

char  TaskBuffer[100000]; // sorry for this ;-(


MRESULT EXPENTRY buttonmenuwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);


BOOL  TestSwctl(PSWCNTRL swctl)
{
   int i;

   if (!swctl->idProcess)         return FALSE;
   if (swctl->uchVisibility!=SWL_VISIBLE)  return FALSE;
   if (!swctl->hwnd) return FALSE;
   for(i=0;i<punitTaskbar->usFilters;i++)
   {
//   if(!punitTaskbar->f[i].bSearch)
//   {
     if(!strncmp(swctl->szSwtitle,punitTaskbar->f[i].szText,
        strlen(punitTaskbar->f[i].szText))) return FALSE;
   // normal filter mode
//   }else{
//     if(strstr(swctl->szSwtitle,punitTaskbar->f[i].szText)) return FALSE;
   // search filter mode
//   }
   }
return TRUE;
}

void  ScanTasks()
{
   PSWBLOCK mysw;
   int k,i,j,count,ajsize;
   RECTL rcl;
   PFNWP oldProc;
   ULONG x;
   CHAR buf[80];

   WinQueryWindowRect(hwndTaskbar,&rcl);

   mysw = (PSWBLOCK)TaskBuffer;
   count = WinQuerySwitchList(habMain,mysw,100000L);

   k=0;

   for (i=0;i<count;i++)
      if (TestSwctl(&mysw->aswentry[i].swctl))k++;

      // kick all buttons when task list is clear

   if (k==0)
   {
      for (i=0;i<lWinList;i++)WinDestroyWindow(WinList[i].hwndButton);
      return;
   }

   if (k>0)

      ajsize = (rcl.xRight-2)/k;

   if ((ajsize>(rcl.yTop*6)) && !punitTaskbar->bProportional)ajsize=rcl.yTop*6;

   // main loop (whoah!). sorry but REALLY unreadable.

   i = 0;

   for (j=0;j<count;j++)
   {
      if (!TestSwctl(&mysw->aswentry[j].swctl))continue;

      if ((WinList[i].hwnd != mysw->aswentry[j].swctl.hwnd)        ||
          (                                              (i<lWinList) &&
          strcmp(WinList[i].text,  mysw->aswentry[j].swctl.szSwtitle)) ||
                                                       (i>=lWinList))
      {
         if (i<lWinList) WinDestroyWindow(WinList[i].hwndButton);
         // clean up old window
	 if(!punitTaskbar->bOldButtons)
         WinList[i].hwndButton = WinCreateWindow(hwndTaskbar, WC_BUTTON, "",
                                                 BS_PUSHBUTTON | BS_NOPOINTERFOCUS |
                                                 WS_VISIBLE    | BS_USERBUTTON,
                                                 1+(k-i-1)*ajsize, 1, ajsize,rcl.yTop-2,
                                                 hwndTaskbar, HWND_TOP, 200+i,
                                                 NULL, NULL);
	 else
         WinList[i].hwndButton = WinCreateWindow(hwndTaskbar, WC_BUTTON, "",
                                                 BS_PUSHBUTTON | BS_NOPOINTERFOCUS |
                                                 WS_VISIBLE    | BS_USERBUTTON,
                                                 (k-i-1)*ajsize, 0, ajsize-1,rcl.yTop,
                                                 hwndTaskbar, HWND_TOP, 200+i,
                                                 NULL, NULL);

         WinSetPresParam(WinList[i].hwndButton, PP_FONTNAMESIZE,80,punitTaskbar->szFont);

         oldProc = WinSubclassWindow(WinList[i].hwndButton,(PFNWP)buttonmenuwndproc);
         WinSetWindowULong(WinList[i].hwndButton,QWL_USER,(ULONG)oldProc);

         strcpy(WinList[i].text,mysw->aswentry[j].swctl.szSwtitle);
         WinList[i].hwnd = mysw->aswentry[j].swctl.hwnd;

         WinPostMsg(WinQueryWindow(hwndTaskbar,QW_PARENT),WM_USER,
                    (MPARAM)WinList[i].hwndButton,
                    (MPARAM)WinList[i].text);

/*         if (!TestSwctlIcon(&mysw->aswentry[j].swctl))*/
              WinList[i].hIcon = (HPOINTER)WinSendMsg(WinList[i].hwnd,
                                                      WM_QUERYICON,NULL,NULL);
//         else WinList[i].hIcon = NULL;
         WinList[i].hsw = mysw->aswentry[j].hswitch;
         WinList[i].size = ajsize;
      } else
      {
         WinQueryPresParam(WinList[i].hwndButton, PP_FONTNAMESIZE,NULL,&x,80,buf,0);
	 if(strcmp(buf,punitTaskbar->szFont))
         WinSetPresParam(WinList[i].hwndButton, PP_FONTNAMESIZE,80,punitTaskbar->szFont);
	 if(!punitTaskbar->bOldButtons)
         WinSetWindowPos(WinList[i].hwndButton,   /* move button */
                          HWND_TOP,
                          1+(k-i-1)*ajsize, 1, ajsize,rcl.yTop-2,
                          SWP_MOVE | SWP_SIZE
                        );
	 else
         WinSetWindowPos(WinList[i].hwndButton,   /* move button */
                          HWND_TOP,
                          (k-i-1)*ajsize, 0, ajsize-1,rcl.yTop,
                          SWP_MOVE | SWP_SIZE
                        );
         WinList[i].size = ajsize;
      }
      i++;
   }

   // kick dead buttons

   if (k<lWinList)
      for (i=k;i<lWinList;i++)WinDestroyWindow(WinList[i].hwndButton);
   lWinList = k;
}

void  WriteText(HPS hps,PRECTL rc,char *s,int fg,int bg)
{
GpiSetColor( hps, fg );
GpiSetBackColor( hps, bg );
GpiSetBackMix( hps, BM_OVERPAINT );

WinDrawText(hps,strlen(s),s,rc,fg,bg,DT_VCENTER|DT_ERASERECT|DT_LEFT);
}


MRESULT  tbuttoncontrolmsg(MPARAM mp1,MPARAM mp2)
{
CHAR buf[100];
PUSERBUTTON pubWork;
USHORT   usButton;
RECTL    rcl;

switch (SHORT2FROMMP(mp1))
{
case BN_PAINT:
usButton= SHORT1FROMMP(mp1)-200;
pubWork = (PUSERBUTTON)mp2;
WinQueryWindowRect(pubWork->hwnd,&rcl);
strcpy(buf,WinList[usButton].text);
BackSpace(buf);
if(((LOUSHORT(pubWork->fsState)&BDS_HILITED)==BDS_HILITED) ||
   (WinList[usButton].hwnd == hwndFocus) )
{
   WinDrawBorder(pubWork->hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x800L);
   rcl.xLeft++;
   rcl.xRight--;
   rcl.yTop--;
   rcl.yBottom++;
   WinFillRect(pubWork->hps, &rcl, SYSCLR_BUTTONMIDDLE);
   if(WinList[usButton].hIcon && !punitTaskbar->bHideIcons)
   {
   DrawPointer(pubWork->hps,3,1,rcl.yTop-4,rcl.yTop-4,
               WinList[usButton].hIcon, SYSCLR_BUTTONMIDDLE);
   rcl.xLeft+=rcl.yTop-1;
   }else rcl.xLeft++;
   rcl.yTop--;
   rcl.yTop--;
//   rcl.yTop--;
   WriteText(pubWork->hps,&rcl,buf,SYSCLR_BUTTONDEFAULT,SYSCLR_BUTTONMIDDLE);
}
else
{
   WinDrawBorder(pubWork->hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x400L);
   rcl.xLeft++;
   rcl.xRight--;
   rcl.yTop--;
   rcl.yBottom++;
   WinFillRect(pubWork->hps, &rcl, CLR_PALEGRAY);
   if(WinList[usButton].hIcon && !punitTaskbar->bHideIcons)
   {
   DrawPointer(pubWork->hps,2,2,rcl.yTop-4,rcl.yTop-4,
               WinList[usButton].hIcon,SYSCLR_BUTTONMIDDLE);
   rcl.xLeft+=rcl.yTop-2;
   }
   rcl.yTop--;
   rcl.yBottom++;
   WriteText(pubWork->hps,&rcl,buf,SYSCLR_BUTTONDEFAULT,SYSCLR_BUTTONMIDDLE);
}


return (MRESULT)TRUE;

case BN_CLICKED:
return (MRESULT)TRUE;
}
return (MRESULT)FALSE;
}

MRESULT  tbuttoncontrolmsgoldb(MPARAM mp1,MPARAM mp2)
{
CHAR buf[100];
PUSERBUTTON pubWork;
USHORT   usButton;
RECTL    rcl;

switch (SHORT2FROMMP(mp1))
{
case BN_PAINT:
usButton= SHORT1FROMMP(mp1)-200;
pubWork = (PUSERBUTTON)mp2;
WinQueryWindowRect(pubWork->hwnd,&rcl);
strcpy(buf,WinList[usButton].text);
BackSpace(buf);
if(((LOUSHORT(pubWork->fsState)&BDS_HILITED)==BDS_HILITED) ||
   (WinList[usButton].hwnd == hwndFocus))
{
   WinDrawBorder(pubWork->hps,&rcl,2,2,CLR_DARKGRAY,CLR_WHITE,0x800L);
   rcl.xLeft++;   rcl.xLeft++;
   rcl.xRight--;   rcl.xRight--;
   rcl.yTop--;   rcl.yTop--;
   rcl.yBottom++;   rcl.yBottom++;
   WinFillRect(pubWork->hps, &rcl, SYSCLR_BUTTONMIDDLE);
   if(WinList[usButton].hIcon && !punitTaskbar->bHideIcons)
   {
   DrawPointer(pubWork->hps,4,2,rcl.yTop-5,rcl.yTop-5,
               WinList[usButton].hIcon, SYSCLR_BUTTONMIDDLE);
   rcl.xLeft+=rcl.yTop-1;
   }else rcl.xLeft++;
//   rcl.yTop--;
   rcl.yTop--;
//   rcl.yTop--;
   WriteText(pubWork->hps,&rcl,buf,SYSCLR_BUTTONDEFAULT,SYSCLR_BUTTONMIDDLE);
}
else
{
   WinDrawBorder(pubWork->hps,&rcl,2,2,CLR_DARKGRAY,CLR_WHITE,0x400L);
   rcl.xLeft++;   rcl.xLeft++;
   rcl.xRight--;   rcl.xRight--;
   rcl.yTop--;   rcl.yTop--;
   rcl.yBottom++;   rcl.yBottom++;
   WinFillRect(pubWork->hps, &rcl, SYSCLR_BUTTONMIDDLE);
   if(WinList[usButton].hIcon && !punitTaskbar->bHideIcons)
   {
   DrawPointer(pubWork->hps,3,3,rcl.yTop-5,rcl.yTop-5,
               WinList[usButton].hIcon,SYSCLR_BUTTONMIDDLE);
   rcl.xLeft+=rcl.yTop-2;
   }
//   rcl.yTop--;
   rcl.yBottom++;
   WriteText(pubWork->hps,&rcl,buf,SYSCLR_BUTTONDEFAULT,SYSCLR_BUTTONMIDDLE);

}


return (MRESULT)TRUE;

case BN_CLICKED:
return (MRESULT)TRUE;
}
return (MRESULT)FALSE;
}

MRESULT EXPENTRY filterdlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

MRESULT EXPENTRY buttonmenuwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
PFNWP oldProc;
USHORT id,i;
RECTL rcl;
oldProc = (PFNWP)WinQueryWindowULong (hwnd, QWL_USER);
switch(msg)
{
case WM_BUTTON2CLICK:
{
POINTL ptl;
HWND   hwndMenu;

hwndMenu = WinLoadMenu(hwnd,hmod,400);
WinQueryPointerPos(HWND_DESKTOP, &ptl);
WinMapWindowPoints(HWND_DESKTOP,hwnd,&ptl,1);
WinPopupMenu(hwnd, hwnd, hwndMenu, ptl.x, ptl.y, 0, PU_HCONSTRAIN   | PU_VCONSTRAIN |
                                                    PU_MOUSEBUTTON1 | PU_KEYBOARD);
break;
}
case WM_COMMAND:
id = WinQueryWindowUShort(hwnd, QWS_ID);
switch((USHORT)mp1)
{
case 402:
i=punitTaskbar->usFilters;
strcpy(punitTaskbar->f[i].szText,WinList[id-200].text);
if(WinDlgBox(HWND_DESKTOP,hwnd,(PFNWP)filterdlgproc,hmod,
	     600,(PVOID)&punitTaskbar->f[i]) == DID_OK)
punitTaskbar->usFilters++;
punitTaskbar->u.cbFix=sizeof(UNITTASKBAR)+sizeof(FILTER)*punitTaskbar->usFilters-sizeof(FILTER);
break;
case 403:
for(i=0;i<lWinList;i++)
{
WinSetWindowPos(WinList[i].hwnd,HWND_TOP,0,0,0,0,
                SWP_HIDE);
WinPostMsg(WinList[i].hwnd,WM_SYSCOMMAND,(MPARAM)SC_MINIMIZE,(MPARAM)0);
hwndFocus = NULL;
WinQueryWindowRect(hwndTaskbar,&rcl);
WinInvalidateRect(hwndTaskbar,&rcl,TRUE);
}
break;
case 404:
WinPostMsg(WinList[id-200].hwnd,WM_SYSCOMMAND,(MPARAM)0x8011,NULL);
break;
case 405:
WinPostMsg(WinList[id-200].hwnd,WM_SYSCOMMAND,(MPARAM)SC_CLOSE,NULL);
break;
}
break;
}

return oldProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY filterdlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
static PFILTER pfil;
switch(msg)
{
case WM_INITDLG:
pfil = (PFILTER) mp2;
WinSendDlgItemMsg(hwnd,602,EM_SETTEXTLIMIT,(MPARAM)64,NULL);
WinSetWindowText(WinWindowFromID(hwnd,602),pfil->szText);
WinCheckButton (hwnd,603,pfil->bSearch);
break;
case WM_COMMAND:
if((SHORT)mp1==DID_OK)
{
WinQueryWindowText(WinWindowFromID(hwnd,602),64,pfil->szText);
pfil->bSearch= WinQueryButtonCheckstate (hwnd,603);
}
break;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

MRESULT EXPENTRY taskbardlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
INT i;
CHAR buf[256];
FILTER f;
static PUNITTASKBAR punit;
switch(msg)
{
case WM_INITDLG:
punit = (PUNITTASKBAR)mp2;
for(i=0;i<punit->usFilters;i++)
WinSendDlgItemMsg(hwnd,402,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(punit->f[i].szText));
for(i=0;i<punit->usFilters;i++)
WinSendDlgItemMsg(hwnd,413,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP((!punit->f[i].bSearch) ? "0" : "1"));
WinCheckButton(hwnd,409,punit->bHideIcons);
WinCheckButton(hwnd,410,punit->bProportional);
WinCheckButton(hwnd,411,punit->bOldButtons);
WinCheckButton(hwnd,412,punit->bUseTitlebar);
break;
case WM_COMMAND:
switch((SHORT)mp1)
{
case DID_OK:
punit->bHideIcons=WinQueryButtonCheckstate(hwnd,409);
punit->bProportional=WinQueryButtonCheckstate(hwnd,410);
punit->bOldButtons=WinQueryButtonCheckstate(hwnd,411);
punit->bUseTitlebar=WinQueryButtonCheckstate(hwnd,412);
punit->usFilters=(USHORT)WinSendDlgItemMsg(hwnd,402,LM_QUERYITEMCOUNT,NULL,NULL);
for(i=0;i<punit->usFilters;i++)
WinSendDlgItemMsg(hwnd,402,LM_QUERYITEMTEXT,MPFROM2SHORT(i,MAXTEXT),MPFROMP(punit->f[i].szText));
for(i=0;i<punit->usFilters;i++)
{
WinSendDlgItemMsg(hwnd,413,LM_QUERYITEMTEXT,MPFROM2SHORT(i,MAXTEXT),MPFROMP(buf));
punit->f[i].bSearch = (buf[0]=='0') ? 0 : 1;
}
break;
case 403:
i=punit->usFilters;
f.szText[0]='\0';
if(WinDlgBox(HWND_DESKTOP,hwnd,(PFNWP)filterdlgproc,hmod,
         600,(PVOID)&f) == DID_OK)
{
WinSendDlgItemMsg(hwnd,402,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(f.szText));
WinSendDlgItemMsg(hwnd,413,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP((f.bSearch==0) ? "0" : "1"));
}
return NULL;
case 404:
i=(SHORT)WinSendDlgItemMsg(hwnd,402,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE)return NULL;
WinSendDlgItemMsg(hwnd,402,LM_QUERYITEMTEXT,MPFROM2SHORT(i,MAXTEXT),MPFROMP(f.szText));
WinSendDlgItemMsg(hwnd,413,LM_QUERYITEMTEXT,MPFROM2SHORT(i,MAXTEXT),MPFROMP(buf));
punit->f[i].bSearch = (buf[0]=='0') ? 0 : 1 ;
if(WinDlgBox(HWND_DESKTOP,hwnd,(PFNWP)filterdlgproc,hmod,
             600,(PVOID)&f) == DID_OK)
WinSendDlgItemMsg(hwnd,402,LM_SETITEMTEXT,MPFROMSHORT(i),
                  MPFROMP(f.szText));
WinSendDlgItemMsg(hwnd,413,LM_SETITEMTEXT,MPFROMSHORT(i),
                  MPFROMP((!f.bSearch) ? "0" : "1"));
//if(f.bSearch)DosBeep(1000,100);
return NULL;
case 405:
i=(SHORT)WinSendDlgItemMsg(hwnd,402,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE)return NULL;
WinSendDlgItemMsg(hwnd,402,LM_DELETEITEM,MPFROMSHORT(i),(MPARAM)0L);
WinSendDlgItemMsg(hwnd,413,LM_DELETEITEM,MPFROMSHORT(i),(MPARAM)0L);
return NULL;
}
break;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}


MRESULT EXPENTRY taskbarwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
PUNITTASKBAR punit;
HWND hwndf;
HPS hps;
RECTL rcl;
ULONG x;
punit = (PUNITTASKBAR)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CONTROL:
if(!punit->bOldButtons)
return tbuttoncontrolmsg(mp1,mp2);
else
return tbuttoncontrolmsgoldb(mp1,mp2);
case WM_CREATE:
punit = (PUNITTASKBAR)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
if(hwndTaskbar)
{
DosFreeMem(punit);
WinDestroyWindow(hwnd);
return NULL;
}
if(!punit->szFont[0])strcpy(punit->szFont,"9.WarpSans");
WinSetPresParam(hwnd, PP_FONTNAMESIZE,80,punit->szFont);
punitTaskbar = punit;
hwndTaskbar = hwnd;
ScanTasks();
WinStartTimer(habMain,hwnd,1,1200L);
break;
case WM_TIMER:
hwndf = WinQueryActiveWindow(HWND_DESKTOP);
if(hwndf != WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT),QW_PARENT))
{
if(hwndFocus!=hwndf)
{
hwndFocus=hwndf;
WinQueryWindowRect(hwnd,&rcl);
WinInvalidateRect(hwnd,&rcl,TRUE);
}
}
WinQueryPresParam(hwnd, PP_FONTNAMESIZE,NULL,&x,80,punit->szFont,0);
ScanTasks();
break;
case WM_PAINT:
hps = WinBeginPaint(hwnd,NULL,NULL);
WinQueryWindowRect(hwnd, &rcl);
WinFillRect(hps, &rcl, SYSCLR_BUTTONMIDDLE);
if(!punit->bOldButtons)
WinDrawBorder(hps,&rcl,1,1,CLR_DARKGRAY,CLR_WHITE,0x800L);
WinEndPaint(hps);
return (MRESULT) NULL;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 100:
WinDlgBox(HWND_DESKTOP,(HWND)mp2,(PFNWP)taskbardlgproc,hmod,400,(PVOID)punit);
punit->u.cbFix=sizeof(UNITTASKBAR)+sizeof(FILTER)*punit->usFilters-sizeof(FILTER);
break;
}
if((SHORT)mp1>=200)
{
if(WinList[(SHORT)mp1-200].hwnd == hwndFocus)
{
WinSetWindowPos(WinList[(SHORT)mp1-200].hwnd,HWND_TOP,0,0,0,0,
                SWP_HIDE);
WinPostMsg(WinList[(SHORT)mp1-200].hwnd,WM_SYSCOMMAND,(MPARAM)SC_MINIMIZE,(MPARAM)0);
hwndFocus = NULL;
WinQueryWindowRect(hwnd,&rcl);
WinInvalidateRect(hwnd,&rcl,TRUE);
}
else
{
hwndFocus = WinList[(SHORT)mp1-200].hwnd;
WinQueryWindowRect(hwnd,&rcl);
WinInvalidateRect(hwnd,&rcl,TRUE);
WinSwitchToProgram(WinList[(SHORT)mp1-200].hsw);
WinSetWindowPos(WinList[(SHORT)mp1-200].hwnd,HWND_TOP,0,0,0,0,
                SWP_ACTIVATE | SWP_SHOW | SWP_ZORDER);

}
}
return (MRESULT) NULL;
case WM_DESTROY:
//free(punit);
DosFreeMem(punit);
hwndTaskbar=NULLHANDLE;
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

void taskbarregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szTaskbarClass);
pwc->ulCfgSize = sizeof(UNITTASKBAR);
pwc->ulSafeAlloc = sizeof(UNITTASKBAR)+sizeof(FILTER)*100;
pwc->bInitalUnitWidthPercent = 70;
WinRegisterClass(habMain,(PSZ)szTaskbarClass,(PFNWP)taskbarwndproc,CS_SIZEREDRAW,8L);
}

