/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* Swap file monitor */

#include "..\systray.h"
#include <dos.h>
#include <ctype.h>
#include "plugin.h"

char    szSwapClass[] = "SystraySwapMonitorClass";
char    szHelpSwap[] = "Swap file size monitor";

extern HAB     habMain;
extern HMODULE hmod;

HPOINTER        hptrSwapIcon;

#define TBUF 30

typedef struct _UNITSWAPMON {
UNIT    unit;
BYTE    bZero;
UPPR    uppr;
CHAR    path[80];
CHAR    buf[TBUF];
} UNITSWAPMON;

typedef UNITSWAPMON *PUNITSWAPMON;


MRESULT EXPENTRY swapmonwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
struct find_t fi;
FILE *f;
PUNITSWAPMON punit;
HPS hps;
RECTL rcl;
char buf[256],*t;
punit = (PUNITSWAPMON)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CREATE:
punit = (PUNITSWAPMON)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
if(!punit->bZero)
{
punit->bZero = 1;
punit->uppr.fgColor = 0x007F0000L;
punit->uppr.bgColor = 0x00CCCCCCL;
strcpy(punit->uppr.szFont,"8.Helv");
}

DosQuerySysInfo(5,5,&buf[0],4); /* search for x:\config.sys file */
buf[0]+=64;buf[1]='\0';
//sprintf(buf,"%c:\\config.sys",buf[0]+64);
strcat(buf,":\\CONFIG.SYS");
f=fopen(buf,"rt");
if(f)
{
while(!feof(f))
{
fgets(buf,250,f);
if(!strnicmp(buf,"SWAPPATH=",9)) /* search for SWAPPATH string */
break;
}
fclose(f);
strcpy(buf,&buf[9]);
t=strchr(buf,' ');
if(t)
{
*t='\0';
}

if(buf[strlen(buf)-1]!='\\')strcat(buf,"\\");

strcat(buf,"SWAPPER.DAT");
strcpy(punit->path,buf);
/*f=fopen("log","wt");
fprintf(f,"%s",buf);
fclose(f);*/
}else DosBeep(500,100);
_dos_findfirst(punit->path,0x20,&fi);
_dos_findclose(&fi);

sprintf(punit->buf,"Swap: %luM",fi.size>>20);
SetUnitPresParam(hwnd,&punit->uppr);
WinStartTimer(habMain, hwnd, 1, 9000);
WinSendMsg(WinQueryWindow(hwnd,QW_PARENT),WM_USER,(MPARAM)hwnd,
           (MPARAM)szHelpSwap);
break;
case WM_TIMER:
_dos_findfirst(punit->path,0x20,&fi);
_dos_findclose(&fi);
sprintf(punit->buf,"Swap: %luM",fi.size>>20);
GetUnitPresParam(hwnd, &punit->uppr);
hps = WinGetPS(hwnd);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, hptrSwapIcon, punit->buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinReleasePS(hps);
break;
case WM_SIZE:
break;
case WM_PAINT:
GetUnitPresParam(hwnd, &punit->uppr);
hps = WinBeginPaint(hwnd, NULL, NULL);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, hptrSwapIcon, punit->buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinEndPaint(hps);
return (MRESULT) NULL;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 100:
/* no configuration :( */
break;
}
return (MRESULT) NULL;
case WM_DESTROY:
DosFreeMem(punit); /* free unit memory */
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}


void swapmonregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szSwapClass);
pwc->ulCfgSize = sizeof(UNITSWAPMON)-TBUF;
pwc->ulSafeAlloc = sizeof(UNITSWAPMON);
pwc->bInitalUnitWidthPercent = 10;
WinRegisterClass(habMain,(PSZ)szSwapClass,(PFNWP)swapmonwndproc,CS_SIZEREDRAW,8L);
hptrSwapIcon = WinLoadPointer(HWND_DESKTOP,hmod,301);
}
