/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* Main plugin source */

#include "..\systray.h"
#include "plugin.h"

// our global variables

HAB habMain;
HMODULE hmod;

// Draw pointer with given width & height (scrable ]:->)

VOID DrawPointer(HPS hps, int x, int y, int sx, int sy,
                 HPOINTER hptr, LONG bgColor)
{
POINTL pt[4];
RECTL  rc1,rc2;
POINTERINFO pim;
BITMAPINFOHEADER2 bmp;

WinQueryPointerInfo(hptr,&pim);

rc2.xLeft = x;
rc2.xRight = x+sx+1;
rc2.yBottom = y;
rc2.yTop = y+sy+1;

pt[0].x = x;
pt[0].y = y;
pt[1].x = x+sx;
pt[1].y = y+sy;

GpiSetPattern(hps, PATSYM_SOLID);
GpiSetColor(hps, CLR_BLACK);
GpiSetBackColor(hps, bgColor);
//GpiSetMix(hps, FM_OVERPAINT);
//GpiSetBackMix(hps, BM_OVERPAINT);

if((pim.hbmMiniColor) && (sx<20)) // mini-sized color sub-bitmap
   {
   bmp.cbFix = 16L;
   GpiQueryBitmapInfoHeader(pim.hbmMiniColor, &bmp);
   rc1.xLeft = 0;
   rc1.xRight = bmp.cx;
   rc1.yBottom = bmp.cy;
   rc1.yTop = bmp.cy*2;
   // first part: clear bg mask for icon
   WinDrawBitmap(hps, pim.hbmMiniPointer, &rc1, (PPOINTL)&rc2,
                 bgColor, CLR_BLACK, DBM_STRETCH);
   pt[2].x = pt[2].y = 0;
   pt[3].x = bmp.cx;
   pt[3].y = bmp.cy;
   // second part: draw color bits
   GpiWCBitBlt(hps, pim.hbmMiniColor, 4, pt, ROP_SRCPAINT, BBO_IGNORE);
   } else if(pim.hbmColor) // normal-sized color sub-bitmap
   {
   bmp.cbFix = 16L;
   GpiQueryBitmapInfoHeader(pim.hbmColor, &bmp);
   rc1.xLeft = 0;
   rc1.xRight = bmp.cx;
   rc1.yBottom = bmp.cy;
   rc1.yTop = bmp.cy*2;
   WinDrawBitmap(hps, pim.hbmPointer, &rc1, (PPOINTL)&rc2,
                 bgColor, CLR_BLACK, DBM_STRETCH);
   pt[2].x = pt[2].y = 0;
   pt[3].x = bmp.cx;
   pt[3].y = bmp.cy;
   GpiWCBitBlt(hps, pim.hbmColor, 4, pt, ROP_SRCPAINT,BBO_IGNORE);
   } else // b/w sub-bitmap
   {
   bmp.cbFix = 16L;
   GpiQueryBitmapInfoHeader(pim.hbmPointer,&bmp);
   rc1.xLeft = 0; rc1.xRight = bmp.cx;
   rc1.yBottom = bmp.cy; rc1.yTop = bmp.cy*2;
   WinDrawBitmap(hps, pim.hbmPointer, &rc1, (PPOINTL)&rc2,
                 bgColor, CLR_BLACK, DBM_STRETCH);
   pt[2].x = pt[2].y = 0;
   pt[3].x = bmp.cx;
   pt[3].y = bmp.cy;
   GpiWCBitBlt(hps, pim.hbmPointer, 4, pt, ROP_SRCPAINT, BBO_IGNORE);
   }
}

VOID DrawUnitIconText(HPS hps, PRECTL prcl, HPOINTER hIcon,
                      PSZ pszText, LONG bgColor, LONG fgColor)
{
WinFillRect(hps, prcl, bgColor);
WinDrawBorder(hps, prcl, 1, 1, 0L, 0L, 0x800L);
if(hIcon)
{
DrawPointer(hps, 3, 3, prcl->yTop - 7, prcl->yTop - 7, hIcon, bgColor);
prcl->xLeft += prcl->yTop - 5;
}
WinDrawText(hps, -1, pszText, prcl, fgColor, bgColor, DT_CENTER | DT_VCENTER);
}

VOID GetUnitPresParam(HWND hwnd,UPPR *uppr)
{
ULONG ulTemp;
WinQueryPresParam(hwnd, PP_FONTNAMESIZE, NULL, &ulTemp, 80, uppr->szFont, 0);
WinQueryPresParam(hwnd, PP_BACKGROUNDCOLOR, NULL, &ulTemp, sizeof(LONG),
                  &uppr->bgColor, QPF_PURERGBCOLOR);
WinQueryPresParam(hwnd, PP_FOREGROUNDCOLOR, NULL, &ulTemp, sizeof(LONG),
                  &uppr->fgColor, QPF_PURERGBCOLOR);
}

VOID SetUnitPresParam(HWND hwnd,UPPR *uppr)
{
WinSetPresParam(hwnd, PP_FONTNAMESIZE, 80, uppr->szFont);
WinSetPresParam(hwnd, PP_BACKGROUNDCOLOR, sizeof(LONG), &uppr->bgColor);
WinSetPresParam(hwnd, PP_FOREGROUNDCOLOR, sizeof(LONG), &uppr->fgColor);
}

BOOL EXPENTRY RegisterPluginProc(HMODULE hself,HAB hab,PWCLASS pwc,PUSHORT pusn)
{
hmod = hself;
habMain = hab;
*pusn = 8; // number of classes loaded in

/* register classes */
/* Clock Class */
clockregisterclass(&pwc[0]);
/* Systemp Uptime */
uptimeregisterclass(&pwc[6]);
/* Tool bar class */
toolbarregisterclass(&pwc[1]);
/* Disk Monitor class */
diskmonregisterclass(&pwc[2]);
/* Swap Monitor class */
swapmonregisterclass(&pwc[3]);
/* System tray monitor class */
systrayregisterclass(&pwc[4]);
/* task bar class */
taskbarregisterclass(&pwc[5]);
/* cpu monitor class */
cpumonregisterclass(&pwc[7]);
return TRUE;
}
