/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* Disk monitor */

#include "..\systray.h"
#include <dos.h>
#include <ctype.h>
#include "plugin.h"

char    szDiskClass[] = "SystrayDiskMonitorClass";
char    szHelp[] = "Free disk space monitor";

extern HAB     habMain;
extern HMODULE hmod;

HPOINTER        hptrDiskIcon;

#define TBUF 30

typedef struct _UNITDISKMON {
UNIT    unit;
BYTE    bZero;
CHAR    chDrive;
CHAR    chRes[2];
UPPR    uppr;
CHAR    buf[TBUF];
} UNITDISKMON;

typedef UNITDISKMON *PUNITDISKMON;

MRESULT EXPENTRY diskmondlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
static PUNITDISKMON punit;
switch(msg)
{
case WM_INITDLG:
punit = (PUNITDISKMON)mp2;
WinSendDlgItemMsg(hwnd,303,EM_SETTEXTLIMIT,(MPARAM)1,NULL);
WinSetWindowText(WinWindowFromID(hwnd,303),&punit->chDrive);
break;
case WM_COMMAND:
if((SHORT)mp1==DID_OK)
WinQueryWindowText(WinWindowFromID(hwnd,303),2,&punit->chDrive);
punit->chDrive = toupper(punit->chDrive);
break;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

MRESULT EXPENTRY diskmonwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
struct {
ULONG filesysid;
ULONG sectornum;
ULONG unitnum;
ULONG unitavail;
USHORT bytesnum;
} level1;
PUNITDISKMON punit;
HPS hps;
RECTL rcl;
punit = (PUNITDISKMON)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CREATE:
punit = (PUNITDISKMON)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
if(!punit->bZero)
{
punit->bZero = 1;
punit->chDrive = 'C';
punit->uppr.fgColor = 0L;
punit->uppr.bgColor = 0x00CCCCCCL;
strcpy(punit->uppr.szFont,"8.Helv");
}

DosQueryFSInfo((ULONG)(punit->chDrive-64), 1, (PVOID)&level1, sizeof(level1));
sprintf(punit->buf,"%c: %luM Free",punit->chDrive,level1.sectornum*level1.unitavail/2048);
SetUnitPresParam(hwnd,&punit->uppr);
WinQueryWindowRect(hwnd, &rcl);
WinStartTimer(habMain, hwnd, 1, 15000);
WinSendMsg(WinQueryWindow(hwnd,QW_PARENT),WM_USER,(MPARAM)hwnd,
           (MPARAM)szHelp);
break;
case WM_TIMER:
DosQueryFSInfo((ULONG)(punit->chDrive-64), 1, (PVOID)&level1, sizeof(level1));
sprintf(punit->buf,"%c: %luM Free",punit->chDrive,level1.sectornum*level1.unitavail/2048);
GetUnitPresParam(hwnd, &punit->uppr);
hps = WinGetPS(hwnd);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, hptrDiskIcon, punit->buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinReleasePS(hps);
break;
case WM_SIZE:
break;
case WM_PAINT:
GetUnitPresParam(hwnd, &punit->uppr);
hps = WinBeginPaint(hwnd, NULL, NULL);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, hptrDiskIcon, punit->buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinEndPaint(hps);
return (MRESULT) NULL;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 100:
WinDlgBox(HWND_DESKTOP,(HWND)mp2,(PFNWP)diskmondlgproc,hmod,300,(PVOID)punit);
WinPostMsg(hwnd,WM_TIMER,(MPARAM)0L,(MPARAM)0L);
break;
}
return (MRESULT) NULL;
case WM_DESTROY:
//free(punit);
DosFreeMem(punit);
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}


void diskmonregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szDiskClass);
pwc->ulCfgSize = sizeof(UNITDISKMON)-TBUF;
pwc->ulSafeAlloc = sizeof(UNITDISKMON);
pwc->bInitalUnitWidthPercent = 10;
WinRegisterClass(habMain,(PSZ)szDiskClass,(PFNWP)diskmonwndproc,CS_SIZEREDRAW,8L);
hptrDiskIcon = WinLoadPointer(HWND_DESKTOP,hmod,300);
}
