/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* CPU load monitor */

#include "..\systray.h"
#include "dosqss.h"
#include "plugin.h"

char    szCpuClass[] = "SystrayCPUMonClass";
char    szHelpCpu[] = "CPU monitor";

extern HAB     habMain;
extern HMODULE hmod;

HPOINTER        hptrCpuIcon;

typedef struct _UNITCPU {
UNIT    unit;
BYTE    bZero;
BOOL    bSolid,bText;
UPPR    uppr;
SHORT   p;
UCHAR   ap[1024];
} UNITCPU;

typedef UNITCPU *PUNITCPU;

#define PQ_BUFSIZE 0x10000
#define MAXPROC    1024
char	qssbuf[PQ_BUFSIZE];

struct  PROCLIST
{
USHORT pid;
USHORT touch;
ULONG  ulDeltaUsr;
ULONG  ulDeltaSys;
ULONG  ulOldUsr;
ULONG  ulOldSys;
} proclist[MAXPROC];

void proc2list(PQPROCESS pProcRecord,ULONG ulSys,ULONG ulUsr)
{
int i;
if(!pProcRecord->pid)return;
for(i=0;i<MAXPROC;i++)
{
if(proclist[i].pid==pProcRecord->pid)
{
proclist[i].touch=1;
proclist[i].ulDeltaUsr=ulUsr-proclist[i].ulOldUsr;
proclist[i].ulDeltaSys=ulSys-proclist[i].ulOldSys;
proclist[i].ulOldUsr=ulUsr;
proclist[i].ulOldSys=ulSys;
break;
}
}
if(i==MAXPROC)
{
for(i=0;i<MAXPROC;i++)
if(!proclist[i].pid)break;

proclist[i].touch=1;
proclist[i].pid=pProcRecord->pid;
proclist[i].ulDeltaUsr=0L; // new process
proclist[i].ulDeltaSys=0L;
proclist[i].ulOldUsr=ulUsr;
proclist[i].ulOldSys=ulSys;
}
}

void cleanlist()
{
int i;
for(i=0;i<MAXPROC;i++)
proclist[i].touch=0;
}

void initlist()
{
int i;
for(i=0;i<MAXPROC;i++)
proclist[i].pid=0;
}

USHORT  GetCPULoad()
{
APIRET RC;
PQTOPLEVEL pqData=0;
PQPROCESS pProcRecord;
PQTHREAD pThread;
ULONG ulSys=0L,ulUsr=0L;
int i,j;
pqData = (PQTOPLEVEL) qssbuf;
memset(pqData, 0, PQ_BUFSIZE);
RC = DosQuerySysState(0x1F, 0, 0, 0, pqData, PQ_BUFSIZE);
if(RC)return 0L;
pProcRecord = pqData->procdata;
cleanlist();
while ( pProcRecord->rectype != 3 )
{
pThread = pProcRecord->threads;
ulSys=ulUsr=0L;
if(pThread)
{
for(j = 0; j < pProcRecord->threadcnt; j++)
{
ulSys += pThread->systime;
ulUsr += pThread->usertime;
pThread++;
}
proc2list(pProcRecord,ulSys,ulUsr);
pProcRecord=(PQPROCESS)(pThread);
}else pProcRecord++;
}
ulSys=ulUsr=0L;
for(i=0;i<MAXPROC;i++)
{
if(!proclist[i].touch)proclist[i].pid=0;
else if(proclist[i].pid)
{
ulSys+=proclist[i].ulDeltaSys;
ulUsr+=proclist[i].ulDeltaUsr;
}
}
if((ulSys+ulUsr)<=0)
{
ulUsr=0L;ulSys=1L;
}
return (ulUsr*100L)/(ulSys+ulUsr);
}

MRESULT EXPENTRY cpudlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
static PUNITCPU punit;
switch(msg)
{
case WM_INITDLG:
punit = (PUNITCPU)mp2;
WinCheckButton(hwnd,802,punit->bSolid);
WinCheckButton(hwnd,803,punit->bText);
break;
case WM_COMMAND:
switch((SHORT)mp1)
{
case DID_OK:
punit->bSolid=WinQueryButtonCheckstate(hwnd,802);
punit->bText=WinQueryButtonCheckstate(hwnd,803);
break;
}
break;

}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}


MRESULT EXPENTRY cpuwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
HWND hwndMon;
POINTL ptl;
RECTL rcl;
PUNITCPU punit;
HPS hps;
int i;
char buf[10];
punit = (PUNITCPU)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CREATE:
punit = (PUNITCPU)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
if(!punit->bZero)
{
punit->bZero = 1;
punit->uppr.fgColor = 0L;
punit->uppr.bgColor = 0x00CCCCCCL;
strcpy(punit->uppr.szFont,"8.Helv");
}
punit->p = 0;
punit->ap[0] = GetCPULoad();
SetUnitPresParam(hwnd,&punit->uppr);
WinStartTimer(habMain, hwnd, 1, 2000);
WinSendMsg(WinQueryWindow(hwnd,QW_PARENT),WM_USER,
           (MPARAM)hwnd,(MPARAM)szHelpCpu);
initlist();
break;
case WM_TIMER:
if(punit->p<1023)
{
punit->p++;
punit->ap[punit->p]=GetCPULoad();
}else{
memcpy(&punit->ap[0],&punit->ap[1],1023);
punit->ap[1023]=GetCPULoad();
}
WinQueryWindowRect(hwnd,&rcl);
WinInvalidateRect(hwnd,&rcl,TRUE);
break;
case WM_SIZE:
break;
case WM_PAINT:
GetUnitPresParam(hwnd, &punit->uppr);
hps = WinBeginPaint(hwnd,NULL,NULL);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
if(punit->bText)sprintf(buf,"%02d%%",punit->ap[punit->p]);
else buf[0]='\0';
DrawUnitIconText(hps, &rcl, hptrCpuIcon, buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);

/*if(punit->p>rcl.xRight-2)
ptl.x=punit->p-(rcl.xRight-2);
else ptl.x=0;*/
if(punit->p>rcl.xRight-4)i=punit->p-rcl.xRight+4;
else i=0;
ptl.x=rcl.yTop-4;
ptl.y=(punit->ap[i]/4)+2;
if(ptl.y>(rcl.yTop-3))ptl.y=rcl.yTop-3;
GpiMove(hps,&ptl);
GpiSetColor(hps, punit->uppr.fgColor);
for(;ptl.x<(rcl.xRight-1);ptl.x++)
{
if(punit->bSolid)
{
ptl.y=2;
GpiMove(hps,&ptl);
}
ptl.y=(punit->ap[i]/4)+2;i++;
GpiLine(hps,&ptl);
if(ptl.y>(rcl.yTop-3))ptl.y=rcl.yTop-3;
if(i>(punit->p+1))break;
}
WinEndPaint(hps);
return (MRESULT) NULL;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 100:
/* invoke config */
WinDlgBox(HWND_DESKTOP,(HWND)mp2,(PFNWP)cpudlgproc,hmod,800,(PVOID)punit);
break;
}
return (MRESULT) NULL;
case WM_DESTROY:
DosFreeMem(punit); /* free unit memory */
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

void cpumonregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szCpuClass);
pwc->ulCfgSize = sizeof(UNITCPU)-1026;
pwc->ulSafeAlloc = sizeof(UNITCPU);
pwc->bInitalUnitWidthPercent = 10;
WinRegisterClass(habMain,(PSZ)szCpuClass,(PFNWP)cpuwndproc,CS_SIZEREDRAW,8L);
hptrCpuIcon = WinLoadPointer(HWND_DESKTOP,hmod,302);
}
