/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                           Default Plugin Module                          *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

/* Clock */

#include "..\systray.h"
#include <dos.h>
#include <ctype.h>
#include "plugin.h"

char    szClockClass[] = "SystrayClockClass";

typedef struct _UNITCLOCK {
UNIT    u;
BYTE    bZero;
//LONG    lfc,lbc;
//CHAR    szFont[80];
UPPR    uppr;
BOOL    bShowSeconds;
BOOL    b12Hour;
BOOL    bShowDate;
} UNITCLOCK;

typedef UNITCLOCK *PUNITCLOCK;

extern HAB     habMain;
extern HMODULE hmod;

// clock unit dialog proc

MRESULT EXPENTRY clockdlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
static PUNITCLOCK punit;
switch(msg)
{
case WM_INITDLG:
punit = (PUNITCLOCK) mp2;
WinCheckButton(hwnd,102,punit->bShowSeconds);
WinCheckButton(hwnd,103,punit->b12Hour);
WinCheckButton(hwnd,104,punit->bShowDate);
break;
case WM_COMMAND:
switch((SHORT)mp1)
{
case DID_OK:
punit->bShowSeconds=WinQueryButtonCheckstate(hwnd,102);
punit->b12Hour=WinQueryButtonCheckstate(hwnd,103);
punit->bShowDate=WinQueryButtonCheckstate(hwnd,104);
break;
}
break;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

// clock unit window proc

char *months[]={"Jan","Feb","Mar","Apr","May","Jun",
                "Jul","Aug","Sep","Oct","Nov","Dec"};
char *dayowk[]={"Sunday","Monday","Tuesday","Wednesday",
                "Thursday","Friday","Saturday"};

void	gettime(char *buf,PUNITCLOCK punit)
{
struct dostime_t mytime;
struct dosdate_t mydate;
_dos_gettime(&mytime);
if(punit->bShowSeconds)
{
if(!punit->b12Hour) sprintf(buf,"%02d:%02d:%02d",
	mytime.hour,
	mytime.minute,
	mytime.second);
else sprintf(buf,"%02d:%02d:%02d%cm",
	((mytime.hour==0)||(mytime.hour==12)) ? 12 : mytime.hour%12,
	mytime.minute,
	mytime.second,
	mytime.hour>11 ? 'p' : 'a');
}
else
{
if(!punit->b12Hour)
sprintf(buf,"%02d%c%02d",
	mytime.hour,
	(mytime.second&1) ? ':' : ' ',
	mytime.minute);
else
sprintf(buf,"%02d%c%02d%cm",
	((mytime.hour==0)||(mytime.hour==12)) ? 12 : mytime.hour%12,
	(mytime.second&1) ? ':' : ' ',
	mytime.minute,
	mytime.hour>11 ? 'p' : 'a');
}
if(punit->bShowDate)
{
_dos_getdate(&mydate);
sprintf(buf,"%s %s, %d",buf,months[mydate.month-1],mydate.day);
}
}

MRESULT EXPENTRY clockwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
struct dosdate_t mydate;
PUNITCLOCK punit;
HPS hps;
RECTL rcl;
char buf[80];
punit = (PUNITCLOCK)WinQueryWindowULong(hwnd,0L);
switch(msg)
{
case WM_CREATE:
punit = (PUNITCLOCK)mp1;
WinSetWindowULong(hwnd,0L,(ULONG)punit);
if(!punit->bZero)
{
punit->uppr.fgColor = 0L;
punit->uppr.bgColor = 0x00CCCCCCL;
strcpy(punit->uppr.szFont,"8.Helv");
punit->bShowSeconds = TRUE;
punit->b12Hour = TRUE;
punit->bShowDate = FALSE;
punit->bZero = 1;
}

_dos_getdate(&mydate);

sprintf(punit->u.szBubble,
        "%s %d, %s",
        months[mydate.month-1],
        mydate.day,
        dayowk[mydate.dayofweek]);

SetUnitPresParam(hwnd,&punit->uppr);

WinStartTimer(habMain, hwnd, 1, 1000);

/* set bubble help buffer pointer */

WinSendMsg(WinQueryWindow(hwnd,QW_PARENT),WM_USER,(MPARAM)hwnd,
           (MPARAM)punit->u.szBubble);
break;
case WM_TIMER:
GetUnitPresParam(hwnd, &punit->uppr);
gettime(buf, punit);

hps = WinGetPS(hwnd);

GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);

DrawUnitIconText(hps, &rcl, NULLHANDLE, buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);

WinReleasePS(hps);

_dos_getdate(&mydate);

sprintf(punit->u.szBubble,
    	"%s %d, %s",
        months[mydate.month-1],
        mydate.day,
        dayowk[mydate.dayofweek]);
break;
case WM_SIZE:
break;
case WM_PAINT:
GetUnitPresParam(hwnd, &punit->uppr);
gettime(buf, punit);

hps = WinBeginPaint(hwnd, NULL, NULL);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
WinQueryWindowRect(hwnd, &rcl);
DrawUnitIconText(hps, &rcl, NULLHANDLE, buf,
                 punit->uppr.bgColor, punit->uppr.fgColor);
WinEndPaint(hps);
return (MRESULT) NULL;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 100:
/* invoke configuration dialog */
WinDlgBox(HWND_DESKTOP,(HWND)mp2,(PFNWP)clockdlgproc,hmod,100,(PVOID)punit);
break;
}
return (MRESULT) NULL;
case WM_DESTROY:
DosFreeMem(punit); /* free unit memory */
break;
}
return WinDefWindowProc(hwnd,msg,mp1,mp2);
}

void clockregisterclass(PWCLASS pwc)
{
strcpy(pwc->szName,szClockClass);
pwc->ulCfgSize = sizeof(UNITCLOCK);
pwc->ulSafeAlloc = sizeof(UNITCLOCK);
pwc->bInitalUnitWidthPercent = 10;
WinRegisterClass(habMain,(PSZ)szClockClass,(PFNWP)clockwndproc,CS_SIZEREDRAW,4L);
}
