/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

#define SZVER	    "Systray II, v.1.0.15 Beta 3"

#define IDR_SYSTRAY 1000

#define IDR_CONFIG  100
#define IDR_COFIRST 101
#define IDR_COLAST  102

#define IDC_CONFIG  0x100 /* Yeah. I like hex numbering */
#define IDC_PRODUCT 0x101
#define IDC_EXIT    0x102
#define IDC_PLUGINS 0x103
#define IDC_PLUGINA 0x105
#define IDC_UNITS   0x104

#define INCL_WIN /* Include Windowing */
#define INCL_GPI /* */
#define INCL_DOS /* We need for DosLoadModule */

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PATH   250
#define MAX_CLASS  200

/* Plugin */

typedef struct _PLUGIN {
CHAR    szModule[MAX_PATH]; /* Full plugin module path */
HMODULE hmod; /* module handle (used internally and not stored in cfg) */
} PLUGIN;

typedef PLUGIN *PPLUGIN;

typedef struct _WCLASS {
CHAR    szName[MAX_PATH];
ULONG   ulCfgSize;
ULONG   ulSafeAlloc;
BYTE    bInitalUnitWidthPercent;
} WCLASS;

typedef WCLASS *PWCLASS;

typedef struct _UNIT {
ULONG   cbFix;
CHAR    szClass[MAX_CLASS];
CHAR    szBubble[MAX_CLASS];
HWND    hwnd;
SHORT   sFlags;
ULONG   ulRefresh;
SHORT   sBottom,sLeft,sHeight,sWidth;
ULONG   ulReserved[4];
PFNWP   pfnOld;
} UNIT;

//#define UF_ONCE    0x0001 //
//#define UF_FIXED   0x0002 // fixed in size

//#define WM_UNITMSG WM_USER+0x100
//#define UM_CONFIG  WM_UNITMSG
//#define UM_RESET   WM_UNITMSG+1

typedef UNIT *PUNIT;

/* Config */

typedef struct _MAINCFG {
BYTE b;
BOOL bThin;
BOOL bOntop;
BOOL bFix;
BOOL bResizeDesktop;
BYTE byFix;
BYTE byRes;
} MAINCFG;

typedef MAINCFG *PMAINCFG;

HWND             setupunit(PUNIT pUnit,ULONG id);
VOID             saveunitcfg();
VOID             reorderunits();

VOID             maininitplugins();
VOID             maininitclasses();
VOID             maininitunits();

MRESULT EXPENTRY mainwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

VOID             configdefault();
VOID             configload();
VOID             configsave();
VOID             configdlg();
VOID             addplugin();

MRESULT EXPENTRY pluginpageproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);
MRESULT EXPENTRY unitpageproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

void    profile_close();
void    profile_open(char *inifile);
void    profile_loadint(char *key,int *i);
void    profile_loadushort(char *key,PUSHORT u);
void    profile_loadblob(char *key,PVOID blob,ULONG ulSize);
void    profile_loadstring(char *key,PSZ pszData);
void    profile_saveint(char *key,int *i);
void    profile_saveushort(char *key,PUSHORT u);
void    profile_saveblob(char *key,PVOID blob,ULONG ulSize);
void    profile_savestring(char *key,PSZ pszData);

MRESULT EXPENTRY cfgdlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

#ifdef SYSTRAY_C
CHAR    szMainClass[]="Systray2.MainWindow";
#endif
