/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/


#define  SYSTRAY_C
#include "systray.h"

/* Some global vars */

HAB  hab; /* anchor block */
HWND hwnd_main,hwnd_main_client;

/* main config */

MAINCFG mainCfg;

/* plugin initializers */

PLUGIN  PlugIn[200]; // who needs more??? say to me if you want
USHORT  usPlugins=0;

VOID    maininitplugins()
{
USHORT i;
char szError[256];
//f=fopen("plugins","");
profile_loadushort("ushort.plugins",&usPlugins);
profile_loadblob("blob.plugin",(PVOID)&PlugIn[0],usPlugins*sizeof(PLUGIN));
for(i=0;i<usPlugins;i++)
{
PlugIn[i].hmod = NULLHANDLE;
DosLoadModule(szError,256,PlugIn[i].szModule,&PlugIn[i].hmod);
/* ignore error - we dont need to handle it there */
}
}

/* plugin classes initializer */

BOOL (APIENTRY *pluginRegisterProc)(HMODULE,HAB,PWCLASS,PUSHORT);
VOID dummy(/* *** */){/* *** */}

WCLASS wClass[200]; // WHO???   ;-)
USHORT usClasses=0;

CHAR   szFuncName[] = "REGISTERPLUGINPROC";

VOID    maininitclasses()
{
USHORT i,t;
for(i=0;i<usPlugins;i++)
{
/* plugin check */
if(!PlugIn[i].hmod) continue;
/* quering procedure address */
pluginRegisterProc = NULL;
DosQueryProcAddr(PlugIn[i].hmod,0L,szFuncName,(PFN*)&pluginRegisterProc);
if(!pluginRegisterProc)
{
DosBeep(700,10);
continue;
}
/* executing it */
t=200-usClasses;
pluginRegisterProc(PlugIn[i].hmod,hab,&wClass[usClasses],&t);
usClasses+=t;
/* classes registered & stored in our structure */
}
}

/* units initializer procedure */

//UNIT    unit[64]; // well... umm... DON^T hit me! ;-)
PUNIT   pUnits[200];
USHORT  usUnits=0;
ULONG   ulCbUnits[200];

VOID    reorderunits()
{
USHORT i,x=4;
SWP swp;
RECTL rcl;
WinQueryWindowRect(hwnd_main_client,&rcl);
for(i=0;i<usUnits;i++)
{
WinQueryWindowPos(pUnits[i]->hwnd,&swp);
WinSetWindowPos(pUnits[i]->hwnd,HWND_TOP,x,4,swp.cx,rcl.yTop-8,SWP_MOVE | SWP_SIZE);
pUnits[i]->sWidth=swp.cx;
pUnits[i]->sLeft=x;
x+=swp.cx+2;
}
WinInvalidateRect(hwnd_main_client,&rcl,TRUE);
}

VOID	ajustsize()
{
RECTL rcl;
USHORT usIconSize;
WinQueryWindowRect(HWND_DESKTOP,&rcl);
if(!mainCfg.byRes)
WinSetWindowPos(hwnd_main,HWND_TOP,0,0,rcl.xRight,30,SWP_SIZE);
else if(mainCfg.byRes==1)
WinSetWindowPos(hwnd_main,HWND_TOP,0,0,rcl.xRight,34,SWP_SIZE);
else
{
usIconSize = WinQuerySysValue( HWND_DESKTOP, SV_CXICON );
WinSetWindowPos(hwnd_main,HWND_TOP,0,0,rcl.xRight,usIconSize+14,SWP_SIZE);
}
}

BOOL    checkunitborder(PHWND phwnd)
{
POINTL ptl;
USHORT i;
SWP swp;
WinQueryPointerPos(HWND_DESKTOP, &ptl) ;
WinMapWindowPoints(HWND_DESKTOP,hwnd_main_client,&ptl,1) ;
for(i=0;i<usUnits;i++)
{
WinQueryWindowPos(pUnits[i]->hwnd,&swp);
//WinSetWindowPos(pUnits[i]->hwnd,HWND_TOP,x,4,swp.cx,22,SWP_MOVE | SWP_SIZE);
//x+=swp.cx+2;
if((ptl.x==(swp.x-1+swp.cx))||(ptl.x==(swp.x+swp.cx)))
{
*phwnd = pUnits[i]->hwnd;
return TRUE;
}
}
return FALSE;
}


HWND    setupunit(PUNIT pUnit, ULONG id)
{
// CREATESTRUCT
return WinCreateWindow(hwnd_main_client,pUnit->szClass,
                       pUnit->szBubble,WS_VISIBLE,
                       pUnit->sLeft+4,4,
                       pUnit->sWidth,22,
                       hwnd_main_client,HWND_TOP,id,
                       (PVOID)pUnit,(PVOID)NULL);
}

VOID    maininitunits()
{
USHORT i,j;
ULONG  ulTotal=0L;
PUNIT  punit;
PVOID  ptemp,ptmp2;
profile_loadushort("ushort.units",&usUnits);
profile_loadblob("aulong.cbunits",&ulCbUnits[0],sizeof(ULONG)*usUnits);
for(i=0;i<usUnits;i++)
{
//DosAllocMem(&pUnits[i],,PAG_COMMIT | PAG_READ | PAG_WRITE);
ulTotal += ulCbUnits[i];
}
ptemp = malloc(ulTotal);
ptmp2 = ptemp;
profile_loadblob("blob.unit",ptemp,ulTotal);
for(i=0;i<usUnits;i++)
{
punit = (PUNIT)ptemp;
for(j=0;j<usClasses;j++)
if(!strcmp(punit->szClass,wClass[j].szName))
{
DosAllocSharedMem(&pUnits[i],NULL,wClass[j].ulSafeAlloc,
                  PAG_COMMIT   | PAG_READ     | PAG_WRITE |
                  OBJ_GIVEABLE );
break;
}
ptemp = (PVOID)((ULONG)ptemp+ulCbUnits[i]);
}
ptemp = ptmp2;
for(i=0;i<usUnits;i++)
{
memcpy(pUnits[i],ptemp,ulCbUnits[i]);
ptemp = (PVOID)((ULONG)ptemp+ulCbUnits[i]);

pUnits[i]->hwnd = setupunit(pUnits[i],i+10000);
if(!pUnits[i]->hwnd)DosBeep(1000,100);
/* ok, unit windows created, what's next??? */
}
free(ptmp2);
}

/* main procedure */

VOID main(int argc,char *argv[])
{
HMQ hmq; // queue handle
QMSG qmsg; // in-queue message
ULONG ulFrame=FCF_TASKLIST | FCF_NOBYTEALIGN;
RECTL rcl;
USHORT wx=0,wy=0;

// initialize pm
hab=WinInitialize(0);
hmq=WinCreateMsgQueue(hab,0);
if((!hab)||(!hmq)) DosExit(1,-1);

// register main window class & create window
WinRegisterClass(hab,(PSZ)szMainClass,(PFNWP)mainwndproc,CS_SIZEREDRAW,0);
if(argc>1) profile_open(argv[1]);
else       profile_open("systray2.ini");

maininitplugins();
maininitclasses();
//maininitunits();

hwnd_main=WinCreateStdWindow(HWND_DESKTOP,0,&ulFrame,szMainClass,"Systray",
                             0,NULLHANDLE,IDR_SYSTRAY-1,&hwnd_main_client);

// set frame position
profile_loadushort("ushort.wx",&wx);
profile_loadushort("ushort.wy",&wy);
profile_loadblob("blob.maincfg",&mainCfg,sizeof(MAINCFG));
ajustsize();
WinSetWindowPos(hwnd_main,HWND_TOP,wx,wy,0,0,SWP_MOVE | SWP_SHOW | SWP_ACTIVATE | SWP_ZORDER);
maininitunits();
reorderunits();

// dispatch all messages
while(WinGetMsg(hab,&qmsg,0,0,0)) WinDispatchMsg(hab,&qmsg);

profile_close();

// destroy main window
WinDestroyWindow(hwnd_main);
// destroy handles
WinDestroyMsgQueue(hmq);
WinTerminate(hab);

//DosExit(1,0); // terminate app normally
}

TRACKINFO tiStruct;

void trackwindow(HWND hwnd, PRECTL prcl)
{
SWP swp;
WinSetFocus(HWND_DESKTOP,hwnd);
WinQueryWindowPos(hwnd,&swp);
WinSetRect(hab, &tiStruct.rclTrack, swp.x, swp.y, swp.x+swp.cx, swp.y+swp.cy);
tiStruct.cxBorder = 2;
tiStruct.cyBorder = 2;
tiStruct.cxGrid = 0;
tiStruct.cyGrid = 0;
memcpy(&tiStruct.rclBoundary,prcl,sizeof(RECTL));
tiStruct.ptlMinTrackSize.x = 4;
tiStruct.ptlMinTrackSize.y = tiStruct.rclBoundary.yTop-8;
tiStruct.ptlMaxTrackSize.y = tiStruct.rclBoundary.yTop-8;
tiStruct.ptlMaxTrackSize.x = tiStruct.rclBoundary.xRight-tiStruct.rclBoundary.xLeft;
tiStruct.fs = TF_STANDARD | TF_ALLINBOUNDARY | TF_RIGHT | TF_BOTTOM;
WinTrackRect(hwnd_main_client, (HPS)0L, &tiStruct);
memcpy(prcl,&tiStruct.rclTrack,sizeof(RECTL));
}


MRESULT EXPENTRY mainwndproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
SWP swp;
HWND hwndt;
HPS hps;
RECTL rcl;
switch (msg)
{
case	WM_DESTROY:
case	WM_SAVEAPPLICATION:
saveunitcfg();
break;
case    WM_BUTTON2CLICK:
{
POINTL ptl;
HWND   hwndMenu;

hwndMenu = WinLoadMenu(hwnd_main,NULLHANDLE,IDR_SYSTRAY);
WinQueryPointerPos(HWND_DESKTOP, &ptl);
WinMapWindowPoints(HWND_DESKTOP,hwnd,&ptl,1);
WinPopupMenu(hwnd, hwnd, hwndMenu, ptl.x, ptl.y, 0, PU_HCONSTRAIN   | PU_VCONSTRAIN |
                                                    PU_MOUSEBUTTON1 | PU_KEYBOARD);
//WinDestroyWindow(hwndMenu);
break;
}
case WM_MOUSEMOVE:
if(checkunitborder(&hwndt))
WinSetPointer(HWND_DESKTOP,WinQuerySysPointer(HWND_DESKTOP,SPTR_SIZEWE,FALSE));
else
WinSetPointer(HWND_DESKTOP,WinQuerySysPointer(HWND_DESKTOP,SPTR_ARROW,FALSE));
return (MRESULT)0L;

case WM_BUTTON1DOWN:
/* move window using mouse button 1 */
if(checkunitborder(&hwndt))
{
rcl.yTop-=4;rcl.xRight-=4;rcl.xLeft+=4;rcl.yBottom+=4;
WinQueryWindowRect(hwnd, &rcl);
trackwindow(hwndt,&rcl);
WinSetWindowPos(hwndt,HWND_DESKTOP,0,0,rcl.xRight-rcl.xLeft,rcl.yTop-rcl.yBottom,SWP_SIZE);
reorderunits();
return (MRESULT)0L;
}
else  if(!mainCfg.bFix)
return WinSendMsg(hwnd_main, WM_TRACKFRAME,MPFROMSHORT((USHORT)mp2 | TF_MOVE),MPVOID);

case WM_CREATE:
WinStartTimer(hab, hwnd, 1, 1000);
break;

case WM_TIMER:
if(mainCfg.bOntop)
WinSetWindowPos(hwnd_main,HWND_TOP,0,0,0,0,SWP_ZORDER);
break;

case WM_PAINT:
hps = WinBeginPaint (hwnd, NULL, NULL);
WinQueryWindowRect(hwnd, &rcl);
if(!mainCfg.bThin)
{
WinDrawBorder(hps,&rcl,2,2,CLR_WHITE,CLR_DARKGRAY,0x400);
rcl.yTop-=2;rcl.xRight-=2;rcl.xLeft+=2;rcl.yBottom+=2;
}
else
{
WinDrawBorder(hps,&rcl,1,1,CLR_WHITE,CLR_DARKGRAY,0x400);
rcl.yTop--;rcl.xRight--;rcl.xLeft++;rcl.yBottom++;
}
WinFillRect(hps, &rcl, SYSCLR_BUTTONMIDDLE);
WinEndPaint(hps);
return (MRESULT)0;

case WM_CLOSE:
WinQueryWindowPos(hwnd_main,&swp);
profile_saveushort("ushort.wx",(PUSHORT)&swp.x);
profile_saveushort("ushort.wy",(PUSHORT)&swp.y);
WinPostMsg(hwnd, WM_QUIT, (MPARAM)0, (MPARAM)0);
return (MRESULT)0;

case WM_USER:
setbubble((HWND)mp1,(PSZ)mp2);
break;

case WM_COMMAND:
switch((SHORT)mp1)
{
case IDC_CONFIG: // invoke settings
configdlg();
ajustsize();
reorderunits();
WinQueryWindowRect(hwnd_main,&rcl);
WinInvalidateRect(hwnd_main,&rcl,TRUE);
break;
case IDC_UNITS:
WinDlgBox(HWND_DESKTOP,hwnd_main,(PFNWP)unitpageproc,NULLHANDLE,200,NULL);
break;
case IDC_PLUGINS:
WinDlgBox(HWND_DESKTOP,hwnd_main,(PFNWP)pluginpageproc,NULLHANDLE,300,NULL);
break;
case IDC_PLUGINA:
addplugin();
break;
case IDC_EXIT:   // exit systray
saveunitcfg();   // urgent saving before exit
WinPostMsg(hwnd, WM_CLOSE, (MPARAM)0, (MPARAM)0);
}
break;

}

return WinDefWindowProc (hwnd, msg, mp1, mp2);
}


