/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

#include "systray.h"

extern  HAB hab;

HINI    hIni = HINI_USERPROFILE;

char    inifile[]="systray2.ini";
char    iniapp[]="NewSystray";

void    profile_open(char *inifile)
{
hIni = PrfOpenProfile(hab,inifile);
}

void    profile_close()
{
PrfCloseProfile(hIni);
}

void    profile_loadint(char *key,int *i)
{
ULONG ul = sizeof(int);
PrfQueryProfileData(hIni,iniapp,key,(PVOID)i,&ul);
}

void    profile_loadushort(char *key,PUSHORT u)
{
ULONG ul = sizeof(USHORT);
PrfQueryProfileData(hIni,iniapp,key,(PVOID)u,&ul);
}

void    profile_loadblob(char *key,PVOID blob,ULONG ulSize)
{
PrfQueryProfileData(hIni,iniapp,key,blob,&ulSize);
}

void    profile_loadstring(char *key,PSZ pszData)
{
ULONG ul = 256L;
PrfQueryProfileString(hIni,iniapp,key,NULL,pszData,ul);
}

/**/

void    profile_saveint(char *key,int *i)
{
ULONG ul = sizeof(int);
PrfWriteProfileData(hIni,iniapp,key,(PVOID)i,ul);
}

void    profile_saveushort(char *key,PUSHORT u)
{
ULONG ul = sizeof(USHORT);
PrfWriteProfileData(hIni,iniapp,key,(PVOID)u,ul);
}

void    profile_saveblob(char *key,PVOID blob,ULONG ulSize)
{
PrfWriteProfileData(hIni,iniapp,key,blob,ulSize);
}

void    profile_savestring(char *key,PSZ pszData)
{
PrfWriteProfileString(hIni,iniapp,key,pszData);
}
