/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

#include "systray.h"

extern HWND hwnd_main,hwnd_main_client;
extern MAINCFG mainCfg;
HWND hwnd_dlg;

void    configdlg()
{
WinDlgBox(HWND_DESKTOP,hwnd_main,(PFNWP)cfgdlgproc,
             NULLHANDLE,100,(PVOID)NULL);
}

int openfile(HWND hwnd,char *name,char *title)
{
   FILEDLG fileDialog;
   memset(&fileDialog,0,sizeof(FILEDLG));
   fileDialog.cbSize = sizeof(FILEDLG);

   fileDialog.pszTitle = title;
   fileDialog.fl = FDS_CENTER | FDS_OPEN_DIALOG;
   strcpy(fileDialog.szFullFile,name);
   if (!WinFileDlg(HWND_DESKTOP, hwnd, (PFILEDLG)&fileDialog))
       return 0;

   /*
    *  Upon sucessful return of a file, open it for reading
    */
   strcpy(name, fileDialog.szFullFile);
   if (fileDialog.lReturn == 1) return 1;
      else return 0;
}

/* our external var1ables */

extern WCLASS wClass[];
extern USHORT usClasses;
//extern UNIT   unit[]; // well... umm... DON^T hit me! ;-)
extern PUNIT  pUnits[];
extern USHORT usUnits;
extern ULONG  ulCbUnits[];

/* ----------------- */

VOID   saveunitcfg()
{
USHORT i;
ULONG ulTotal=0L;
PVOID ptemp,ptmp2;
for(i=0;i<usUnits;i++)
{
ulCbUnits[i] = pUnits[i]->cbFix;
ulTotal += ulCbUnits[i];
}
profile_saveblob("aulong.cbunits",&ulCbUnits[0],sizeof(ULONG)*usUnits);
ptemp = ptmp2 = malloc(ulTotal);
for(i=0;i<usUnits;i++)
{
memcpy(ptemp,pUnits[i],pUnits[i]->cbFix);
ptemp=(PVOID)((ULONG)ptemp+pUnits[i]->cbFix);
}
profile_saveblob("blob.unit",ptmp2,ulTotal);
free(ptmp2);
}

/* hehoo */

MRESULT EXPENTRY unitpageproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
SHORT i;
RECTL rcl;
PVOID ptmp;
char   buf[80];
switch(msg)
{
//case WM_CREATE:
case WM_INITDLG:
for(i=0;i<usClasses;i++)
WinSendDlgItemMsg(hwnd,206,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(wClass[i].szName));
for(i=0;i<usUnits;i++)
WinSendDlgItemMsg(hwnd,201,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(pUnits[i]->szClass));

WinCreateWindow(hwnd,WC_FRAME,"",0,0,0,3,3,NULLHANDLE,HWND_TOP,3,NULL,NULL);

break;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 210: // move unit up
i=(SHORT)WinSendDlgItemMsg(hwnd,201,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
if(i==0) break;
ptmp=pUnits[i-1];
pUnits[i-1]=pUnits[i];
pUnits[i]=ptmp;
WinSendDlgItemMsg(hwnd,201,LM_SELECTITEM,
                           MPFROMSHORT(i),(MPARAM)FALSE);
WinSendDlgItemMsg(hwnd,201,LM_SELECTITEM,
                           MPFROMSHORT(i-1),(MPARAM)TRUE);
WinSendDlgItemMsg(hwnd,201,LM_SETITEMTEXT,
                           MPFROMSHORT(i),MPFROMP(pUnits[i]->szClass));
WinSendDlgItemMsg(hwnd,201,LM_SETITEMTEXT,
                           MPFROMSHORT(i-1),MPFROMP(pUnits[i-1]->szClass));

reorderunits();
break;
case 211: // move unit down
i=(SHORT)WinSendDlgItemMsg(hwnd,201,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
if(i==usUnits-1) break;
ptmp=pUnits[i+1];
pUnits[i+1]=pUnits[i];
pUnits[i]=ptmp;
WinSendDlgItemMsg(hwnd,201,LM_SELECTITEM,
                           MPFROMSHORT(i),(MPARAM)FALSE);
WinSendDlgItemMsg(hwnd,201,LM_SELECTITEM,
                           MPFROMSHORT(i+1),(MPARAM)TRUE);
WinSendDlgItemMsg(hwnd,201,LM_SETITEMTEXT,
                           MPFROMSHORT(i),MPFROMP(pUnits[i]->szClass));
WinSendDlgItemMsg(hwnd,201,LM_SETITEMTEXT,
                           MPFROMSHORT(i+1),MPFROMP(pUnits[i+1]->szClass));
reorderunits();
break;
case 203: // unit configure.
i=(SHORT)WinSendDlgItemMsg(hwnd,201,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
WinSendMsg(pUnits[i]->hwnd,WM_COMMAND,(MPARAM)100L,MPFROMHWND(WinWindowFromID(hwnd,3)));
break;
case 204: // remove unit. Oh noooo!
i=(SHORT)WinSendDlgItemMsg(hwnd,201,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
WinDestroyWindow(pUnits[i]->hwnd);
if(i<(usUnits-1))
memcpy(&pUnits[i],&pUnits[i+1],(usUnits-i-1)*sizeof(PUNIT));
WinSendDlgItemMsg(hwnd,201,LM_DELETEITEM,
                  MPFROMSHORT(i),(MPARAM)0L);
usUnits--;
/*for(i=0;i<usUnits;i++)
WinSetWindowULong(unit[i].hwnd,QWL_USER,(ULONG)&unit[i]);*/
reorderunits();
break;
case 202: // New unit
i=(SHORT)WinSendDlgItemMsg(hwnd,206,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
WinSendDlgItemMsg(hwnd,206,LM_QUERYITEMTEXT,MPFROM2SHORT(i,80),MPFROMP(buf));
WinSendDlgItemMsg(hwnd,201,LM_INSERTITEM,MPFROMSHORT(LIT_END),MPFROMP(wClass[i].szName));
//pUnits[usUnits] = (PUNIT) malloc(60000);
DosAllocSharedMem(&pUnits[usUnits],NULL,wClass[i].ulSafeAlloc,
		  PAG_COMMIT | PAG_READ | PAG_WRITE |
                  OBJ_GETTABLE | OBJ_GIVEABLE);
memset(pUnits[usUnits],0,wClass[i].ulCfgSize);
pUnits[usUnits]->sBottom=0;
pUnits[usUnits]->sLeft=usUnits*70;
WinQueryWindowRect(hwnd_main_client,&rcl);
pUnits[usUnits]->sHeight=rcl.yTop;
pUnits[usUnits]->sWidth=((LONG)wClass[i].bInitalUnitWidthPercent*(rcl.xRight-8))/100L;
pUnits[usUnits]->cbFix=wClass[i].ulCfgSize;
strcpy(pUnits[usUnits]->szClass,wClass[i].szName);
pUnits[usUnits]->hwnd = setupunit(pUnits[usUnits],usUnits+10000);
if(!pUnits[usUnits]->hwnd)DosBeep(1000,100);
else usUnits++;
reorderunits();
break;
}
return (MRESULT)0L;
case WM_DESTROY:
profile_saveushort("ushort.units",&usUnits);
/*profile_saveblob("blob.unit",(PVOID)&unit[0],usUnits*sizeof(UNIT));*/
saveunitcfg();
return (MRESULT)0L;
case WM_CLOSE:
WinDismissDlg(hwnd,0L);
return (MRESULT) 0L;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

extern USHORT usPlugins;
extern PLUGIN PlugIn[];

char szbuf[80];
MRESULT EXPENTRY pluginpageproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
USHORT i;
switch(msg)
{
case WM_INITDLG:
//case WM_CREATE:
for(i=0;i<usPlugins;i++)
WinSendDlgItemMsg(hwnd,301,LM_INSERTITEM,MPFROMSHORT(LIT_END),
                  MPFROMP(PlugIn[i].szModule));
WinCreateWindow(hwnd,WC_FRAME,"",0,0,0,3,3,NULLHANDLE,HWND_TOP,3,NULL,NULL);
break;
case WM_COMMAND:
switch((SHORT)mp1)
{
case 304: // unload plugin
i=(SHORT)WinSendDlgItemMsg(hwnd,301,LM_QUERYSELECTION,
                           MPFROMSHORT(LIT_FIRST),(MPARAM)0L);
if(i==LIT_NONE) break;
usPlugins--;
memcpy(&PlugIn[i],&PlugIn[i+1],usPlugins-i);
WinSendDlgItemMsg(hwnd,301,LM_DELETEITEM,
                  MPFROMSHORT(i),(MPARAM)0L);
WinMessageBox(HWND_DESKTOP,hwnd_main_client,"Please restart Systray II to take effect.",
              "Unload plugin",0,MB_INFORMATION | MB_OK);
break;
case 302: // add plugin
//WinSendDlgItemMsg(hwnd,201,LM_INSERTITEM,MPFROMSHORT(LIT_END),MPFROMP("New item!"));
strcpy(szbuf,"*.DLL");
if(!openfile(WinWindowFromID(hwnd,3),szbuf,"Open plugin library"))
break;
WinSendDlgItemMsg(hwnd,301,LM_INSERTITEM,MPFROMSHORT(LIT_END),MPFROMP(szbuf));
strcpy(PlugIn[usPlugins].szModule,szbuf);
usPlugins++;
break;
}
return (MRESULT) TRUE;
case WM_DESTROY:
profile_saveushort("ushort.plugins",&usPlugins);
profile_saveblob("blob.plugin",(PVOID)&PlugIn[0],usPlugins*sizeof(PLUGIN));
return (MRESULT)0L;
case WM_CLOSE:
WinDismissDlg(hwnd,0L);
return (MRESULT) 0L;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

MRESULT EXPENTRY mainpageproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
USHORT i;
switch(msg)
{
case WM_INITDLG:
if(mainCfg.byRes==0)WinCheckButton(hwnd,502,TRUE);
if(mainCfg.byRes==1)WinCheckButton(hwnd,503,TRUE);
if(mainCfg.byRes==2)WinCheckButton(hwnd,504,TRUE);
if(mainCfg.byFix==0)WinCheckButton(hwnd,510,TRUE);
if(mainCfg.byFix==1)WinCheckButton(hwnd,511,TRUE);
if(mainCfg.byFix==2)WinCheckButton(hwnd,514,TRUE);
WinCheckButton(hwnd,506,mainCfg.bThin);
WinCheckButton(hwnd,507,mainCfg.bOntop);
WinCheckButton(hwnd,509,mainCfg.bFix);
WinCheckButton(hwnd,512,mainCfg.bResizeDesktop);
break;
case WM_DESTROY:
mainCfg.bThin=WinQueryButtonCheckstate(hwnd,506);
mainCfg.bOntop=WinQueryButtonCheckstate(hwnd,507);
mainCfg.bFix=WinQueryButtonCheckstate(hwnd,509);
mainCfg.bResizeDesktop=WinQueryButtonCheckstate(hwnd,512);
if(WinQueryButtonCheckstate(hwnd,502))mainCfg.byRes=0;
if(WinQueryButtonCheckstate(hwnd,503))mainCfg.byRes=1;
if(WinQueryButtonCheckstate(hwnd,504))mainCfg.byRes=2;

if(WinQueryButtonCheckstate(hwnd,510))mainCfg.byFix=0;
if(WinQueryButtonCheckstate(hwnd,511))mainCfg.byFix=1;
if(WinQueryButtonCheckstate(hwnd,514))mainCfg.byFix=2;
profile_saveblob("blob.maincfg",&mainCfg,sizeof(MAINCFG));
return (MRESULT)0L;
case WM_CLOSE:
WinDismissDlg(hwnd,0L);
return (MRESULT) 0L;
case WM_COMMAND:
return (MRESULT) 0L;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}


VOID    addplugin()
{
strcpy(szbuf,"*.DLL");
if(!openfile(hwnd_main,szbuf,"Add plugin"))
return;

strcpy(PlugIn[usPlugins].szModule,szbuf);
usPlugins++;
}

void    initnotebook(HWND hwnd,HWND hwndnb)
{
long id;
HWND hwndDlg;
/* noteboox dimesions */
WinSendMsg(hwndnb,BKM_SETDIMENSIONS,MPFROM2SHORT(76,20),MPFROMSHORT(BKA_MAJORTAB));

/* zero page */

id = (long)WinSendMsg(hwndnb,BKM_INSERTPAGE, NULL,MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | BKA_MAJOR),BKA_LAST));
hwndDlg = WinLoadDlg(hwndnb,hwndnb,(PFNWP)mainpageproc,NULLHANDLE,500,(PVOID)NULL);
WinSendMsg(hwndnb,BKM_SETTABTEXT, MPFROMLONG(id),MPFROMP("Main"));
WinSendMsg(hwndnb,BKM_SETSTATUSLINETEXT, MPFROMLONG(id),MPFROMP("Page 1/4"));
WinSendMsg(hwndnb,BKM_SETPAGEWINDOWHWND, MPFROMLONG(id),MPFROMHWND(hwndDlg));


/* first page */

id = (long)WinSendMsg(hwndnb,BKM_INSERTPAGE, NULL,MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | BKA_MAJOR),BKA_LAST));
hwndDlg = WinLoadDlg(hwndnb,hwndnb,(PFNWP)unitpageproc,NULLHANDLE,200,(PVOID)NULL);
WinSendMsg(hwndnb,BKM_SETTABTEXT, MPFROMLONG(id),MPFROMP("Units"));
WinSendMsg(hwndnb,BKM_SETSTATUSLINETEXT, MPFROMLONG(id),MPFROMP("Page 2/4"));
WinSendMsg(hwndnb,BKM_SETPAGEWINDOWHWND, MPFROMLONG(id),MPFROMHWND(hwndDlg));

/* second page */

hwndDlg = WinLoadDlg(hwndnb,hwndnb,(PFNWP)pluginpageproc,NULLHANDLE,300,(PVOID)NULL);
id = (long)WinSendMsg(hwndnb,BKM_INSERTPAGE, NULL,MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | BKA_MAJOR),BKA_LAST));
WinSendMsg(hwndnb,BKM_SETTABTEXT, MPFROMLONG(id),MPFROMP("Plugins"));
WinSendMsg(hwndnb,BKM_SETSTATUSLINETEXT, MPFROMLONG(id),MPFROMP("Page 3/4"));
WinSendMsg(hwndnb,BKM_SETPAGEWINDOWHWND, MPFROMLONG(id),MPFROMHWND(hwndDlg));

/* third page */

hwndDlg = WinLoadDlg(hwndnb,hwndnb,(PFNWP)NULL,NULLHANDLE,400,(PVOID)NULL);
id = (long)WinSendMsg(hwndnb,BKM_INSERTPAGE, NULL,MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | BKA_MAJOR),BKA_LAST));
WinSendMsg(hwndnb,BKM_SETTABTEXT, MPFROMLONG(id),MPFROMP("About Systray II"));
WinSendMsg(hwndnb,BKM_SETSTATUSLINETEXT, MPFROMLONG(id),MPFROMP("Page 4/4"));
WinSendMsg(hwndnb,BKM_SETPAGEWINDOWHWND, MPFROMLONG(id),MPFROMHWND(hwndDlg));
WinSetWindowText(WinWindowFromID(hwndDlg,411),SZVER);
}

MRESULT EXPENTRY cfgdlgproc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
hwnd_dlg = hwnd;
//hwnd_dlg = WinWindowFromID(hwnd,101);
initnotebook(hwnd,WinWindowFromID(hwnd,101));
break;
case WM_CLOSE:
/*profile_saveushort("ushort.plugins",&usPlugins);
profile_saveblob("blob.plugin",(PVOID)&PlugIn[0],usPlugins*sizeof(PLUGIN));
profile_saveushort("ushort.units",&usUnits);
profile_saveblob("blob.unit",(PVOID)&unit[0],usUnits*sizeof(UNIT));
saveunitcfg();*/
break;
}
return WinDefDlgProc(hwnd,msg,mp1,mp2);
}
