/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************/

#include "systray.h"

HWND hwndLastBubble,hwndLastWindow;
extern HAB hab;

CHAR ppFont[]="8.Helv";
CHAR szTextbuf[256];
ULONG ulColor=CLR_YELLOW;

void  BackSpace(char *t)
{
   char *p;
   if (!strlen(t))return;
   p = t+strlen(t)-1;
   while (*p==' ')
   {
      if (p==t)break;
      *p='\0';
      p--;
   }
   p=t;
   while (*p)
   {
      if ((*p==13) || (*p==10))*p=' ';
      p++;
   }
}


MRESULT EXPENTRY bubblewndproc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
PSZ pszText;
PFNWP oldproc;

   pszText = (PSZ)WinQueryWindowULong(WinWindowFromID(hwnd,9999), QWL_PENDATA);
   oldproc = (PFNWP)WinQueryWindowULong(WinWindowFromID(hwnd,9999), QWL_USER);

   switch ( msg )
   {
      case WM_TIMER:
         if ((USHORT)mp1 == 100)
         {
            if (hwndLastBubble)
            {
               WinStopTimer(hab, hwnd, 100);
               WinDestroyWindow(hwndLastBubble);
               hwndLastBubble = 0;
               hwndLastWindow = 0;
            }
         }
         break;
      case WM_MOUSEMOVE:
         {
            HPS hpsTemp;
            HWND hwndBubbleClient;
            ULONG ulStyle = FCF_BORDER | FCF_NOBYTEALIGN;
            LONG  lWidth,lHight;
            POINTL txtPointl[TXTBOX_COUNT],ptlWork={0,0};
            if (hwndLastWindow == hwnd) break;
            if (hwndLastBubble)
            {
               WinStopTimer(hab, hwndLastWindow, 100);
               WinDestroyWindow(hwndLastBubble);
               hwndLastBubble = 0;
            }
            hwndLastBubble = WinCreateStdWindow(HWND_DESKTOP,0,
                                                &ulStyle, WC_STATIC,"", SS_TEXT | DT_LEFT |  DT_VCENTER,
                                                NULLHANDLE, 2,&hwndBubbleClient);
            WinSetPresParam(hwndBubbleClient, PP_FONTNAMESIZE,sizeof(ppFont),
                            ppFont);
            WinSetPresParam(hwndBubbleClient, PP_BACKGROUNDCOLORINDEX,sizeof(ulColor),
                            &ulColor);

            hpsTemp = WinGetPS(hwndBubbleClient);

         //   WinQueryWindowText(hwnd, 255, szTextbuf);
            strcpy(szTextbuf, pszText);
            BackSpace(szTextbuf);
            GpiQueryTextBox(hpsTemp, strlen(szTextbuf),
                            szTextbuf, TXTBOX_COUNT,
                            (PPOINTL)&txtPointl[0]);
            WinReleasePS(hpsTemp);

            WinSetWindowText(hwndBubbleClient,szTextbuf);

            lWidth = txtPointl[TXTBOX_TOPRIGHT].x -
                     txtPointl[TXTBOX_TOPLEFT ].x + 3;

            lHight = txtPointl[TXTBOX_TOPLEFT   ].y -
                     txtPointl[TXTBOX_BOTTOMLEFT].y + 3;

            WinMapWindowPoints(hwnd, HWND_DESKTOP, &ptlWork, 1);

            if((ptlWork.y+30)<WinQuerySysValue(HWND_DESKTOP,SV_CYFULLSCREEN))
            ptlWork.y += 30;
            else ptlWork.y-=24;

            if ((ptlWork.x+lWidth) >= WinQuerySysValue (HWND_DESKTOP,SV_CXFULLSCREEN))
               ptlWork.x = WinQuerySysValue (HWND_DESKTOP,SV_CXFULLSCREEN) - lWidth - 1;

            WinSetWindowPos(hwndLastBubble,HWND_TOP,ptlWork.x,ptlWork.y,
                            lWidth,lHight,SWP_SHOW | SWP_MOVE | SWP_SIZE);
            hwndLastWindow = hwnd;

            WinStartTimer(hab, hwnd, 100, 4000);
         }
         break;
      case WM_DESTROY:
         if ((hwndLastWindow == hwnd) && hwndLastBubble)
         {
            WinStopTimer(hab, hwnd, 100);
            WinDestroyWindow(hwndLastBubble);
            hwndLastBubble = 0;
            hwndLastWindow = 0;
         }
         break;
   }
   return oldproc(hwnd,msg,mp1,mp2);
}

VOID    setbubble(HWND hwnd,PSZ pszText)
{
PFNWP oldproc;

oldproc = WinSubclassWindow (hwnd, (PFNWP)bubblewndproc);

WinCreateWindow(hwnd, WC_FRAME, "", 0, 0, 0, 1, 1, hwnd, HWND_TOP,
                9999, NULL, NULL);

WinSetWindowULong(WinWindowFromID(hwnd,9999), QWL_PENDATA, (ULONG)pszText);
WinSetWindowULong(WinWindowFromID(hwnd,9999), QWL_USER, (ULONG)oldproc);
}
