/* Load REXXUTIL functions */
call rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call sysloadfuncs

/* Find boot drive */
FullPath = Value('PATH',,'OS2ENVIRONMENT')
FullPath = Translate(FullPath)
Place = Pos("OS2",FullPath)
If Place \= 0 Then Do
    BootDrive = Substr(FullPath,Place-3,3)
End

'Unzip -qq t2zip_k.zip THESEUS2.SYS THESEUS0.dll'
'copy theseus0.dll ' || BootDrive || 'os2\dll\theseus0.dll'
Call SysFileDelete("theseus0.dll")

dest=directory() || "\SwapMon.exe"
if \SysCreateObject("WPProgram", "SwapMon", "<WP_DESKTOP>", "EXENAME=" dest, "UPDATE"),
    then say "Failed to create object"

InFile=BootDrive || "CONFIG.SYS"
OutFile=BootDrive || "CONFIG.SWB"

/* Delete any previous backup file called CONFIG.SWB */
If Stream(OutFile, 'C', 'Query Exists') <> '' Then Do
    Call SysFileDelete(OutFile)
End

/* We now backup CONFIG.SYS and check if there's already an
   entry for THESEUS2.SYS
   */

AlreadyThere = 0

Do While Lines(InFile) > 0
    Data = LineIn(InFile)
    /* Store the infile data because... */
    OrigData = Data
    /* ...we want to write in the same case */
    Data = Translate(Data)
    /* If this line is REMmed then skip it */
    Place = Pos("REM ", Data)
    If Place = 0 Then Do
        Place = Pos("THESEUS2.SYS", Data)
        If Place \= 0 Then Do
            AlreadyThere = 1
        End
    End
    Call LineOut OutFile, OrigData
End

If AlreadyThere = 0 Then Do
    TheseusLine = "DEVICE=" || directory() || "\THESEUS2.SYS"
    OutFile=BootDrive || "CONFIG.SYS"
    Call LineOut OutFile, TheseusLine
End
