/* Sample1 */
/* Initialize RexxUtil */
rc=RxFuncAdd('SysLoadFuncs','RexxUtil','SysLoadFuncs')
Call SysLoadFuncs
/* Initialize StHealth */
rc=RxFuncAdd('StHealthLoadFuncs','StHealth','StHealthLoadFuncs')
Call StHealthLoadFuncs

/* Initialize some variables */
LT1=65536
HT1=0
LT2=65536
HT2=0
LT3=65536
HT3=0

/* Query version of StHealth */
FullVersion=StHealthVersion("FULL")
Version=StHealthVersion("VERSION")
BuildLevel=StHealthVersion("BUILD")
Do Forever
 /* Query some values */
 V1=StHealthValue(VOLT1)
 V2=StHealthValue(VOLT2)
 V3=StHealthValue(VOLT3)
 V4=StHealthValue(VOLT4)
 V5=StHealthValue(VOLT5)
 V6=StHealthValue(VOLT6)
 V7=StHealthValue(VOLT7)
 T1=StHealthValue(TEMP1)
 T2=StHealthValue(TEMP2)
 T3=StHealthValue(TEMP3)
 F1=StHealthValue(FAN1)
 F2=StHealthValue(FAN2)
 F3=StHealthValue(FAN3)
 CT=StHealthChip(FULL)
 /* Check for high/low values */
 If T1>HT1 Then HT1=T1
 If T1<LT1 Then LT1=T1
 If T2>HT2 Then HT2=T2
 If T2<LT2 Then LT2=T2
 If T3>HT3 Then HT3=T3
 If T3<LT3 Then LT3=T3
 /* Clear screen */
 Call SysCls
 /* Display logo */
 Say "Sample Monitoring Script"
 Say "For use with StHealth.dll"
 Say "Copyright(c) 1999 by Stefan Milcke"
 Say ""
 Say "Version of StHealth.DLL: "FullVersion
 Say " "
 Say "Detected Chip: "CT
 Say " "
 /* Display stored values */
 Say "Core Voltage A:"V1
 Say "Core Voltage B:"V2
 Say "3.3 Volts     :"V3
 Say "5 Volts       :"V4
 Say "12 Volts      :"V5
 Say "-12 Volts     :"V6
 Say "-5 Volts      :"V7
 Say "-------------------------------------------------------------------------"
 Say "Temperature 1 :"T1"   Min:"LT1"   Max:"HT1
 Say "Temperature 2 :"T2"   Min:"LT2"   Max:"HT2
 Say "Temperature 3 :"T3"   Min:"LT3"   Max:"HT3
 Say "-------------------------------------------------------------------------"
 Say "Fan 1         :"F1
 Say "Fan 2         :"F2
 Say "Fan 3         :"F3
 /* Sleep for a while */
 Call SysSleep(1)
End
