unit Regeditr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, Outline, Tabs, ShellAPI, StdCtrls, ExtCtrls, Menus;

type
  TForm1 = class(TForm)
    TabSet1: TTabSet;
    Outline1: TOutline;
    Panel1: TPanel;
    EditPath: TEdit;
    EditVal: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Search1: TMenuItem;
    Addkey1: TMenuItem;
    Deletekey1: TMenuItem;
    Findtext1: TMenuItem;
    FindNext1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    FindDialog1: TFindDialog;
    Expandall1: TMenuItem;
    View1: TMenuItem;
    Rescan1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Addkey2: TMenuItem;
    Deletekey2: TMenuItem;
    N2: TMenuItem;
    Find1: TMenuItem;
    Findnext2: TMenuItem;
    N3: TMenuItem;
    Rescan2: TMenuItem;
    Expandall2: TMenuItem;
    Saveas1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Saveas2: TMenuItem;
    procedure TabSet1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure Panel1Resize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Outline1Click(Sender: TObject);
    procedure Findtext1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Deletekey1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Exit1Click(Sender: TObject);
    procedure Addkey1Click(Sender: TObject);
    procedure Outline1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Expandall1Click(Sender: TObject);
    procedure Rescan1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    MainKey: HKEY;
    DataIndex : longint;
    InitDelta : integer;
    procedure UpdateDisplay;
    procedure FlushChanges;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses NewKey;

const
  clases : array[0..4] of HKEY =
  (1,$80000000,$80000001,$80000002,$80000003);
  clsname : array[0..4] of PChar = ('HKEY_CLASSES_ROOT',
  'HKEY_CLASSES_ROOT','HKEY_CURRENT_USER','HKEY_LOCAL_MACHINE','HKEY_USERS');
var
  curname : PChar;

procedure TForm1.TabSet1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  FlushChanges;
  MainKey:=clases[NewTab];
  curname:=clsname[NewTab];
  UpdateDisplay;
end;

procedure TForm1.UpdateDisplay;

  procedure LoadEntries(key : HKEY; idx : longint);
  var
    i,l : longint;
    buf : array[0..127] of char;
    str : string;
    nkey : HKEY;
  begin
    i:=0;
    while RegEnumKey(key,i,buf,sizeof(buf)-1) = ERROR_SUCCESS do begin
      if RegOpenKey(key,buf,nkey) = ERROR_SUCCESS then begin
        str:=StrPas(buf);
        l:=sizeof(buf);
        if (RegQueryValue(nkey,NIL,buf,l) = ERROR_SUCCESS) and (buf[0] <> #0) then
          str:=str+' = '+StrPas(buf);
        LoadEntries(nkey,Outline1.AddChild(idx,str));
        RegCloseKey(nkey);
      end;
      inc(i);
    end;
  end;

var
  cr : HCursor;
begin
  cr:=SetCursor(LoadCursor(0,IDC_WAIT));
  Outline1.BeginUpdate;
  Outline1.Clear;
  Outline1.AddChild(0,'');
  LoadEntries(MainKey,0);
  Outline1.EndUpdate;
  SetCursor(cr);
end;

procedure TForm1.FlushChanges;
var
  buf1,buf2 : array[byte] of char;
  str : string;
  i : integer;
begin
  if EditVal.Modified then begin
    StrPCopy(buf1,EditPath.Text);
    StrPCopy(buf2,EditVal.Text);
    if RegSetValue(MainKey,buf1+1,REG_SZ,buf2,StrLen(buf2)) <> ERROR_SUCCESS then MessageBeep(MB_ICONHAND)
    else with Outline1 do begin
      str:=Items[DataIndex].Text;
      i:=Pos(' ',str);
      if i <> 0 then System.Delete(str,i,255);
      if EditVal.Text <> '' then str:=str+' = '+EditVal.Text;
      Items[DataIndex].Text:=str;
    end;
  end;
  EditVal.Modified:=FALSE;
end;

procedure TForm1.Panel1Resize(Sender: TObject);
begin
  EditPath.Width:=Panel1.Width-InitDelta;
  EditVal.Width:=EditPath.Width;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  InitDelta:=Panel1.Width-EditPath.Width;
  DataIndex:=0;
  EditVal.Modified:=FALSE;
  MainKey:=clases[TabSet1.TabIndex];
  curname:=clsname[TabSet1.TabIndex];
  UpdateDisplay;
end;

procedure TForm1.Outline1Click(Sender: TObject);
var
  onode : TOutlineNode;
  fpath,node : string;
  buf : array[byte] of char;
  key : HKEY;
  buflen : longint;
  i : integer;
begin
  FlushChanges;
  DataIndex:=Outline1.SelectedItem;
  onode:=Outline1.Items[DataIndex];
  fpath:='';
  while Assigned(onode) do begin
    node:=onode.Text;
    if node <> '' then begin
      i:=Pos(' ',node); if i <> 0 then Delete(node,i,255);
      fpath:='\'+node+fpath;
    end;
    onode:=onode.Parent;
  end;
  StrPCopy(buf,fpath);
  if fpath <> '' then begin
    buflen:=sizeof(buf);
    if RegQueryValue(MainKey,buf+1,buf,buflen) <> ERROR_SUCCESS then buf[0]:=#0;
  end
  else fpath:='\';
  EditPath.Text:=fpath;
  EditVal.Text:=StrPas(buf); EditVal.Modified:=FALSE;
end;

procedure TForm1.Findtext1Click(Sender: TObject);
begin
  FindDialog1.Execute;
end;

procedure TForm1.FindDialog1Find(Sender: TObject);

  procedure ExpandAll(onode : TOutlineNode);

  begin
    with onode do if (parent <> NIL) and not parent.Expanded then
      ExpandAll(parent);
    onode.Expand;
  end;

var
  i : longint;
  p : integer;
  cr : HCursor;
  str1,str2 : string;
begin
  with FindDialog1 do if FindText <> '' then with Outline1 do begin
    cr:=SetCursor(LoadCursor(0,IDC_WAIT));
    str1:=FindText; if not (frMatchCase in FindDialog1.Options) then str1:=UpperCase(str1);
    i:=SelectedItem;
    repeat
      if frDown in FindDialog1.Options then begin
        inc(i);
        if i > ItemCount then i:=1;
      end
      else begin
        dec(i);
        if i < 1 then i:=ItemCount;
      end;
      str2:=Items[i].Text; if not (frMatchCase in FindDialog1.Options) then str2:=UpperCase(str2);
      if frWholeWord in FindDialog1.Options then begin
        p:=Pos(' = ',str2);
        if p <> 0 then begin
          if str1 = Copy(str2,1,p-1) then break;
          System.Delete(str2,1,p+2);
        end;
        if str1=str2 then break;
      end
      else if Pos(str1,str2) <> 0 then break;
    until i = SelectedItem;
    SetCursor(cr);
    if i <> SelectedItem then begin
      ExpandAll(Items[i]);
      SelectedItem:=i;
      Outline1Click(self);
    end
    else MessageDlg('Cannot find'^J+FindText,mtWarning,[mbOK],0);
  end;
end;

procedure TForm1.Deletekey1Click(Sender: TObject);
var
  fpath : string;
  buf : array[byte] of char;
  key : HKEY;
  rv : longint;
begin
  key:=MainKey;
  fpath:=EditPath.Text; if Length(fpath) < 2 then Exit;
  Delete(fpath,1,1);
  if MessageDlg('Are you SURE you want to delete'^J+fpath+^J'and all it''s childs ?',
    mtConfirmation,mbOkCancel,0) <> mrOk then Exit;
  StrPCopy(buf,fpath);
  rv:=RegDeleteKey(key,buf);
  if rv = ERROR_SUCCESS then begin
    EditVal.Modified:=FALSE;
    with Outline1 do Delete(SelectedItem);
    Outline1Click(self);
  end
  else MessageBeep(MB_ICONHAND);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FlushChanges;
  FindDialog1.CloseDialog;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Addkey1Click(Sender: TObject);
var
  buf : array[byte] of char;
  str : string;
  i : integer;
  nkey : HKEY;
begin
  FlushChanges;
  if NewKeyDlg.ShowModal = mrOK then begin
    str:=NewKeyDlg.Edit1.Text;
    if str = '' then Exit;
    if str[1] = '\' then Delete(str,1,1);
    StrPCopy(buf,str);
    if RegCreateKey(MainKey,buf,nkey) = ERROR_SUCCESS then begin
      StrPCopy(buf,NewKeyDlg.Edit2.Text);
      if RegSetValue(nkey,NIL,REG_SZ,buf,StrLen(buf)) <> ERROR_SUCCESS then MessageBeep(MB_ICONHAND);
      RegCloseKey(nkey);
      UpdateDisplay;
    end
    else MessageBeep(MB_ICONHAND);
  end;
end;

procedure TForm1.Outline1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Shift = [] then case Key of
    VK_INSERT : Addkey1Click(self);
    VK_DELETE : Deletekey1Click(self);
  end;
end;

procedure TForm1.Expandall1Click(Sender: TObject);
var
  cr : HCursor;
begin
  cr:=SetCursor(LoadCursor(0,IDC_WAIT));
  Outline1.FullExpand;
  SetCursor(cr);
end;

procedure TForm1.Rescan1Click(Sender: TObject);
begin
  UpdateDisplay;
end;

{$I-}

procedure TForm1.Saveas1Click(Sender: TObject);
var
  f : System.text;
  value,tmps : string;
  npath,node : string;
  onode : TOutlineNode;
  i : integer;
  l : longint;
  cr : HCursor;

  procedure SaveTree(base : string; idx : longint);
  var
    child : longint;
    j : integer;
  begin
    with Outline1 do if idx > 0 then begin
      value:=Items[idx].Text;
      i:=Pos(' = ',value); if i = 0 then i:=256;
      if MainKey = clases[0] then Writeln(f,curname,base,'\',value)
      else begin
        Writeln(f,'[',curname,base,'\',Copy(value,1,i-1),']');
        if i <= 255 then begin
          tmps:='';
          for j:=i+3 to Length(value) do begin
            if value[j] in ['\','"'] then tmps:=tmps+'\';
            tmps:=tmps+value[j];
          end;
          Writeln(f,'@="',tmps,'"');
        end;
        Writeln(f);
      end;
      if Items[idx].HasItems then begin
        System.Delete(value,i,255);
        base:=base+'\'+value;
        child:=Items[idx].GetFirstChild;
        while child > 0 do begin
          SaveTree(base,child);
          child:=Items[idx].GetNextChild(child);
        end;
      end;
    end;
  end;

begin
  if (DataIndex <= 0) or (DataIndex > Outline1.ItemCount) then Exit;
  if SaveDialog1.Execute then begin
    AssignFile(f,SaveDialog1.FileName);
    Rewrite(f);
    if IOResult = 0 then with Outline1 do begin
      cr:=SetCursor(LoadCursor(0,IDC_WAIT));
      FlushChanges;
      if MainKey = clases[0] then Writeln(f,'REGEDIT') else Writeln(f,'REGEDIT4');
      Writeln(f);
      onode:=Items[DataIndex].Parent;
      npath:='';
      if DataIndex > 1 then begin
        while Assigned(onode) do begin
          node:=onode.Text;
          if node <> '' then begin
            i:=Pos(' ',node); if i <> 0 then System.Delete(node,i,255);
            npath:='\'+node+npath;
          end;
          onode:=onode.Parent;
        end;
        SaveTree(npath,DataIndex);
      end
      else for l:=2 to ItemCount do if Items[l].Level = 1 then SaveTree('',l);
      SetCursor(cr);
      CloseFile(f);
    end
    else Application.MessageBox('Cannot create file',NIL,MB_OK or MB_ICONSTOP);
  end;
end;

end.
