{$IFDEF VirtualPascal}
  {&Use32+}{&Delphi-}{&AlignCode+}{&AlignData+}{&AlignRec-}{&Optimize+}
  {$M 40000}
{$ELSE}
  {$M 30000,0,0}
{$ENDIF}

Program PCI;

{$G+}
{$R+}
{$S-}
{$I+}
{$N-}
{$E-}


uses
  {$IfNDef VirtualPascal}
  newdelay,
  {$EndIf}
  WinDos,Dos,
  Crt,
  Strings,
  pci_hw,
  redircon;


{$I classes.pas}


{
  This code is Written by Craig Hart in 1996-2001. It is released as freeware;
  please use and modify at will. No gurarantees are made or implied.


  Please read the accompaning documentation PCI.DOC for all the info
  relating to this program!
}



const
  revision      ='0.44vk';
  FModeReadOnly = $40; (* open_share_DenyNone+open_access_ReadOnly *)

var
  wrlncount,
  deviceid,
  func,
  nn,
  pp,
  lb,
  bus,
  sum,
  disp,
  cap_ptr       : byte;

  found,
  businfo,
  tableok,
  dorouting,
  dopcirouting,
  userev,
  summary,
  bogusid,
  genssid,
  dumpregs,
  first,
  installermode,
  showhelp,
  vga50         : boolean;


  irqmap        : array[0..15] of byte;


  romsize       : longint;



  addr          : longint;

  i,
  j,
  l,
  v             : word;

  f             : text;

  revchk,
  oemidnum,
  oemidstr,
  cmdstr,
  vstr,
  cmpstr        : string;

  pcidevs_txt   : string;
  pcidevs_path  : string;

  infotbl_cache : array[0..$ff] of byte;
  infotbl_read  : array[0..$ff] of boolean;
  infotbl_deviceid,
  infotbl_func,
  infotbl_bus   : word;

  bustype       : array[0..255] of (bustype_PCI,bustype_AGP,bustype_CardBus,bustype_None);


(* Read-Cache functions for PCI register space
   replaces old array infotbl - no need to read ahead and hang.. *)

procedure reset_infotbl_cache;
  begin
    FillChar(infotbl_read,SizeOf(infotbl_read),false);
  end;

procedure set_lookup_device(const deviceid,func,bus:word);
  begin
    infotbl_deviceid:=deviceid;
    infotbl_func:=func;
    infotbl_bus:=bus;
    reset_infotbl_cache;
  end;

function infotbl(const i:word):byte;
  begin
    if not infotbl_read[i] then
      begin
        infotbl_cache[i]:=lookup(infotbl_deviceid,infotbl_func,infotbl_bus,i);
        infotbl_read[i]:=true;
      end;
    infotbl:=infotbl_cache[i];
  end;

function infotbl_W(const i:word):Word;
  begin
    infotbl_W:=infotbl(i)+infotbl(i+1) shl 8;
  end;

function infotbl_L(const i:word):longint;
  begin
    infotbl_L:=infotbl_W(i)+infotbl_W(i+2) shl 16;
  end;


function cvt4(const b:byte) : char;
  begin
    if b>9 then cvt4:=Chr(b+Ord('A')-10)
    else cvt4:=Chr(b+ord('0'));
  end;

function wrhexb(const byt:byte): string;
  begin
    wrhexb:=cvt4(byt and $0f);
  end;

function wrhex(const byt:byte) : string;
  begin
    wrhex[0]:=#2;
    wrhex[1]:=cvt4((byt shr 4) and $0f);
    wrhex[2]:=cvt4( byt        and $0f);
  end;

function wrhexw(const wor:word): string;
  begin
    wrhexw[0]:=#4;
    wrhexw[1]:=cvt4((wor shr 12) and $0f);
    wrhexw[2]:=cvt4((wor shr  8) and $0f);
    wrhexw[3]:=cvt4((wor shr  4) and $0f);
    wrhexw[4]:=cvt4( wor         and $0f);
  end;

function wrhexl(const lon:longint): string;
  begin
    wrhexl:=wrhexw(lon shr 16)
           +wrhexw(lon and $ffff);
  end;


(* Make the PCI configuration status register printout pretty *)
(* Input = the string to be output *)

procedure printstatus (const s : string);
  begin
    if not first then
      if (Length(s)+WhereX)>78 then
        begin
          WriteLn(',');
          Write('   ');
        end
      else
        Write(', ');
    Write(s);
    first:=false;
  end;

{$IfDef VirtualPascal}
var
  pcidevs_txt_buffer    :PChar;
  pcidevs_txt_end       :PChar;
  pcidevs_txt_position  :PChar;
{$EndIf}

procedure Assign2(var f:text;const filename:string);
  {$IfDef VirtualPascal}
  var
    f2                  :file;
    f2s                 :longint;

  begin
    pcidevs_txt_buffer  :=nil;
    pcidevs_txt_end     :=nil;
    pcidevs_txt_position:=nil;

    FileMode:=FModeReadOnly;
    Assign(f2,filename);
    {$I-}
    Reset(f2,1);
    {$I+}
    if InOutRes<>0 then Exit;

    f2s:=FileSize(f2);
    GetMem(pcidevs_txt_buffer,f2s+2);
    pcidevs_txt_buffer[f2s  ]:=#$0d;
    pcidevs_txt_buffer[f2s+1]:=#$0a;
    BlockRead(f2,pcidevs_txt_buffer[0],f2s);
    Close(f2);

    pcidevs_txt_end     :=@pcidevs_txt_buffer[f2s];
    pcidevs_txt_position:=pcidevs_txt_buffer;
  end;
  {$Else}
  begin
    FileMode:=FModeReadOnly;
    Assign(f,filename);
  end;
  {$EndIf}

procedure Reset2(var f:text);
  {$IfDef VirtualPascal}
  begin
    pcidevs_txt_position:=pcidevs_txt_buffer;
  end;
  {$Else}
  begin
    Reset(f);
  end;
  {$EndIf}


procedure ReadLn2(var f:text;var zk:string);
  {$IfDef VirtualPascal}
  var
    linestart:PChar;
    linelength:word;
  begin

    linestart:=pcidevs_txt_position;
    linelength:=0;
    while pcidevs_txt_position<>pcidevs_txt_end do
      case pcidevs_txt_position[0] of
        ^Z:
          Break;
        #13:
          Inc(pcidevs_txt_position);

        #10:
          begin
            Inc(pcidevs_txt_position);
            Break;
          end;
      else
        Inc(pcidevs_txt_position);
        Inc(linelength);
      end;

    if linelength=0 then
      zk:=''
    else
      begin
        SetLength(zk,linelength);
        Move(linestart^,zk[1],linelength);
      end;

  end;
  {$Else}
  begin
    ReadLn(f,zk);
  end;
  {$EndIf}


function Eof2(var f:text):boolean;
  {$IfDef VirtualPascal}
  begin
    Eof2:=(pcidevs_txt_position=pcidevs_txt_end);
  end;
  {$Else}
  begin
    Eof2:=Eof(f);
  end;
  {$EndIf}


procedure Close2(var f:text);
  {$IfDef VirtualPascal}
  begin
  end;
  {$Else}
  begin
    Close(f);
  end;
  {$EndIf}


procedure listmap(const va:word;const dispst:string);
  var
    comma  : byte;
    failed : boolean;
    l,
    j      : word;

  begin
    failed:=true;
    Write(dispst);
    comma:=0;
    for l:=0 to 15 do
      if (va and (1 shl l))>0 then
        Inc(comma);

    l:=1;
    j:=0;
    repeat
      if (va and l)=l then
        begin
          Write(j);
          if comma>1 then Write(',')
          else Write(' ');
          Dec(comma);
          failed:=false;
        end;
      {$R-} (* 1 shl 16 is not a "Word" *)
      l:=l shl 1;
      {$R+}
      Inc(j);
    until j=16;

    if failed then
      WriteLn('None')
    else
      WriteLn;
  end;


procedure lookupven(const silent:boolean);
  begin
    Reset2(f);
    failed:=true;
    repeat
      ReadLn2(f,vstr);
      if (vstr[1]='V') and (StrLComp(@vstr[3],@cmpstr[1],4)=0) then
        begin
          TextColor(Yellow);
          if not silent then Write(Copy(vstr,8,Length(vstr)));
          TextColor(LightGray);
          failed:=false;
        end;
    until Eof2(f) or not failed;
    if failed then
    begin
      TextColor(LightRed);
      if not silent then Write('Unknown');
      TextColor(LightGray);
    end;
  end;

procedure lookupdev;
  begin
    failed:=true;

    while failed and (not Eof2(f)) do
      begin

        ReadLn2(f,vstr);
        if (vstr[1]='D') and (StrLComp(@vstr[3],@cmpstr[1],4)=0) then
          begin
            if not Eof2(f) then ReadLn2(f,revchk);
            if revchk[1]='R' then
            begin
              repeat
                if wrhex(infotbl(8))=Copy(revchk,3,2) then vstr:='xxxxxxx'+Copy(revchk,6,Length(revchk));
                if not Eof2(f) then ReadLn2(f,revchk);
              until revchk[1]<>'R';
            end;
            TextColor(Yellow);
            Write(Copy(vstr,8,Length(vstr)));
            failed:=false;
            TextColor(LightGray);
          end;

      if vstr[1]='V' then Break;
    end;

    if failed then
      begin
        TextColor(LightRed);
        Write('Unknown');
        TextColor(LightGray);
      end;

  end;


procedure showinstallerinfo;
  begin
    Write('V:',wrhexw(infotbl_W(0)),' ');

    Write('D:',wrhexw(infotbl_W(2)),' ');

    Write('S:');
    case infotbl($e) and $7f of
      0:
        begin
          Write(wrhexw(infotbl_W($2e)));
          Write(wrhexw(infotbl_W($2c)),' ');
        end;
      2:
        begin
          Write(wrhexw(infotbl_W($42)));
          Write(wrhexw(infotbl_W($40)),' ');
        end;

    else
      Write('00000000 ');
    end;

    Write('B:',bus,' ');

    Write('E:');
    if deviceid<10 then Write('0'); (* 00..31 *)
    Write(deviceid,' ');

    Write('F:',func,' ');

    Write('I:'); (* Interrupt line *)
    if infotbl($3c) in [1..15] then
      begin
        if infotbl($3c)<10 then Write('0');
        Write(infotbl($3c),' ');
      end
    else
      Write('00 ');

    Write('N:'); (* Interrupt pin *)
    if infotbl($3c) in [1..15] then
      begin
        if infotbl($3d)=0 then Write('- ')
        else Write(Chr(infotbl($3d)+Ord('@')),' ');
      end
    else Write('- ');

    Write('C:',wrhex(infotbl($b)),' ');

    Write('U:',wrhex(infotbl($a)),' ');

    Write('P:',wrhex(infotbl($9)),' ');

    WriteLn;
  end;


procedure showroutinginfo;
  begin
    WriteLn('ROM PCI IRQ routing table Windows 9x Compatibility Tests....');

{ Find table }

    i:=0;
    failed:=true;
    repeat
     if (MemW_F000(i)=$5024) and (MemW_F000(i+2)=$5249) then failed:=false;
     if failed then Inc(i,$10);
    until (i>$ffef) or not failed;

{ check table }

    if failed then
      begin
        TextColor(LightRed);
        WriteLn('No ROM PCI IRQ routing table found!!!');
        TextColor(LightGray);
        Exit;
      end;

    tableok:=true;

    WriteLn(' ROM IRQ routing table found at F000h:',wrhexw(i),'h');
    Write(' Table Version ',Mem_F000(i+5),'.',Mem_F000(i+4));
    if (Mem_F000(i+5)=1) and (Mem_F000(i+4)=0) then
      WriteLn(' - OK')
    else
      begin
        TextColor(LightRed);
        WriteLn('Invalid Version!');
        TextColor(LightGray);
        tableok:=false;
      end;

    Write(' Table size ',MemW_F000(i+6),' bytes - ');
    if (MemW_F000(i+6)<33) or (MemW_F000(i+6) mod 16<>0) then
      begin
        TextColor(LightRed);
        WriteLn('Invalid Size!');
        TextColor(LightGray);
        tableok:=false;
      end
    else
      WriteLn('OK');


    Write(' Table Checksum ',wrhex(Mem_F000(i+31)),'h - ');
    {$R-}  {Range checking off as sum is DELIBERATELY meant to overfow }
    sum:=0;
    for l:=0 to MemW_F000(i+6)-1 do
      Inc(sum,Mem_F000(i+l));
    {$R+}
    if sum=0 then
      WriteLn('OK')
    else
      begin
        TextColor(LightRed);
        WriteLn('Failed!');
        TextColor(LightGray);
        tableok:=false;
      end;

    listmap(MemW_F000(i+10),' IRQ''s dedicated to PCI : ');

    if tableok then
      begin
        TextColor(LightGreen);
        WriteLn(' The ROM PCI IRQ routing table appears to be OK.');
        TextColor(LightGray);
      end
    else
      begin
        TextColor(LightRed);
        WriteLn(' The ROM PCI IRQ routing table appears to be faulty!!');
        TextColor(LightGray);
      end;

  end;


procedure dohexdump;
  begin
    WriteLn('Hex-Dump of IRQ Routing table : ');
    WriteLn;

    Write('  0000  ');

    for j:=0 to 15 do
      if j<6 then
        Write(wrhex(irqbuff[j]),' ')
      else
        Write('   ');

    Write('   ');

    for j:=0 to 6-1 do
      if irqbuff[j]<32 then
        Write('.')
      else
        Write(Chr(irqbuff[j]));

    WriteLn;


    for i:=Low(irqbuffR.IRQ_routing_table_entry_Array) to High(irqbuffR.IRQ_routing_table_entry_Array) do
      with irqbuffR.IRQ_routing_table_entry_Array[i] do
        begin
          Write('  ',wrhexw(i*16+6),'  ');

          for j:=0 to 15 do
            Write(wrhex(binary[j]),' ');

          Write('   ');

          for j:=0 to 15 do
            if binary[j]<32 then
              Write('.')
            else
              Write(Chr(binary[j]));

          WriteLn;
        end;

    WriteLn;
    WriteLn;
  end;


procedure docapdecode;
  const
    YesNo:array[boolean] of string[3]=('No','Yes');

  begin
    WriteLn(' New Capabilities List Information :');

    case infotbl($e) and $7f of
      0:cap_ptr:=infotbl($34);
      1:cap_ptr:=infotbl($34);
      2:cap_ptr:=infotbl($14);
    else
        cap_ptr:=0;
    end;

    if cap_ptr=0 then
      begin
        WriteLn('  No New Capabilities Are Currently Enabled');
        Exit;
      end;

    repeat

      case infotbl(cap_ptr) of

        01 :
          begin
            WriteLn('  Power Management Capabilities');
            if infotbl(cap_ptr+3) and 4=4 then WriteLn('    Supports power state D2');
            if infotbl(cap_ptr+3) and 2=2 then WriteLn('    Supports power state D1');
            Write('    Current Power State : D');
            case infotbl(cap_ptr+4) and 3 of
              0 : WriteLn('0 (Device fully-operational, no power saving)');
              1 : WriteLn('1 (Device operational, minimum power saving)');
              2 : WriteLn('2 (Device on standby, medium power saving)');
              3 : WriteLn('3 (Device fully-off, no power to device)');
            end;

            (* D0/1/2/3-state power consumed in watts
            for i:=0 to 3 do
              begin
                addr:=infotbl_W(cap_ptr+4) and $00ff
                     +i shl 9;
                write_word(deviceid,func,bus,cap_ptr+4,addr);
                Write('D',i,': ');
                case (infotbl_W(cap_ptr+4) shr 13) and 3 of
                  0:Write('???  ');
                  1:Write(infotbl(cap_ptr+7)*100:5);
                  2:Write(infotbl(cap_ptr+7)* 10:5);
                  3:Write(infotbl(cap_ptr+7)*  1:5);
                end;
                WriteLn('mW');
              end;*)

          end;

        02 :
          begin
            Write('  AGP Capabilities, Version ');
            WriteLn(infotbl(cap_ptr+2) shr 4,'.',infotbl(cap_ptr+2) and $0f);

            { Status register }

            Write('    AGP Speed(s) Supported : ');
            if infotbl(cap_ptr+4) and 1=1 then Write('1x ');
            if infotbl(cap_ptr+4) and 2=2 then Write('2x ');
            if infotbl(cap_ptr+4) and 4=4 then Write('4x ');
            if infotbl(cap_ptr+4) and 7=0 then
              begin
                TextColor(LightRed);
                Write('None!!');
                TextColor(LightCyan);
                Write(' (Assume Only 1x Support)');
                TextColor(LightGray);
              end;

            WriteLn;

            WriteLn('    FW Transfers Supported : ',
              YesNo[infotbl(cap_ptr+4) and $10=$10]);

            WriteLn('    >4Gb Address Space Supported : ',
              YesNo[infotbl(cap_ptr+4) and $20=$20]);

            WriteLn('    Sideband Addressing Supported : ',
              YesNo[infotbl(cap_ptr+5) and 2=2]);

            Write('    Maximum Command Queue Length : ',infotbl(cap_ptr+7)+1,' byte');
            if infotbl(cap_ptr+7)=0 then WriteLn else WriteLn('s');


            { Command register }

            Write('    AGP Speed Selected : ');
            if infotbl(cap_ptr+8) and 1=1 then Write('1x ');
            if infotbl(cap_ptr+8) and 2=2 then Write('2x ');
            if infotbl(cap_ptr+8) and 4=4 then Write('4x ');
            if infotbl(cap_ptr+8) and 7=0 then Write('None Selected');
            WriteLn;

            WriteLn('    FW Transfers Enabled : ',
              YesNo[infotbl(cap_ptr+8) and $10=$10]);

            WriteLn('    >4Gb Address Space Enabled : ',
               YesNo[infotbl(cap_ptr+8) and $20=$20]);

            Write('    AGP Enabled : ');
            if infotbl(cap_ptr+9) and 1=1 then
              begin
                TextColor(LightGreen);
                WriteLn('Yes');
                TextColor(LightGray);
              end
            else
              begin
                TextColor(LightRed);
                WriteLn('No');
                TextColor(LightGray);
              end;

            WriteLn('    Sideband Addressing Enabled : ',
              YesNo[infotbl(cap_ptr+9) and 2=2]);

            Write('    Current Command Queue Length : ',infotbl(cap_ptr+11)+1,' byte');
            if infotbl(cap_ptr+11)=0 then WriteLn else WriteLn('s');
          end;


        03 : begin
               WriteLn('  Vital Product Data Capability');
             end;


        04 : begin
               WriteLn('  Slot Identification Capability');

               Write('    This is ');
               if infotbl(cap_ptr)+2 and $20=0 then Write('not ');
               WriteLn('a parent bridge');

               Write('    Number of slots on secondary side of this bridge : ');
               WriteLn(infotbl(cap_ptr+2) and $1f);

               WriteLn('Chassis Number : ',infotbl(cap_ptr+3));
             end;


        05 : begin
               WriteLn('  Message Signalled Interrupt Capability');
               Write('    MSI is ');
               if infotbl(cap_ptr+2) and 1=1 then WriteLn('enabled') else WriteLn('disabled');

               Write('    MSI function can generate ');
               if infotbl(cap_ptr+2) and 128=128 then WriteLn('64') else Write('32');
               WriteLn('-bit addresses');
              end;


        06 : begin
               WriteLn('  CompactPCI Hot-Swap Capability');
             end;


        07 : begin
               WriteLn('  PCI-X Capability');

               Write('    Device AD bus size is ');
               if infotbl(cap_ptr+6) and 1=1 then Write('64') else Write('32');
               WriteLn('-bit');

               Write('    Device maximum speed in PCI-X mode is ');
               if infotbl(cap_ptr+6) and 2=2 then Write('133') else Write('66');
               WriteLn('MHz');
             end;



        09 : begin
               WriteLn('  Vendor-Dependant Capability');
             end;




      else
             WriteLn('  Unknown Capability (Code ',wrhex(infotbl(cap_ptr)),'h)!!');
      end;

      cap_ptr:=infotbl(cap_ptr+1);

    until cap_ptr=0;
  end;


function has_agp_capability:boolean;
  begin
    has_agp_capability:=false;

    case infotbl($e) and $7f of
      0:cap_ptr:=infotbl($34);
      1:cap_ptr:=infotbl($34);
      2:cap_ptr:=infotbl($14);
    else
        cap_ptr:=0;
    end;

    while cap_ptr<>0 do
      if infotbl(cap_ptr)=02 then (* AGP *)
        begin
          (* any speed supported ? *)
          has_agp_capability:=(infotbl(cap_ptr+4) and 7<>0);
          Exit;
        end
      else
        cap_ptr:=infotbl(cap_ptr+1);

  end;


procedure showallinfo;
  var
    x           : byte;
    sub_vendor,
    sub_device  : word;

  begin

    if businfo then
      begin
        Write(' Bus ');
        TextColor(LightCyan);
        Write(bus);
        TextColor(LightGray);
        Write(' (');

{ we crudely assume bus 1 is AGP, unless we see it's cardbus - this is probably wrong but will do for now!! }
{ It's wrong because a pci-pci bridge on a board without AGP could mean that the far side of the bridge
is reported as AGP, when it's not...}

        case bustype[bus] of
          bustype_AGP:
            Write('AGP');
          bustype_CardBus:
            Write('CardBus');
        else (* bustype_PCI *)
            Write('PCI');
        end;

        Write('), Device Number ');
        TextColor(LightCyan);
        Write(deviceid);
        TextColor(LightGray);
        Write(', Device Function ');
        TextColor(LightCyan);
        WriteLn(func);
        TextColor(LightGray);
      end; (* businfo *)


    if installermode then
      showinstallerinfo
    else
      begin

        Write(' Vendor ',wrhexw(infotbl_W(0)),'h ');
        cmpstr:=wrhexw(infotbl_W(0));
        lookupven(false);
        WriteLn;


        Write(' Device ',wrhexw(infotbl_W(2)),'h ');
        cmpstr:=wrhexw(infotbl_W(2));
        lookupdev;
        WriteLn;


        if not summary then
          begin
            Write(' Command ',wrhexw(infotbl_W(4)),'h');
            if infotbl_W(4) > 0 then
              begin
                first:=true;
                Write(' (');
                if infotbl(4) and   1=1   then printstatus('I/O Access');
                if infotbl(4) and   2=2   then printstatus('Memory Access');
                if infotbl(4) and   4=4   then printstatus('BusMaster');
                if infotbl(4) and   8=8   then printstatus('Special Cycles');
                if infotbl(4) and  16=16  then printstatus('MemWrite+Invalidate');
                if infotbl(4) and  32=32  then printstatus('VGA Palette Snoop');
                if infotbl(4) and  64=64  then printstatus('Parity Error Response');
                if infotbl(4) and 128=128 then printstatus('Wait Cycles');

                if infotbl(5) and   1=1  then printstatus('System Errors');
                if infotbl(5) and   2=2  then printstatus('Back-To-Back Transactions');

                Write(')');
              end;
            WriteLn;


            Write(' Status ',wrhexw(infotbl_W(6)),'h');
            if (infotbl(6)<>0) or (infotbl(7)<>0) then
              begin
                first:=true;
                Write(' (');
                if infotbl(6) and  16=16  then printstatus('Has Capabilities List');
                if infotbl(6) and  32=32  then printstatus('Supports 66MHz');
                if infotbl(6) and  64=64  then printstatus('Has UDF');
                if infotbl(6) and 128=128 then printstatus('Supports Back-To-Back Trans.');

                if infotbl(7) and   1=1   then printstatus('Data parity Error Detected');
                (* timing 2/4*)
                if infotbl(7) and   8=8   then printstatus('Signalled Target Abort');
                if infotbl(7) and  16=16  then printstatus('Received Target Abort');
                if infotbl(7) and  32=32  then printstatus('Received Master Abort');
                if infotbl(7) and  64=64  then printstatus('Signalled System Error');
                if infotbl(7) and 128=128 then printstatus('Detected Parity Error');

                case ((infotbl(7) and 6) shr 1) of
                  0 : printstatus('Fast Timing');
                  1 : printstatus('Medium Timing');
                  2 : printstatus('Slow Timing');
                  3 : printstatus('Unknown Timing');
                end;
                Write(')');

              end;
            WriteLn;

            WriteLn(' Revision ',wrhex(infotbl(8)),'h',
                    ', Header Type ',wrhex(infotbl($e)),'h',
                    ', Bus Latency ',wrhex(infotbl($d)),'h');


            Write(' Self test ',wrhex(infotbl($f)),'h (Self test ');
            if infotbl($f) and $80=0 then Write('not ');
            Write('supported');


            if infotbl($f) and $80=$80 then
              begin
                Write(': Completion code ',wrhexb(infotbl($f) and $f),'h - ');
                if infotbl($f) and $0f=0 then
                  begin
                    TextColor(LightGreen);
                    Write('OK');
                    TextColor(LightGray);
                  end
                else
                  begin
                    TextColor(LightRed);
                    Write('Failed!!');
                    TextColor(LightGray);
                  end;
              end;
            WriteLn(')');


            if infotbl($c)<>0 then
              WriteLn(' Cache line size ',infotbl($c)*4,' Bytes (',infotbl($c),' DWords)');


            Write(' PCI Class ');

            i:=infotbl($b);
            if i=$ff then
              begin
                Write('FFh ');
                TextColor(LightGreen);
                Write('(does not meet any PCI-SIG defined class)');
                TextColor(LightGray);
              end

            else
            if not (i in [Low(PCI_class_names)..High(PCI_class_names)]) then
              begin
                TextColor(Yellow);
                Write(wrhexb(i),'h Unknown!');
                TextColor(LightGray);
              end

            else
              begin

                if i in [Low(PCI_class_names)..High(PCI_class_names)] then
                  begin
                    TextColor(Yellow);
                    Write(PCI_class_names[i]);
                    TextColor(LightGray);
                  end;

                Write(', type ');


{

*old subclass code*

          Write(' Subclass ');
          for i:=0 to high_class_array do
          if (infotbl($b] shl 8 + infotbl($a])=PCI_class_array[i].class then
          begin
            TextColor(Yellow);
            Write(PCI_class_array[i].name);
            TextColor(LightGray);
          end;

          Write(' Interface ');
          WriteLn(wrhex(infotbl(9]),'h');
}

                found:=false;

                for i:=Low(pci_class_array) to High(pci_class_array) do
                  begin
                    if  (pci_class_array[i].class_  =infotbl($b))
                    and (pci_class_array[i].subclass=infotbl($a))
                    and (pci_class_array[i].progif  =infotbl($9)) then
                      begin
                        found:=true;
                        TextColor(Yellow);
                        Write(PCI_class_array[i].cname);
                        TextColor(LightGray);
                        Break;
                      end;
                  end;


                if not found then
                  begin
                    for i:=Low(pci_class_array) to High(pci_class_array) do
                      if  (pci_class_array[i].class_  =infotbl($b))
                      and (pci_class_array[i].subclass=infotbl($a)) then
                        begin
                          found:=true;
                          TextColor(Yellow);
                          Write(PCI_class_array[i].cname);
                          TextColor(LightGray);
                          Break;
                        end;
                  end;


                if not found then
                  begin
                    TextColor(LightRed);
                    Write('Unknown!');
                    TextColor(LightGray);
                  end;


              end;


            WriteLn;
          end;



        if not summary then
          begin

{ look for generic PCI IDE controller & decode it's info, if present }
            if (infotbl($b)=01) and (infotbl($a)=01) then
              begin
                WriteLn(' PCI EIDE Controller Features :');
                Write('  BusMaster EIDE is ');
                if infotbl($9) and $80=0 then
                  begin
                    TextColor(LightRed);
                    Write('NOT ');
                    TextColor(LightGray);
                  end;
                WriteLn('supported');

                Write('  Primary   Channel is ');
                if infotbl($9) and 1=0 then
                  begin
                    WriteLn('at I/O Port 01F0h and IRQ 14');
                    if infotbl($3c)<>14 then Inc(irqmap[14]);
                  end
                else
                  WriteLn('in native mode at Addresses 0 & 1');

                Write('  Secondary Channel is ');
                if infotbl($9) and 4=0 then
                  begin
                    WriteLn('at I/O Port 0170h and IRQ 15');
                    if infotbl($3c)<>15 then Inc(irqmap[15]);
                  end
                else
                  WriteLn('in native mode at Addresses 2 & 3');
              end;

          end
        else
          begin
{ summary mode: pick up IRQs only }
            if (infotbl($b)=01) and (infotbl($a)=01) then
              begin
                if (infotbl($9) and 1=0) and (infotbl($3c)<>14) then Inc(irqmap[14]);
                if (infotbl($9) and 4=0) and (infotbl($3c)<>15) then Inc(irqmap[15]);
              end;
          end;




{ if type 0 table & if Subsystem ID exists, display and scan file for match }
        case infotbl($e) and $7f of
         0:
           begin
             sub_vendor:=infotbl_W($2c);
             sub_device:=infotbl_W($2e);
           end;
         2:
           begin
             sub_vendor:=infotbl_W($40);
             sub_device:=infotbl_W($42);
           end;
        else
             sub_vendor:=0;
             sub_device:=0;
        end;

        if (sub_vendor<>0) or (sub_device<>0) then
          begin

{ subsystem ID }

            Write(' Subsystem ID ',wrhexw(sub_device),
                                   wrhexw(sub_vendor),'h');
            cmpstr:=wrhexw(sub_device)+wrhexw(sub_vendor);


            genssid:=    (sub_vendor=infotbl_W(0))
                     and (sub_device=infotbl_W(2));

            oemidnum:='';
            oemidstr:='';
            bogusid:=false;


            failed:=true;
            userev:=true;
            while (not Eof2(f)) and (failed) do
              begin

{!!}              if userev then vstr:=revchk
                else ReadLn2(f,vstr);
                userev:=false;


{ OEM Vendor ID }
                case vstr[1] of
                  'O':
                    if StrLComp(@vstr[3],@cmpstr[5],4)=0 then
                      begin
                        oemidstr:=Copy(vstr,8,Length(vstr)); { closest match }
                        oemidnum:=Copy(vstr,3,4); { matching vendor name }
                      end;

                  'S':
                    if StrLComp(@vstr[3],@cmpstr[1],4)=0 then
                      if oemidnum<>'' then
                        begin
                          oemidstr:=Copy(vstr,8,Length(vstr));
                          TextColor(Yellow);
                          Write(' ',oemidstr);
                          if genssid then
                            begin
                              TextColor(LightCyan);
                              WriteLn(' (Generic ID)')
                            end
                          else
                            WriteLn;
                          failed:=false;
                          TextColor(LightGray);
                        end;


{ Oddball 8 digit entry }
                  'X':
                    if StrLComp(@vstr[3],@cmpstr[1],8)=0 then
                      begin
                        oemidnum:=Copy(vstr,7,4); { matching vendor name }
                        bogusid:=true;
                        TextColor(Yellow);
                        Write(' ',Copy(vstr,12,Length(vstr)));
                        if genssid then
                          begin
                            TextColor(LightCyan);
                            WriteLn(' (Generic ID)')
                          end
                        else
                          WriteLn;
                        failed:=false;
                        TextColor(LightGray);
                      end;

                else
                  Break;
                end;

              end; (* while not eof/not failed *)


            if failed then
              begin

                if oemidstr<>'' then
                  begin
                    TextColor(Yellow);
                    Write(' ',oemidstr);
                    TextColor(White);
                    Write(' (Guess Only!)');
                    TextColor(LightGray);
                  end
                else
                  begin
                    TextColor(LightRed);
                    Write(' Unknown');
                  end;

                if genssid then
                  begin
                    TextColor(LightCyan);
                    WriteLn(' (Generic ID)')
                  end
                else
                  WriteLn;
                TextColor(LightGray);

              end;


{ subsystem vendor }
            Write(' Subsystem Vendor ',wrhexw(sub_vendor),'h');

            if bogusid then
              begin
                TextColor(White);
                WriteLn(' Known Bad Subsystem ID - no Vendor ID Available');
                TextColor(LightGray);
              end
            else
              begin
                if oemidnum<>'' then cmpstr:=oemidnum
                else cmpstr:=wrhexw(sub_vendor);

                Close2(f);            { get back to start of file, as the}
                Reset2(f);            { subsys vendor may be higher up...!}
                failed:=true;

                while not Eof2(f) do
                  begin
                    ReadLn2(f,vstr);
                    if (vstr[1]='V') and (StrLComp(@vstr[3],@cmpstr[1],4)=0) then
                      begin
                        TextColor(Yellow);
                        WriteLn(' ',Copy(vstr,8,Length(vstr)));
                        failed:=false;
                        TextColor(LightGray);
                        Break;
                      end;
                  end;
              end;

            if failed then
              begin
                TextColor(LightRed);
                WriteLn(' Unknown');
                TextColor(LightGray);
              end;

          end; (* subsystem id available *)


{ always }
        Close2(f);



        if not summary then
          begin

{ type 0 header = 6 entries, type 1 = 2, type 2 = skip }
            case infotbl($e) and $7f of
              0:pp:=6;
              1:pp:=1;
            else
                pp:=0;
            end;

            nn:=0;
            while nn<pp do
              begin

                if infotbl_L($10+(nn*4))<>0 then
                  begin

                    Write(' Address ',nn,' is a');
                    if infotbl($10+(nn*4)) and 1=1 then
                      begin
                        Write('n I/O Port : ');
                        addr:=infotbl_L($10+(nn*4)) and $fffffffc;
                        Write(wrhexl(addr),'h');
                      end
                    else
                      begin
                        Write(' Memory Address');
                        case (infotbl($10+(nn*4)) shr 1) and $3 of
                          0:Write(' (anywhere in 0-4Gb');
                          1:Write(' (below 1Mb');
                          2:Write(' (anywhere in 64-bit space');
                          3:Write(' (reserved');
                        end;
                        if infotbl($10+(nn*4)) and 8=8 then Write(', Prefetchable) : ')
                        else Write(') : ');

                        addr:=infotbl_L($10+(nn*4)) and $fffffff0;

                        (* 64 bit needs next addr *)
                        if ((infotbl($10+(nn*4)) shr 1) and $3)=2 then
                          begin
                            Write(wrhexl(infotbl_L($10+(nn*4)+4)));
                            Inc(nn);
                          end;

                        Write(wrhexl(addr)+'h');
                      end;

                    { size the register ?? }
                    WriteLn;
                  end;
                Inc(nn);
              end;

          end;

{ all header types - list IRQ, if present }
        if infotbl($3c) in [1..15] then
          begin
            Write(' System IRQ ',infotbl($3c),', INT# ');
            if infotbl($3d)=0 then Write('-')
            else Write(chr(infotbl($3d)+Ord('@')));
            WriteLn;
            Inc(irqmap[infotbl($3c)]);
          end;




        if not summary then
          begin


{ type 0,1 header - List ExpROM, if present }
            case infotbl($e) and $7f of
              0:lb:=$30;
              1:lb:=$38;
            else
                lb:=0;

            end;

            if lb<>0 then
              begin

                (* what is this ??? *)
                write_dword(deviceid,func,bus,lb,$fffffffe);
                reset_infotbl_cache;

                if (infotbl(lb+3)<>0) or (infotbl(lb+2)<>0) or (infotbl(lb+1) and $f8<>0) then
                  begin
                    case infotbl(lb+1) of
                      $f8 : romsize:=2;       (* ff ff f8 00 *)
                      $f0 : romsize:=4;
                      $e0 : romsize:=8;
                      $c0 : romsize:=16;
                      $80 : romsize:=32;      (* ff ?? 00 00 *)
                      $00 :
                            case infotbl(lb+2) of
                              $ff : romsize:=64;
                              $fe : romsize:=128;
                              $fc : romsize:=256;
                              $f8 : romsize:=512;
                              $f0 : romsize:=1024;
                              $e0 : romsize:=2048;
                              $c0 : romsize:=4096;
                              $80 : romsize:=8192;
                              $00 : romsize:=16384; { largest possible = 16Mb }
                            end;
                    end;
                    Write(' Expansion ROM of ');
                    if romsize>1000 then
                      Write(romsize/1024:2:0,'Mb')
                    else
                      Write(romsize,'Kb');
                    WriteLn(' decoded by this card');
                  end;
              end;


          end; (* summary *)



{ type 1 header only - List bus numbers etc }
        if not summary then
          begin

            if infotbl($e) and $7f=1 then
              begin
                Write(' Primary bus number ',infotbl($18),', Secondary bus number ',infotbl($19));
                if infotbl($19)<=bus then
                  begin
                    TextColor(LightRed);
                    Write(' (invalid)');
                    TextColor(LightGray);
                  end;

                WriteLn(', Subordinate bus number ',infotbl($1a));
                WriteLn(' Secondary bus latency ',wrhex(infotbl($1b)),'h',
                        ', Secondary bus status ',wrhexw(infotbl_W($1e)),'h');

                first:=true;
                Write(' Secondary bus controls : ');
                if infotbl($3e) and   1=1   then printstatus('parity detection');
                (* reserved           2=2 *)
                if infotbl($3e) and   4=4   then printstatus('ISA mapping');
                if infotbl($3e) and   8=8   then printstatus('VGA mapping');
                (* reserved          16=16 *)
                if infotbl($3e) and  32=32  then printstatus('master abort mode');
                (* reset secondary bus 64=64 *)
                if infotbl($3e) and 128=128 then printstatus('back-to-back transactions');
                WriteLn;

{ I/O ports range accessable beyond bridge }
                if (infotbl($1c)<>0) or (infotbl($1d)<>0) then
                  begin
                    Write(' I/O Port range accessable beyond bridge : ');
                    if infotbl($1c) and $f=0 then Write(wrhexb(infotbl($1c) shr 4),'000h to ')
                    else Write(wrhex(infotbl($31)),wrhex(infotbl($30)),wrhexb(infotbl($1c) shr 4),'000h to ');
                    if infotbl($1d) and $f=0 then WriteLn(wrhexb(infotbl($1d) shr 4),'FFFh')
                    else WriteLn(wrhex(infotbl($33)),wrhex(infotbl($32)),wrhexb(infotbl($1d) shr 4),'FFFh');
                  end;

              end; (* header type 1 *)
          end; (* not summary *)



{ type 2 header only - List bus numbers etc }

        if not summary then
          begin
            if infotbl($e) and $7f=2 then
              begin
                Write(' PCI bus number ',infotbl($18),', CardBus bus number ',infotbl($19));

                if (infotbl($19)<>0) and (bustype[infotbl($19)]<>bustype_CardBus) then
                  begin
                    TextColor(LightRed);
                    case bustype[infotbl($19)] of
                      bustype_PCI:
                        Write(' (is already PCI bus)');
                      bustype_AGP:
                        Write(' (is already AGP bus)');
                    end;
                    TextColor(LightGray);
                  end;

                WriteLn(', Subordinate bus number ',infotbl($1a));
                WriteLn(' CardBus latency ',wrhex(infotbl($1b)),'h');
              end;
          end;


{ explore the capabilities list, if present }
        if not summary then
          begin
            if (infotbl(6) and $10=$10) then docapdecode;
          end;


{ do a hex-dump, if requested }
        if dumpregs then
          begin
            WriteLn;
            WriteLn(' Hex-Dump of device configuration space follows:');
            for i:=0 to 15 do
              begin
                Write('  ',wrhexw(i*16),'  ');
                for j:=i*16 to i*16+15 do
                  Write(wrhex(infotbl(j)),' ');
                Write('   ');
                for j:=i*16 to i*16+15 do
                  if infotbl(j)<32 then
                    Write('.')
                  else
                    Write(chr(infotbl(j)));
                WriteLn;
              end;
          end;

        WriteLn;
      end; (* not installermode *)

  end; (* showallinfo *)



procedure search_file(var filefound:string;const fname,pathvar:PChar);
  var
    filefound_p:array[0..260] of char;
  begin
    WinDos.FileSearch(filefound_p,fname,WinDos.GetEnvVar(pathvar));
    filefound:=StrPas(filefound_p);
  end;


begin
  {$IfDef OS2}
  Open_oemhlp;
  os2_read_bios;
  {$EndIf}

  showhelp:=false;
  businfo:=false;
  dorouting:=true;
  dopcirouting:=false;
  dumpregs:=false;
  usebios:=true;
  summary:=false;
  installermode:=false;
  {$IfDef VirtualPascal}
  vga50:=SysCtrlSelfAppType<2;
  {$Else}
  vga50:=true;
  {$EndIf}

{ the following hack permits MS-DOS display output redirection to work }
  if ioredirected then
    begin
      WriteLn('Craig Hart''s PCI+AGP bus sniffer, version ',revision,', freeware made in 1996-2001.');
      Assign(output,'');
      Rewrite(output);
    end
  else
{ code to do page pausing }
    begin
      ClrScr;
      install_pager;
    end;



  for i:=0 to 15 do irqmap[i]:=0;
  failed:=true;


  if ParamCount>0 then
    for i:=1 to ParamCount do
      begin
        cmdstr:=ParamStr(i);
        for j:=1 to Length(cmdstr) do
          cmdstr[j]:=UpCase(cmdstr[j]);
        if (Length(cmdstr)=Length('-?')) and (cmdstr[1] in ['+','-','/']) then
          case cmdstr[2] of
            'H':usebios:=false;
            'D':dumpregs:=true;
            'S':summary:=true;
            'T':dorouting:=false;
            'P':dopcirouting:=true;
            'B':businfo:=true;
            'I':installermode:=true;
            '5':vga50:=false;
          else
                showhelp:=true;
          end
        else
          showhelp:=true;

        if showhelp then
          begin
            if vga50 then
              TextMode(Co80);
            WriteLn(' Help for PCI  (Version ',revision,')');
            TextColor(DarkGray);
            WriteLn('');
            TextColor(LightGray);
            WriteLn;
            WriteLn('Usage: PCI [-H] [-D] [-S] [-T] [-B] [-P] [-?]   [] indicates optional parameter');
            WriteLn;
            WriteLn;
            WriteLn('-H : Use direct hardware access (instead of the BIOS) to retrieve PCI Info');
            WriteLn('     May be required for accurate reporting on Intel 430FX chipset+Award BIOS');
            WriteLn('-D : Do a hex-dump of each device''s entire configuration space');
            WriteLn('-S : Create a brief, summary report only; only devices and IRQs listed');
            WriteLn('-T : Disable the test ROM IRQ Routing Table function');
            WriteLn('-B : Enable display of the Bus, Device & Function information');
            WriteLn('-P : Enable display of PCI slot routing data');
            WriteLn('-I : Installer mode: produce raw data dump (for use with auto-setup programs)');
            WriteLn('-? : Displays this help screen!');
            WriteLn;
            WriteLn('PCI Supports generating reports to a file or printer using MS-DOS pipes; i.e.');
            WriteLn;
            WriteLn('  PCI -D > REPORT.TXT  (Save report to file),  PCI > LPT1:  (Print report)');
            WriteLn;
            WriteLn('PCI is written by Craig Hart, and is released as freeware, with no restictions');
            Write('on use or copying. Visit ');
            TextColor(LightCyan);
            Write('http://members.hyperlink.net.au/~chart ');
            TextColor(LightGray);
            WriteLn('for updates to');
            WriteLn('the program and the PCI Database file PCIDEVS.TXT');
            Halt(10);
          end;
      end;


{ fix up conflicting commandline switches }

  if installermode then
    begin
      dorouting:=false;
      dopcirouting:=false;
      dumpregs:=false;
      businfo:=false;
      summary:=false;
    end;

  if summary then
    begin
      dumpregs:=false;
      dopcirouting:=false;
      dorouting:=false;
    end;



  if not installermode then
    begin
      { calculate datafile searchpath: exefile path,... }
      pcidevs_path:=ParamStr(0);
      while (not (pcidevs_path[Length(pcidevs_path)] in ['\','/'])) and (pcidevs_path<>'') do
        Dec(pcidevs_path[0]);

      pcidevs_txt:=FSearch('pcidevs.txt',pcidevs_path);

      if pcidevs_txt='' then
        search_file(pcidevs_txt,'pcidevs.txt','PATH');

      if pcidevs_txt='' then
        search_file(pcidevs_txt,'pcidevs.txt','DPATH');


      if pcidevs_txt<>'' then
        begin
          Assign2(f,pcidevs_txt);
          {$i-}
          Reset2(f);
          {$i+}
        end;

      if (IOResult<>0) or (pcidevs_txt='') then
        begin
          WriteLn('PCI Halted:');
          WriteLn;
          WriteLn('Sorry, I cannot locate my PCIDEVS.TXT datafile!!!');
          Halt(10);
        end;
      Close2(f);
      {$i+}
    end;



  if test8086<2 then
    begin
      WriteLn('PCI Halted:');
      WriteLn;
      WriteLn('The PC Must be at least a 386 to possibly have a PCI or AGP bus!');
      Halt(1);
    end;

{ Look for PCI BIOS }
  pci_present_test;

  if failed then
    begin
      WriteLn('PCI Halted:');
      WriteLn;
      WriteLn('No PCI BIOS was detected! (NB: I don''t work under Windows NT & Windows 2000!)');
      Halt(2);
    end;



{ OK, we have PCI... do our stuff.. }


  if not installermode then
    begin

      if not ioredirected then
        if vga50 then
          TextMode(Co80+Font8x8);

      WriteLn(' Craig Hart''s PCI+AGP bus sniffer, version ',revision,', freeware made in 1996-2001.');
      WriteLn;
      Write('PCI BIOS Version ',PCIverhi,'.',wrhex(PCIverlo),' found!');

      if summary then WriteLn('                                  (Summary Report)') else

      WriteLn;
      WriteLn('Number of PCI Busses : ',PCI_hibus+1);
      Write('PCI Characteristics  : ');
      if PCIchar and  1=1  then Write('Config Mechanism 1 ')
      else usebios:=true; { must use BIOS if no cfg mech 1 supported }
      if PCIchar and  2=2  then Write('Config Mechanism 2 ');
      if PCIchar and 16=16 then Write('Special Cycle Mechanism 1 ');
      if PCIchar and 32=32 then Write('Special Cycle Mechanism 2 ');
      WriteLn;
      WriteLn;
      Write('Searching for PCI Devices using ');
      if usebios then
        {$IfDef OS2}
        WriteLn('the OEMHLP$ driver')
        {$Else}
        WriteLn('the System BIOS')
        {$EndIf}
      else
        WriteLn('Configuration Mechanism 1');
      WriteLn;

    end; (* not installermode *)

  for bus:=Low(bustype) to High(bustype) do
    if bus<=pci_hibus then
      bustype[bus]:=bustype_PCI       { fix bugs for 440LX chipset, 2 PCI buses, AGP=1 bus! ?}
    else
      bustype[bus]:=bustype_None;


  for bus:=Low(bustype) to High(bustype) do

    if bustype[bus]<>bustype_None then

      for deviceid:=0 to $1f do
        begin

          for func:=0 to 7 do
            begin

              set_lookup_device(deviceid,func,bus);
{don't try to read cfg-space of non-existant devices: hangs some chipsets!}
              if infotbl_W(0)<>$ffff then
                begin

{ remember CardBus stuff for later; skip if far bus=0 (i.e. unconfigured) }
                  if (infotbl($19)>bus) then (* bus<>0 and not already known bus *)
                    case infotbl($e) and $7f of
                      (* 0:other *)
                      1: (* PCI-PCI (+AGP) *)
                        begin
                          (* maybe look for "AGP" in the database entry ? *)
                          if (bus=0) and ((infotbl($3e) and $08)=$08) then
                            bustype[infotbl($19)]:=bustype_AGP
                          else
                            bustype[infotbl($19)]:=bustype_PCI;
                        end;
                      2: (* CardBus *)
                        begin
                          if bustype[infotbl($19)]=bustype_None then
                            bustype[infotbl($19)]:=bustype_CardBus;
                        end;
                    end;

                  if terminate_request then Halt(9);
                  showallinfo;

{ If not multi-device device, then don't test for func 1-7 as some cards
Incorrectly answer back on all 8 function numbers!!! S3 trio64, for example - stupid!  }
                  if (func=0) and (infotbl($e) and $80=0) then
                    Break; (* func:=7; *)
                end; (* exist *)

            end; (* Function *)

        end; (* DeviceID *)

     (* Bus *)



{
  The following is an experiment with "Get IRQ Routing Info" BIOS function:
  the avid coder is free to un-comment the code and try it out: I couldn't
  make much sense out of the information returned myself!
}



  if dopcirouting then
    begin

      WriteLn;
      WriteLn('PCI slot IRQ mapping information');

      failed:=true;
      FillChar(irqbuff,SizeOf(irqbuff),$00);
      load_irqbuff;

      if not failed then
        begin
          TextColor(LightGreen);
          WriteLn(' PCI slot mapping information read successfully');
          TextColor(LightGray);
          WriteLn;


{ hex-dump table }
          if dumpregs then dohexdump;

{}
          WriteLn(' PCI slot IRQ availability listing');
          WriteLn;
          for i:=0 to (len shr 4)-1 do
            with irqbuffR.IRQ_routing_table_entry_Array[i] do
              begin
                WriteLn('  PCI Bus ',PCI_bus_number,', Device ',PCI_device_number shr 3,', Slot ',wrhex(device_slot_number));
                for j:=Low(INTABCD) to High(INTABCD) do
                  listmap(INTABCD[j].IRQ_connectivity_bit_map,'   INT'+Chr(Ord('A')+j)+'# can be connected to IRQs ');
                WriteLn;
              end;
          WriteLn;


{}
          WriteLn(' PCI slot INTx to IRQ-router mappings');
          WriteLn;
          WriteLn('  SLOT BUS DEV  INTA INTB INTC INTD');
          for i:=0 to (len shr 4)-1 do
            with irqbuffR.IRQ_routing_table_entry_Array[i] do
              begin
                Write('   ',wrhex(device_slot_number),'  ',PCI_bus_number:2,'  ',PCI_device_number shr 3:2);
    {           Write('   ',PCI_device_number and 3);}
                Write('   ');
                for j:=Low(INTABCD) to High(INTABCD) do
                  Write(' ',wrhex(INTABCD[j].link_value),'  ');

                set_lookup_device(PCI_device_number shr 3,
                                  PCI_device_number and 7,
                                  PCI_bus_number);

                cmpstr:=wrhexw(infotbl_W(0));
                if cmpstr<>'FFFF' then
                  begin
                    lookupven(true);
                    cmpstr:=wrhexw(infotbl_W(2));
                    lookupdev;
                  end
                else
                  Write('No Device Detected');


                WriteLn;
              end;
          WriteLn;


{}
          listmap(conmap,' IRQ''s dedicated to PCI : ');

        end
      else
        begin
          TextColor(LightRed);
          WriteLn(' Unable to read slot mapping information from PCI BIOS!');
          TextColor(LightGray);
        end;
      WriteLn;

    end; (* dopcirouting *)



{ BIOS IRQ Routing table tests }

    if dorouting then
      showroutinginfo;


{ final summarial IRQ info }

    if not installermode then
      begin
        WriteLn;
        Write('IRQ Summary: ');
        failed:=true;
        disp:=0;
        for i:=0 to 15 do if irqmap[i]>0 then Inc(disp); { count IRQs}
        for i:=0 to 15 do if irqmap[i]>0 then
          begin
            if failed then
              begin
                if disp=1 then Write('IRQ ')
                else           Write('IRQs ');
              end
            else
              Write(',');
            Write(i);
            failed:=false;
          end;
        if failed then WriteLn('No IRQ''s are used by PCI Devices!')
        else
          begin
            if disp=1 then Write(' is') else Write(' are');
            WriteLn(' used by PCI devices');
          end;

        Write('Shared IRQs: ');
        failed:=true;
        for i:=0 to 15 do if irqmap[i]>1 then
          begin
            if not failed then Write('             ');
            WriteLn('IRQ ',i,' is shared by ',irqmap[i],' PCI Devices');
            failed:=false;
          end;
        if failed then WriteLn('There are no shared PCI IRQs');

      end; (* not installermode *)

  {$IfDef OS2}
  Close_oemhlp;
  {$EndIf}
end.

