/* $Id: kThreadContainer.h,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kThreadContainer - generic module container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */
#ifndef _kThreadContainer_h_
#define _kThreadContainer_h_




/**
 * Generic module container.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kThreadContainer : public kDetailCnr
{
private:
    /** @cat private data */
    USHORT          usPid;              /* Process Indicator we're showing threads for. */
    kMenuBase *     pMenuThread;        /* Pointer to record menu. */
    kMenuBase *     pMenuCnrAll;        /* Pointer to container menu. */
    kThreadRecord * pCurRecord;         /* Pointer to the current record actual for menu action. */

    /** @cat private methods */
    BOOL    insertThreads();

    /** @cat private events */
    VOID    menuEnd(USHORT usMenuId, HWND hwndMnu); //WM_MENUEND
    VOID    command(USHORT usCmd, USHORT usSource, BOOL fPointer); //WM_COMMAND


public:
    kThreadContainer(HWND hwndDlg, ULONG ulCnrId, USHORT usPid) throw (kError);
    ~kThreadContainer();

    /** @cat events which sorrily have to be invoked from the outside... */
    VOID    cnrContextMenu(USHORT usId, PRECORDCORE pRecord);
    VOID    cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey);

    VOID    update();
};


#endif


