/* $Id: kProcessPage.cpp,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kProcessPage - Process overview dialog. (to be notebook page)
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */


/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_BASE


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#else
    #include <malloc.h>
#endif
#include <memory.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kContainer.h"
#include "kNotebookBase.h"
#include "kNotebookPageBase.h"

#include "kQuerySysState.h"
#include "kDetailBase.h"
#include "kProcessRecord.h"
#include "kProcessContainer.h"
#include "kProcessPage.h"
#include "kProcessDetails.h"
#include "kTaskMgr_defs.h"
#include "kTaskMgr.h"


/**
 * Forwards this event to the container.
 */
VOID kProcessPage::cnrContextMenu(USHORT usId, PRECORDCORE pRecord)
{
    pContainer->cnrContextMenu(usId, pRecord);
}


/**
 * Forwards this event to the container.
 */
VOID kProcessPage::cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey)
{
    pContainer->cnrEnter(usId, hwndCnr, pRecord, fKey);
}



/**
 * timer event. Update content.
 * @param     idTimer  Timer id.
 */
VOID kProcessPage::timer(ULONG idTimer)
{
    if (idTimer == idTimerRefresh)
        pContainer->update();
}




/**
 * Constructor. Calls base class constructor.
 * @param     hwndParent   Windowhandle of the parent window. Defaults to HWND_DESKTOP.
 * @param     hwndOwner    Windowhandle of the owner window.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark    Throws kError on error.
 *            Use the show()/showModal() methods to show the dialog
 */
kProcessPage::kProcessPage(kNotebookBase *pNtbk) throw (kError)
    : kNotebookPageBase(DL_KPROCESSPAGE, NULLHANDLE, pNtbk),
    pContainer(NULL)
{
    /*
     * Container border size
     */
    ptlBorder.x = 5;
    ptlBorder.y = 4;
    WinMapDlgPoints(hwnd, &ptlBorder, 1, TRUE);

    /*
     * Create detail container and fill it.
     */
    pContainer = new kProcessContainer(hwnd, KPROCPG_CNR);
    pContainer->update();

    /*
     * Start timer
     */
    idTimerRefresh = timerStart(1UL, REFRESHRATE*1000);
    ASSERT(idTimerRefresh);
}



/**
 * Desctructor stub.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark
 */
kProcessPage::~kProcessPage()
{
    if (pContainer != NULL)
        delete pContainer;
    timerStop(idTimerRefresh);
    pContainer = NULL;
}


/**
 * Move and size the container and dialog.
 * @param     prctlPage  New size of dialog.
 */
VOID  kProcessPage::ntfySized(LONG cx, LONG cy)
{
    /*
     * Resize the dialog
     */
    resizeAndMove(
        0,
        0,
        cx,
        cy);

    /*
     * Resize the container.
     */
    pContainer->resizeAndMove(
        ptlBorder.x,
        ptlBorder.y,
        cx - ptlBorder.x*2,
        cy - ptlBorder.y*2
        );
}

