/* $Id: kProcessDetails.cpp,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kProcessDetails - Process notebook.
 *
 * Copyright (c) 2000 knut st. osmundsen
 *
 */



/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_BASE


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#else
    #include <malloc.h>
#endif
#include <memory.h>
#include <process.h>
#include <stdio.h>
#include <string.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kClickDlg.h"
#include "kContainer.h"
#include "kTaskMgr_defs.h"
#include "kNotebookBase.h"
#include "kNotebookPageBase.h"

#include "kQuerySysState.h"
#include "kDetailBase.h"
#include "kModuleRecord.h"
#include "kModuleContainer.h"
#include "kObjectRecord.h"
#include "kProcessRecord.h"
#include "kProcessContainer.h"
#include "kSFNRecord.h"
#include "kSFNContainer.h"
#include "kThreadRecord.h"
#include "kThreadContainer.h"
#include "kAboutPage.h"
#include "kModulePage.h"
#include "kSFNPage.h"
#include "kProcessDetails.h"
#include "kProcessDetailsPage.h"
#include "kTaskMgr.h"



/**
 * Constructor.
 * @param     usPid        Process ID to display details for.
 * @param     hwndTaskMgr  Handle of the taskmgr window.
 */
kProcessDetails::kProcessDetails(USHORT usPid, HWND hwndTaskMgr)
: kNotebookBase(DL_KPROCESSDETAILS, NULLHANDLE, KPROCDTL_NTBK, NULLHANDLE),
kDetailBase(hwnd),
hwndOwner(hwndTaskMgr), usPid(usPid)
{
    PPROCESSDATA    pProcData;
    qsLrec_t *      pMteData;
    USHORT          hMte;
    char szTitle[278];

    /* Get process data */
    pProcData = QSGetProcessData(usPid);
    if (pProcData == NULL)
        throw(kError(ERROR_INVALID_PARAMETER, kError::dos)); /* FIXME better complaint! */
    pMteData = QSGetMteData(pProcData->pProcRec->hMte);
    if (pMteData != NULL)
        hMte = pMteData->hmte;
    else
        hMte = 0xFFFE;

    /* Set title */
    sprintf(&szTitle[0], "Pid 0x%04x - %.260s",
            usPid, pMteData != NULL && pMteData->pName != NULL ? (char*)pMteData->pName : "<unknown>");
    setTitle(&szTitle[0]);

    /* Create and insert notebook pages */
    insertPage(new kProcessDetailsPage(this, usPid), BKA_MAJOR | BKA_AUTOPAGESIZE, BKA_LAST);
    insertPage(new kModulePage(this, hMte), BKA_MAJOR, BKA_LAST);
    insertPage(new kSFNPage(this, usPid), BKA_MAJOR, BKA_LAST);

    /* Last */
    insertPage(new kAboutPage(this), BKA_MAJOR, BKA_LAST);
}



/**
 * Destructor for the kProcessDetails class.
 */
kProcessDetails::~kProcessDetails()
{
}


/**
 * Temporary size and focus fix....
 */
BOOL kProcessDetails::show()
{
    SWP swp;
    BOOL fRet = kDlgBase::show();

    /* Temporary size fix  */
    WinQueryWindowPos(hwnd, &swp);
    WinSetWindowPos(hwnd, NULLHANDLE, 0, 0, swp.cx-1, swp.cy-1, SWP_SIZE);

    /* Try set focus correctly */
    if (paPages != NULL && cPages != 0)
        WinSetFocus(HWND_DESKTOP, WinWindowFromID(paPages[0].hwnd, KPROCDTLPG_CNR_THREADS));

    return fRet;
}


/**
 * Updates the dialog contents.
 * @returns   success indicator.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark    Currently a dummy stub.
 */
BOOL kProcessDetails::update()
{
    return FALSE;
}
