/* $Id: kNotebookPageBase.h,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kNotebookPageBase (kClassLib) - base class for notebook pages.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */


#ifndef _kNotebookPageBase_h_
#define _kNotebookPageBase_h_

#ifndef _kNotebookBase_h_
class kNotebookBase;
#endif

/**
 * Base class for notebook pages. This inherits from kDlgBase.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kNotebookPageBase : public kDlgBase
{
protected:
    kNotebookBase *pNtbk;
    virtual VOID  command(USHORT usCmd, USHORT usSource, BOOL fPointer); //WM_COMMAND

public:
    kNotebookPageBase(ULONG ulResId, HMODULE hmodRes, kNotebookBase *pNtbk) throw (kError);
    ~kNotebookPageBase();

    /**@cat notifies from the notebook */
    virtual VOID  ntfyHelp();
    virtual VOID  ntfySelected();
    virtual BOOL  ntfySelectedPending();
    virtual VOID  ntfyDeselected();
    virtual BOOL  ntfyDeselectedPending();
    virtual VOID  ntfySized(LONG cx, LONG cy);
    virtual VOID  ntfyInserted();

    /**@cat queries used by the notebook */
    virtual PSZ   queryTabText(PSZ pszBuffer, ULONG cchBuffer);
};


#endif
